/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests.weighted;

import java.util.Collection;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.analysis.profiling.core.tree.WeightedTree;
import org.junit.Assert;
import org.junit.Test;

@NonNullByDefault
public class WeightedTreeTest {
    private static final String OBJECT_NAME1 = "obj1";
    private static final String OBJECT_NAME2 = "obj2";
    private static final String OBJECT_NAME3 = "obj3";
    private static final String OBJECT_NAME4 = "obj4";
    private static final String OBJECT_NAME5 = "obj5";

    @Test
    public void testConstructors() {
        WeightedTree wt = new WeightedTree((Object)OBJECT_NAME1);
        Assert.assertEquals((String)"default constructor name", (Object)OBJECT_NAME1, (Object)wt.getObject());
        Assert.assertEquals((String)"default constructor initial weight", (long)0L, (long)wt.getWeight());
        Assert.assertTrue((String)"default constructor no children", (boolean)wt.getChildren().isEmpty());
        Assert.assertEquals((String)"default depth", (long)1L, (long)wt.getMaxDepth());
        int initialWeight = 150;
        wt = new WeightedTree((Object)OBJECT_NAME1, (long)initialWeight);
        Assert.assertEquals((String)"constructor with weight name", (Object)OBJECT_NAME1, (Object)wt.getObject());
        Assert.assertEquals((String)"constructor with weight initial weight", (long)initialWeight, (long)wt.getWeight());
        Assert.assertTrue((String)"constructor with weight no children", (boolean)wt.getChildren().isEmpty());
        Assert.assertEquals((String)"constructor with weight depth", (long)1L, (long)wt.getMaxDepth());
    }

    @Test
    public void testSimpleMerge() {
        int initialWeight = 150;
        WeightedTree wt = new WeightedTree((Object)OBJECT_NAME1, (long)initialWeight);
        WeightedTree wt2 = new WeightedTree((Object)OBJECT_NAME1, (long)initialWeight);
        wt.merge(wt2);
        Assert.assertEquals((String)"Value after merge", (long)(initialWeight * 2), (long)wt.getWeight());
        Assert.assertEquals((String)"merged tree unmodified", (long)initialWeight, (long)wt2.getWeight());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMergeWrongObject() {
        int initialWeight = 150;
        WeightedTree wt = new WeightedTree((Object)OBJECT_NAME1, (long)initialWeight);
        WeightedTree wt2 = new WeightedTree((Object)OBJECT_NAME2, (long)initialWeight);
        wt.merge(wt2);
    }

    @Test
    public void testAddToWeight() {
        int initialWeight = 150;
        WeightedTree wt = new WeightedTree((Object)OBJECT_NAME1, (long)initialWeight);
        Assert.assertEquals((String)"initial weight", (long)initialWeight, (long)wt.getWeight());
        wt.addToWeight((long)initialWeight);
        Assert.assertEquals((String)"initial weight", (long)(initialWeight * 2), (long)wt.getWeight());
    }

    @Test
    public void testCopyOf() {
        int initialWeight = 150;
        int childWeight = 50;
        WeightedTree wt = new WeightedTree((Object)OBJECT_NAME1, (long)initialWeight);
        WeightedTree wtCopy = wt.copyOf();
        Assert.assertEquals((String)"same weight", (long)wt.getWeight(), (long)wtCopy.getWeight());
        wtCopy.addToWeight((long)initialWeight);
        Assert.assertEquals((String)"New copy weight", (long)(initialWeight * 2), (long)wtCopy.getWeight());
        Assert.assertEquals((String)"Unchanged original weight", (long)initialWeight, (long)wt.getWeight());
        WeightedTree child = new WeightedTree((Object)OBJECT_NAME1, (long)childWeight);
        wt.addChild(child);
        wtCopy = wt.copyOf();
        Assert.assertEquals((String)"Same weight", (long)wt.getWeight(), (long)wtCopy.getWeight());
        Collection children = wtCopy.getChildren();
        Assert.assertEquals((String)"No children copied", (long)1L, (long)children.size());
        WeightedTree childCopy = (WeightedTree)children.iterator().next();
        childCopy.addToWeight((long)childWeight);
        Assert.assertEquals((String)"New child copy weight", (long)(childWeight * 2), (long)childCopy.getWeight());
        Assert.assertEquals((String)"Unchanged original child weight", (long)childWeight, (long)child.getWeight());
    }

    @Test
    public void testAddChild() {
        int initialWeight = 150;
        WeightedTree wt = new WeightedTree((Object)OBJECT_NAME1, (long)initialWeight);
        int childWeight = 30;
        WeightedTree child1 = new WeightedTree((Object)OBJECT_NAME2, (long)childWeight);
        wt.addChild(child1);
        Assert.assertEquals((String)"Unchanged parent weight", (long)initialWeight, (long)wt.getWeight());
        Assert.assertEquals((String)"Unchanged child weight", (long)childWeight, (long)child1.getWeight());
        Assert.assertEquals((String)"Children of parent", (long)1L, (long)wt.getChildren().size());
        Assert.assertTrue((String)"No child to child", (boolean)child1.getChildren().isEmpty());
        WeightedTree treeChild = (WeightedTree)wt.getChildren().iterator().next();
        Assert.assertEquals((String)"Child of parent", (Object)child1, (Object)treeChild);
        WeightedTree child2 = new WeightedTree((Object)OBJECT_NAME3, (long)childWeight);
        wt.addChild(child2);
        Assert.assertEquals((String)"Unchanged parent weight", (long)initialWeight, (long)wt.getWeight());
        Assert.assertEquals((String)"Unchanged child weight", (long)childWeight, (long)child2.getWeight());
        Assert.assertEquals((String)"Children of parent", (long)2L, (long)wt.getChildren().size());
        WeightedTree child3 = new WeightedTree((Object)OBJECT_NAME2, (long)childWeight);
        wt.addChild(child3);
        Assert.assertEquals((String)"Unchanged parent weight", (long)initialWeight, (long)wt.getWeight());
        Assert.assertEquals((String)"Unchanged child weight", (long)childWeight, (long)child3.getWeight());
        Assert.assertEquals((String)"Children of parent", (long)2L, (long)wt.getChildren().size());
        Assert.assertEquals((String)"New tree child weight", (long)(childWeight * 2), (long)treeChild.getWeight());
        Assert.assertEquals((String)"Max depth", (long)2L, (long)wt.getMaxDepth());
        WeightedTree parent = new WeightedTree((Object)OBJECT_NAME4, (long)(initialWeight * 2));
        parent.addChild(wt);
        Assert.assertFalse((String)"Parent's child", (boolean)parent.getChildren().isEmpty());
        treeChild = (WeightedTree)parent.getChildren().iterator().next();
        Assert.assertEquals((String)"no children lost", (long)2L, (long)treeChild.getChildren().size());
        Assert.assertEquals((String)"Final max depth", (long)3L, (long)parent.getMaxDepth());
    }

    @Test
    public void testDeepMerge() {
        int level0Weight = 150;
        int level1Weight = 40;
        int level2Weight = 10;
        WeightedTree wtParent1 = new WeightedTree((Object)OBJECT_NAME1, (long)level0Weight);
        WeightedTree wtLevel1 = new WeightedTree((Object)OBJECT_NAME1, (long)level1Weight);
        wtLevel1.addChild(new WeightedTree((Object)OBJECT_NAME4, (long)level2Weight));
        wtLevel1.addChild(new WeightedTree((Object)OBJECT_NAME5, (long)level2Weight));
        wtParent1.addChild(wtLevel1);
        wtLevel1 = new WeightedTree((Object)OBJECT_NAME2, (long)level1Weight);
        wtLevel1.addChild(new WeightedTree((Object)OBJECT_NAME2, (long)level2Weight));
        wtParent1.addChild(wtLevel1);
        wtParent1.addChild(new WeightedTree((Object)OBJECT_NAME3, (long)level1Weight));
        WeightedTree wtParent2 = new WeightedTree((Object)OBJECT_NAME1, (long)level0Weight);
        wtLevel1 = new WeightedTree((Object)OBJECT_NAME1, (long)level1Weight);
        wtLevel1.addChild(new WeightedTree((Object)OBJECT_NAME3, (long)level2Weight));
        wtLevel1.addChild(new WeightedTree((Object)OBJECT_NAME4, (long)level2Weight));
        wtParent2.addChild(wtLevel1);
        wtLevel1 = new WeightedTree((Object)OBJECT_NAME2, (long)level1Weight);
        wtLevel1.addChild(new WeightedTree((Object)OBJECT_NAME1, (long)level2Weight));
        wtParent2.addChild(wtLevel1);
        wtLevel1 = new WeightedTree((Object)OBJECT_NAME5, (long)level1Weight);
        wtLevel1.addChild(new WeightedTree((Object)OBJECT_NAME2, (long)level2Weight));
        wtParent2.addChild(wtLevel1);
        wtParent1.merge(wtParent2);
        Assert.assertEquals((String)"Level 0 Weight", (long)(level0Weight * 2), (long)wtParent1.getWeight());
        Collection level1Children = wtParent1.getChildren();
        Assert.assertEquals((String)"Level 0 Nb children", (long)4L, (long)level1Children.size());
        Assert.assertEquals((String)"Max depth", (long)3L, (long)wtParent1.getMaxDepth());
        block34: for (WeightedTree level1Child : level1Children) {
            switch ((String)level1Child.getObject()) {
                case "obj1": {
                    Assert.assertEquals((String)"Level 1 Weight 1", (long)(level1Weight * 2), (long)level1Child.getWeight());
                    Collection level2Children = level1Child.getChildren();
                    Assert.assertEquals((String)"Level 1 Nb children 1", (long)3L, (long)level2Children.size());
                    for (WeightedTree level2Child : level2Children) {
                        switch ((String)level2Child.getObject()) {
                            case "obj3": 
                            case "obj5": {
                                Assert.assertEquals((String)"Level 2-1 Weight", (long)level2Weight, (long)level2Child.getWeight());
                                Assert.assertTrue((String)"Empty children at last level", (boolean)level2Child.getChildren().isEmpty());
                                break;
                            }
                            case "obj4": {
                                Assert.assertEquals((String)"Level 2-1 Weight", (long)(level2Weight * 2), (long)level2Child.getWeight());
                                Assert.assertTrue((String)"Empty children at last level", (boolean)level2Child.getChildren().isEmpty());
                                break;
                            }
                            default: {
                                Assert.fail((String)("Unknown child " + (String)level2Child.getObject()));
                            }
                        }
                    }
                    continue block34;
                }
                case "obj2": {
                    Assert.assertEquals((String)"Level 1 Weight 2", (long)(level1Weight * 2), (long)level1Child.getWeight());
                    Collection level2Children = level1Child.getChildren();
                    Assert.assertEquals((String)"Level 1 Nb children 2", (long)2L, (long)level2Children.size());
                    for (WeightedTree level2Child : level2Children) {
                        switch ((String)level2Child.getObject()) {
                            case "obj1": 
                            case "obj2": {
                                Assert.assertEquals((String)"Level 2-2 Weight", (long)level2Weight, (long)level2Child.getWeight());
                                Assert.assertTrue((String)"Empty children at last level", (boolean)level2Child.getChildren().isEmpty());
                                break;
                            }
                            default: {
                                Assert.fail((String)("Unknown child " + (String)level2Child.getObject()));
                            }
                        }
                    }
                    continue block34;
                }
                case "obj3": {
                    Assert.assertEquals((String)"Level 1 Weight 3", (long)level1Weight, (long)level1Child.getWeight());
                    Assert.assertTrue((String)"Empty children at last level", (boolean)level1Child.getChildren().isEmpty());
                    break;
                }
                case "obj5": {
                    Assert.assertEquals((String)"Level 1 Weight 4", (long)level1Weight, (long)level1Child.getWeight());
                    Collection level2Children = level1Child.getChildren();
                    Assert.assertEquals((String)"Level 1 Nb children 4", (long)1L, (long)level2Children.size());
                    for (WeightedTree level2Child : level2Children) {
                        switch ((String)level2Child.getObject()) {
                            case "obj2": {
                                Assert.assertEquals((String)"Level 2-2 Weight", (long)level2Weight, (long)level2Child.getWeight());
                                Assert.assertTrue((String)"Empty children at last level", (boolean)level2Child.getChildren().isEmpty());
                                break;
                            }
                            default: {
                                Assert.fail((String)("Unknown child " + (String)level2Child.getObject()));
                            }
                        }
                    }
                    continue block34;
                }
                default: {
                    Assert.fail((String)("Unknown child " + (String)level1Child.getObject()));
                }
            }
        }
    }
}

