/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.util;

import java.io.DataInput;
import java.io.IOException;
import org.eclipse.tracecompass.internal.ctf.core.utils.LEB128;
import org.junit.Assert;
import org.junit.Test;

public class LEB128Test {
    @Test
    public void testZeroUnsigned() throws IOException {
        byte[] test = new byte[]{0};
        long expected = 0L;
        Assert.assertEquals((long)expected, (long)LEB128.readUnsignedLeb((DataInput)new ByteStream(test)));
    }

    @Test
    public void testZeroSigned() throws IOException {
        byte[] test = new byte[]{0};
        long expected = 0L;
        Assert.assertEquals((long)expected, (long)LEB128.readSignedLeb((DataInput)new ByteStream(test)));
    }

    @Test
    public void testOneUnsigned() throws IOException {
        byte[] test = new byte[]{1};
        long expected = 1L;
        Assert.assertEquals((long)expected, (long)LEB128.readUnsignedLeb((DataInput)new ByteStream(test)));
    }

    @Test
    public void testOneSigned() throws IOException {
        byte[] test = new byte[]{1};
        long expected = 1L;
        Assert.assertEquals((long)expected, (long)LEB128.readSignedLeb((DataInput)new ByteStream(test)));
    }

    @Test
    public void testBigUnsigned() throws IOException {
        byte[] test = new byte[]{-27, -114, 38};
        long expected = 624485L;
        Assert.assertEquals((long)expected, (long)LEB128.readUnsignedLeb((DataInput)new ByteStream(test)));
    }

    @Test
    public void testBigSignedPositive() throws IOException {
        byte[] test = new byte[]{-64, -60, 7};
        long expected = 123456L;
        Assert.assertEquals((long)expected, (long)LEB128.readSignedLeb((DataInput)new ByteStream(test)));
    }

    @Test
    public void testBigSignedNegative() throws IOException {
        byte[] test = new byte[]{-64, -69, 120};
        long expected = -123456L;
        Assert.assertEquals((long)expected, (long)LEB128.readSignedLeb((DataInput)new ByteStream(test)));
    }

    @Test
    public void testVeryBigUnsigned() throws IOException {
        byte[] test = new byte[]{-35, -121, -41, -14, -121, -108, 38};
        long expected = 167815081739229L;
        Assert.assertEquals((long)expected, (long)LEB128.readUnsignedLeb((DataInput)new ByteStream(test)));
    }

    @Test
    public void testVeryBigSignedPositive() throws IOException {
        byte[] test = new byte[]{-35, -121, -41, -14, -121, -108, 38};
        long expected = 167815081739229L;
        Assert.assertEquals((long)expected, (long)LEB128.readSignedLeb((DataInput)new ByteStream(test)));
    }

    @Test
    public void testVeryBigSignedNegative() throws IOException {
        byte[] test = new byte[]{-93, -8, -88, -115, -8, -21, 89};
        long expected = -167815081739229L;
        Assert.assertEquals((long)expected, (long)LEB128.readSignedLeb((DataInput)new ByteStream(test)));
    }

    private static class ByteStream
    implements DataInput {
        private final byte[] data;
        private int pos = 0;

        public ByteStream(byte[] input) {
            this.data = input;
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            Assert.fail();
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            Assert.fail();
        }

        @Override
        public int skipBytes(int n) throws IOException {
            Assert.fail();
            return 0;
        }

        @Override
        public boolean readBoolean() throws IOException {
            Assert.fail();
            return false;
        }

        @Override
        public byte readByte() throws IOException {
            try {
                byte value = this.data[this.pos++];
                return value;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return 0;
            }
        }

        @Override
        public int readUnsignedByte() throws IOException {
            Assert.fail();
            return 0;
        }

        @Override
        public short readShort() throws IOException {
            Assert.fail();
            return 0;
        }

        @Override
        public int readUnsignedShort() throws IOException {
            Assert.fail();
            return 0;
        }

        @Override
        public char readChar() throws IOException {
            Assert.fail();
            return '\u0000';
        }

        @Override
        public int readInt() throws IOException {
            Assert.fail();
            return 0;
        }

        @Override
        public long readLong() throws IOException {
            Assert.fail();
            return 0L;
        }

        @Override
        public float readFloat() throws IOException {
            Assert.fail();
            return 0.0f;
        }

        @Override
        public double readDouble() throws IOException {
            Assert.fail();
            return 0.0;
        }

        @Override
        public String readLine() throws IOException {
            Assert.fail();
            return null;
        }

        @Override
        public String readUTF() throws IOException {
            Assert.fail();
            return null;
        }
    }
}

