/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.datastore.core.tests.historytree.classic;

import java.io.File;
import java.io.IOException;
import org.eclipse.tracecompass.datastore.core.interval.HTInterval;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.datastore.core.tests.historytree.AbstractHistoryTreeTestBase;
import org.eclipse.tracecompass.datastore.core.tests.stubs.historytree.classic.ClassicHistoryTreeStub;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.AbstractHistoryTree;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.classic.ClassicNode;

public class ClassicHistoryTreeTest
extends AbstractHistoryTreeTestBase<HTInterval, ClassicNode<HTInterval>> {
    private static final HTInterval DEFAULT_OBJECT = new HTInterval(0L, 0L);

    protected ClassicHistoryTreeStub createHistoryTree(File stateHistoryFile, int blockSize, int maxChildren, int providerVersion, long treeStart) throws IOException {
        return new ClassicHistoryTreeStub(stateHistoryFile, blockSize, maxChildren, providerVersion, treeStart);
    }

    protected ClassicHistoryTreeStub createHistoryTree(File existingStateFile, int expectedProviderVersion) throws IOException {
        return new ClassicHistoryTreeStub(existingStateFile, expectedProviderVersion);
    }

    @Override
    protected HTInterval createInterval(long start, long end) {
        return new HTInterval(start, end);
    }

    @Override
    protected long fillValues(AbstractHistoryTree<HTInterval, ClassicNode<HTInterval>> ht, int fillSize, long start) {
        int nbValues = fillSize / DEFAULT_OBJECT.getSizeOnDisk();
        int i = 0;
        while (i < nbValues) {
            ht.insert((IHTInterval)new HTInterval(start + (long)i, start + (long)i + 1L));
            ++i;
        }
        return start + (long)nbValues;
    }
}

