/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.shared;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.internal.pcap.core.util.PcapHelper;

public enum PcapTestTrace {
    BAD_PCAPFILE("..", "..", "pcap", "org.eclipse.tracecompass.pcap.core.tests", "rsc", "BadPcapFile.pcap"),
    EMPTY_PCAP("..", "..", "pcap", "org.eclipse.tracecompass.pcap.core.tests", "rsc", "EmptyPcap.pcap"),
    MOSTLY_TCP("..", "..", "pcap", "org.eclipse.tracecompass.pcap.core.tests", "rsc", "mostlyTCP.pcap"),
    MOSTLY_UDP("..", "..", "pcap", "org.eclipse.tracecompass.pcap.core.tests", "rsc", "mostlyUDP.pcap"),
    SHORT_BIG_ENDIAN("..", "..", "pcap", "org.eclipse.tracecompass.pcap.core.tests", "rsc", "Short_BigEndian.pcap"),
    SHORT_LITTLE_ENDIAN("..", "..", "pcap", "org.eclipse.tracecompass.pcap.core.tests", "rsc", "Short_LittleEndian.pcap"),
    BENCHMARK_TRACE("..", "..", "pcap", "org.eclipse.tracecompass.pcap.core.tests", "rsc", "benchmarkTrace.pcap"),
    KERNEL_DIRECTORY("..", "..", "pcap", "org.eclipse.tracecompass.pcap.core.tests", "rsc", "kernel"),
    KERNEL_TRACE("..", "..", "pcap", "org.eclipse.tracecompass.pcap.core.tests", "rsc", "kernel", "channel0_0");

    private final @NonNull Path fPath;

    private PcapTestTrace(String first, String ... more) {
        Path path;
        this.fPath = path = FileSystems.getDefault().getPath(first, more);
    }

    public @NonNull Path getPath() {
        return this.fPath;
    }

    public PcapFile getTrace() throws BadPcapFileException, IOException {
        return PcapHelper.getPcapFile((Path)this.fPath);
    }

    public boolean exists() {
        return !Files.notExists(this.fPath, new LinkOption[0]);
    }
}

