/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.stream;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.pcap.core.endpoint.ProtocolEndpoint;
import org.eclipse.tracecompass.internal.pcap.core.endpoint.ProtocolEndpointPair;
import org.eclipse.tracecompass.internal.pcap.core.filter.IPacketFilter;
import org.eclipse.tracecompass.internal.pcap.core.filter.PacketFilterByProtocol;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.packet.Packet;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.protocol.pcap.PcapPacket;
import org.eclipse.tracecompass.internal.pcap.core.stream.PacketStream;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.internal.pcap.core.util.PcapHelper;

public class PacketStreamBuilder {
    private final IPacketFilter fPacketFilter;
    private final PcapProtocol fProtocol;
    private final Map<Integer, PacketStream> fStreams;
    private final Map<ProtocolEndpointPair, Integer> fIDs;
    private int fCurrentId = 0;

    public PacketStreamBuilder(PcapProtocol protocol) {
        this.fProtocol = protocol;
        this.fPacketFilter = new PacketFilterByProtocol(protocol);
        this.fStreams = new HashMap<Integer, PacketStream>();
        this.fIDs = new HashMap<ProtocolEndpointPair, Integer>();
    }

    public synchronized @Nullable PacketStream getStream(int id) {
        return this.fStreams.get(id);
    }

    public synchronized @Nullable PacketStream getStream(ProtocolEndpoint endpointA, ProtocolEndpoint endpointB) {
        ProtocolEndpointPair set = new ProtocolEndpointPair(endpointA, endpointB);
        Integer id = (Integer)NonNullUtils.checkNotNull((Object)this.fIDs.get(set));
        return this.fStreams.get(id);
    }

    public synchronized Iterable<PacketStream> getStreams() {
        LinkedList<PacketStream> iterable = new LinkedList<PacketStream>(this.fStreams.values());
        return iterable;
    }

    public synchronized void addPacketToStream(PcapPacket packet) {
        if (this.fPacketFilter.accepts(packet)) {
            @Nullable Packet newPacket = packet.getPacket(this.fProtocol);
            if (newPacket == null) {
                return;
            }
            ProtocolEndpointPair endpointSet = new ProtocolEndpointPair(newPacket);
            if (!this.fIDs.containsKey(endpointSet)) {
                this.fIDs.put(endpointSet, this.fCurrentId);
                PacketStream stream = new PacketStream(this.fProtocol, this.fCurrentId, endpointSet);
                stream.add(packet);
                this.fStreams.put(this.fCurrentId, stream);
                ++this.fCurrentId;
            } else {
                Integer id = this.fIDs.get(endpointSet);
                ((PacketStream)NonNullUtils.checkNotNull((Object)this.fStreams.get(id))).add(packet);
            }
        }
    }

    public PcapProtocol getProtocol() {
        return this.fProtocol;
    }

    public void clear() {
        this.fStreams.clear();
        this.fIDs.clear();
        this.fCurrentId = 0;
    }

    public synchronized int getNbStreams() {
        return this.fStreams.size();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void parsePcapFile(Path filePath) throws IOException, BadPcapFileException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            PcapPacket packet;
            PcapFile pcapFile;
            block11: {
                pcapFile = PcapHelper.getPcapFile(filePath);
                finally {
                    if (pcapFile != null) break block11;
                    return;
                }
            }
            try {
                packet = pcapFile.parseNextPacket();
                if (packet == null) {
                    return;
                }
            }
            catch (BadPacketException badPacketException) {
                // empty catch block
            }
            {
                this.addPacketToStream(packet);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }
}

