/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.tracecompass.internal.statesystem.core.AttributeTree;
import org.eclipse.tracecompass.internal.statesystem.core.StateSystem;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.junit.Assert;
import org.junit.Test;

public class AttributeTreeTest {
    private static final String THREADS = "Threads";
    private static final String[] NAMES = new String[]{"", "\u0000", "a", "\"", "/", "\\", "ab", "\"\"", "a/", "a\\", "/a", "//", "/\\", "\\a", "\\/", "\\\\", "abc", "\"/\"", "ab/", "ab\\", "a/b", "a//", "a/\\", "a\\b", "a\\/", "a\\\\", "/ab", "/a/", "/a\\", "//a", "///", "//\\", "/\\a", "/\\/", "/\\\\", "\\ab", "\\a/", "\\a\\", "\\/a", "\\//", "\\/\\", "\\\\a", "\\\\/", "\\\\\\"};
    private static final String STATUS = "Status";

    @Test
    public void testAttributeTreeFileStorage() throws IOException {
        File file = File.createTempFile("AttributeTreeTest", ".ht");
        IStateHistoryBackend backend1 = StateHistoryBackendFactory.createNullBackend((String)"test");
        StateSystem ss1 = new StateSystem(backend1);
        AttributeTree attributeTree1 = new AttributeTree(ss1);
        String[] stringArray = NAMES;
        int n = NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            String[] path = new String[]{THREADS, name, STATUS};
            attributeTree1.getQuarkAndAdd(-1, path);
            ++n2;
        }
        attributeTree1.writeSelf(file, 0L);
        ss1.dispose();
        IStateHistoryBackend backend2 = StateHistoryBackendFactory.createNullBackend((String)"test");
        StateSystem ss2 = new StateSystem(backend2);
        try {
            Throwable throwable = null;
            stringArray = null;
            try (FileInputStream fis = new FileInputStream(file);){
                AttributeTree attributeTree2 = new AttributeTree(ss2, fis);
                String[] stringArray2 = NAMES;
                int n3 = NAMES.length;
                int n4 = 0;
                while (n4 < n3) {
                    String name = stringArray2[n4];
                    Object[] path = new String[]{THREADS, name, STATUS};
                    int quark = attributeTree2.getQuarkDontAdd(-1, (String[])path);
                    Assert.assertNotEquals((long)-2L, (long)quark);
                    Assert.assertArrayEquals((Object[])path, (Object[])attributeTree2.getFullAttributePathArray(quark));
                    Assert.assertEquals((Object)name, (Object)attributeTree2.getAttributeName(attributeTree2.getParentAttributeQuark(quark)));
                    ++n4;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            ss2.dispose();
            file.delete();
        }
    }
}

