/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.ui.swtbot.tests.latency;

import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.table.AbstractSegmentStoreTableViewer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.latency.PatternLatencyTableView;
import org.eclipse.tracecompass.tmf.analysis.xml.ui.swtbot.tests.latency.PatternLatencyViewTestBase;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.junit.Assert;
import org.junit.Test;

public class PatternLatencyTableViewTest
extends PatternLatencyViewTestBase {
    private static final String COLUMN_HEADER = "Name";
    private static final String SYSTEM_CALL_PREFIX = "sys_";
    private static final String VIEW_ID = "org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.latencytable";
    private static final String VIEW_TITLE = "Latency Table";
    private PatternLatencyTableView fLatencyView;
    private AbstractSegmentStoreTableViewer fTable;

    @Test
    public void testData() {
        this.getTable();
        WaitUtils.waitForJobs();
        Assert.assertNotNull((Object)this.fTable);
        SWTBotTable tableBot = new SWTBotTable(this.fTable.getTableViewer().getTable());
        fBot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)SYSTEM_CALL_PREFIX, (int)0, (int)3));
        tableBot.header(COLUMN_HEADER).click();
        fBot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)SYSTEM_CALL_PREFIX, (int)0, (int)3));
        tableBot.header(COLUMN_HEADER).click();
        fBot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)SYSTEM_CALL_PREFIX, (int)0, (int)3));
    }

    private void getTable() {
        SWTBotView viewBot = fBot.viewById(VIEW_ID);
        final IViewReference viewReference = viewBot.getViewReference();
        IViewPart viewPart = (IViewPart)UIThreadRunnable.syncExec((Result)new Result<IViewPart>(){

            public IViewPart run() {
                return viewReference.getView(true);
            }
        });
        Assert.assertNotNull((Object)viewPart);
        if (!(viewPart instanceof PatternLatencyTableView)) {
            Assert.fail((String)"Could not instanciate view");
        }
        this.fLatencyView = (PatternLatencyTableView)viewPart;
        this.fTable = this.fLatencyView.getSegmentStoreViewer();
        Assert.assertNotNull((Object)this.fTable);
    }

    @Override
    protected String getViewId() {
        return VIEW_ID;
    }

    @Override
    protected String getViewTitle() {
        return VIEW_TITLE;
    }
}

