/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.event.lookup.aspect;

import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.MultiAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.junit.Assert;
import org.junit.Test;

public class MultiAspectTest {
    private static final @NonNull TmfEvent DUMMY_EVENT = new TmfEvent(null, -1L, TmfTimestamp.BIG_BANG, null, null);
    private final @NonNull TmfCpuAspect fAspectNull = new TmfCpuAspect(){

        public @Nullable Integer resolve(@NonNull ITmfEvent event) {
            return null;
        }
    };
    private final @NonNull TmfCpuAspect fAspect0 = new TmfCpuAspect(){

        public @Nullable Integer resolve(@NonNull ITmfEvent event) {
            return 0;
        }
    };
    private final @NonNull TmfCpuAspect fAspect1 = new TmfCpuAspect(){

        public @Nullable Integer resolve(@NonNull ITmfEvent event) {
            return 1;
        }
    };
    private long fFooImplRet = 0L;
    private long fBarImplRet = 0L;

    @Test
    public void testResolve() {
        ITmfEventAspect fMultiAspect0 = MultiAspect.create((Iterable)ImmutableList.of((Object)this.fAspectNull), TmfCpuAspect.class);
        ITmfEventAspect fMultiAspect1 = MultiAspect.create((Iterable)ImmutableList.of((Object)this.fAspect0), TmfCpuAspect.class);
        ITmfEventAspect fMultiAspect2 = MultiAspect.create((Iterable)ImmutableList.of((Object)this.fAspect1), TmfCpuAspect.class);
        ITmfEventAspect fMultiAspect3 = MultiAspect.create((Iterable)ImmutableList.of((Object)this.fAspectNull, (Object)this.fAspect0), TmfCpuAspect.class);
        ITmfEventAspect fMultiAspect4 = MultiAspect.create((Iterable)ImmutableList.of((Object)this.fAspectNull, (Object)this.fAspect1), TmfCpuAspect.class);
        ITmfEventAspect fMultiAspect5 = MultiAspect.create((Iterable)ImmutableList.of((Object)this.fAspect0, (Object)this.fAspect1), TmfCpuAspect.class);
        ITmfEventAspect fMultiAspect6 = MultiAspect.create((Iterable)ImmutableList.of((Object)this.fAspectNull, (Object)this.fAspect0, (Object)this.fAspect1), TmfCpuAspect.class);
        ITmfEventAspect fMultiAspect7 = MultiAspect.create((Iterable)ImmutableList.of((Object)this.fAspectNull, (Object)this.fAspect1, (Object)this.fAspect0), TmfCpuAspect.class);
        ITmfEventAspect fMultiAspect8 = MultiAspect.create((Iterable)ImmutableList.of((Object)this.fAspect0, (Object)this.fAspectNull), TmfCpuAspect.class);
        ITmfEventAspect fMultiAspect9 = MultiAspect.create((Iterable)ImmutableList.of((Object)this.fAspect1, (Object)this.fAspectNull), TmfCpuAspect.class);
        ITmfEventAspect fMultiAspect10 = MultiAspect.create((Iterable)ImmutableList.of((Object)this.fAspect1, (Object)this.fAspect0), TmfCpuAspect.class);
        TmfEvent event = DUMMY_EVENT;
        Assert.assertNotNull((Object)fMultiAspect0);
        Assert.assertNotNull((Object)fMultiAspect1);
        Assert.assertNotNull((Object)fMultiAspect2);
        Assert.assertNotNull((Object)fMultiAspect3);
        Assert.assertNotNull((Object)fMultiAspect4);
        Assert.assertNotNull((Object)fMultiAspect5);
        Assert.assertNotNull((Object)fMultiAspect6);
        Assert.assertNotNull((Object)fMultiAspect7);
        Assert.assertNotNull((Object)fMultiAspect8);
        Assert.assertNotNull((Object)fMultiAspect9);
        Assert.assertNotNull((Object)fMultiAspect10);
        Assert.assertEquals(null, (Object)fMultiAspect0.resolve((ITmfEvent)event));
        Assert.assertEquals((Object)0, (Object)fMultiAspect1.resolve((ITmfEvent)event));
        Assert.assertEquals((Object)1, (Object)fMultiAspect2.resolve((ITmfEvent)event));
        Assert.assertEquals((Object)0, (Object)fMultiAspect3.resolve((ITmfEvent)event));
        Assert.assertEquals((Object)1, (Object)fMultiAspect4.resolve((ITmfEvent)event));
        Assert.assertEquals((Object)0, (Object)fMultiAspect5.resolve((ITmfEvent)event));
        Assert.assertEquals((Object)0, (Object)fMultiAspect6.resolve((ITmfEvent)event));
        Assert.assertEquals((Object)1, (Object)fMultiAspect7.resolve((ITmfEvent)event));
        Assert.assertEquals((Object)0, (Object)fMultiAspect8.resolve((ITmfEvent)event));
        Assert.assertEquals((Object)1, (Object)fMultiAspect9.resolve((ITmfEvent)event));
        Assert.assertEquals((Object)1, (Object)fMultiAspect10.resolve((ITmfEvent)event));
    }

    @Test
    public void testCreateHappy() {
        ITmfEventAspect aspect = MultiAspect.create((Iterable)ImmutableList.of((Object)new FooImpl(), (Object)new BarImpl()), FooAspect.class);
        Assert.assertNotNull((Object)aspect);
        Assert.assertEquals((Object)this.fFooImplRet, (Object)aspect.resolve((ITmfEvent)DUMMY_EVENT));
        long orig = this.fFooImplRet;
        this.fFooImplRet = 25L;
        Assert.assertEquals((Object)this.fFooImplRet, (Object)aspect.resolve((ITmfEvent)DUMMY_EVENT));
        this.fFooImplRet = orig;
        Assert.assertEquals((Object)this.fFooImplRet, (Object)aspect.resolve((ITmfEvent)DUMMY_EVENT));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateIllegal() {
        MultiAspect.create((Iterable)ImmutableList.of((Object)new FooImpl(), (Object)new BarImpl()), BarAspect.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateIllegalFrom() {
        ITmfEventAspect multi = MultiAspect.create((Iterable)ImmutableList.of((Object)this.fAspect0, (Object)this.fAspect1), TmfCpuAspect.class);
        Assert.assertNotNull((Object)multi);
        ITmfEventAspect other = MultiAspect.create((Iterable)ImmutableList.of((Object)this.fAspectNull, (Object)this.fAspect0), TmfCpuAspect.class);
        Assert.assertNotNull((Object)other);
        MultiAspect.createFrom((ITmfEventAspect)multi, (ITmfEventAspect)other);
    }

    @Test
    public void testCreateFrom() {
        ITmfEventAspect multi = MultiAspect.create((Iterable)ImmutableList.of((Object)this.fAspect0, (Object)this.fAspect1), TmfCpuAspect.class);
        Assert.assertNotNull((Object)multi);
        ITmfEventAspect other = MultiAspect.createFrom((ITmfEventAspect)multi, (ITmfEventAspect)this.fAspectNull);
        Assert.assertNotEquals((Object)multi, (Object)other);
        Assert.assertEquals(multi.getClass(), other.getClass());
        Assert.assertEquals((Object)multi.resolve((ITmfEvent)DUMMY_EVENT), (Object)other.resolve((ITmfEvent)DUMMY_EVENT));
    }

    @Test
    public void testCreateFromSingle() {
        ITmfEventAspect multi = MultiAspect.createFrom((ITmfEventAspect)this.fAspect0, (ITmfEventAspect)this.fAspect1);
        Assert.assertNotEquals((Object)this.fAspect0, (Object)multi);
        Assert.assertEquals((Object)this.fAspect0.resolve((ITmfEvent)DUMMY_EVENT), (Object)multi.resolve((ITmfEvent)DUMMY_EVENT));
    }

    static interface BarAspect
    extends FooAspect {
    }

    class BarImpl
    implements BarAspect {
        BarImpl() {
        }

        public @NonNull String getName() {
            return "Bar";
        }

        public @NonNull String getHelpText() {
            return "Bar help";
        }

        public @Nullable Long resolve(@NonNull ITmfEvent event) {
            return MultiAspectTest.this.fBarImplRet;
        }
    }

    static interface FooAspect
    extends ITmfEventAspect<Long> {
    }

    class FooImpl
    implements FooAspect {
        FooImpl() {
        }

        public @NonNull String getName() {
            return "Foo";
        }

        public @NonNull String getHelpText() {
            return "Foo help";
        }

        public @Nullable Long resolve(@NonNull ITmfEvent event) {
            return MultiAspectTest.this.fFooImplRet;
        }
    }
}

