/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.filter;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.core.filter.TmfCollapseFilter;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.event.collapse.ITmfCollapsibleEvent;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TmfCollapseFilterTest {
    private static final TmfTestTrace STUB_TRACE = TmfTestTrace.A_TEST_10K;
    private CollapsibleEvent fCollapsibleEvent1 = new CollapsibleEvent(true);
    private CollapsibleEvent fCollapsibleEvent2 = new CollapsibleEvent(true);
    private CollapsibleEvent fCollapsibleEvent3 = new CollapsibleEvent(false);
    private NonCollapsibleEvent fNonCollapsibleEvent1 = new NonCollapsibleEvent();
    private TmfCollapseFilter fFilter = new TmfCollapseFilter();
    private @NonNull ITmfTrace fTrace = STUB_TRACE.getTrace();

    @After
    public void disposeTrace() {
        this.fTrace.dispose();
    }

    @Test
    public void testMatches() {
        TmfCollapseFilter filter = new TmfCollapseFilter();
        Assert.assertTrue((boolean)filter.matches((ITmfEvent)this.fCollapsibleEvent1));
        Assert.assertFalse((boolean)filter.matches((ITmfEvent)this.fCollapsibleEvent2));
        Assert.assertFalse((boolean)filter.matches((ITmfEvent)this.fCollapsibleEvent1));
        Assert.assertFalse((boolean)filter.matches((ITmfEvent)this.fCollapsibleEvent2));
        Assert.assertTrue((boolean)filter.matches((ITmfEvent)this.fNonCollapsibleEvent1));
        Assert.assertTrue((boolean)filter.matches((ITmfEvent)this.fNonCollapsibleEvent1));
        Assert.assertTrue((boolean)filter.matches((ITmfEvent)this.fCollapsibleEvent1));
        Assert.assertFalse((boolean)filter.matches((ITmfEvent)this.fCollapsibleEvent2));
        Assert.assertTrue((boolean)filter.matches((ITmfEvent)this.fCollapsibleEvent3));
    }

    @Test
    public void testInterfaces() {
        Assert.assertNull((String)"getParent()", (Object)this.fFilter.getParent());
        Assert.assertEquals((String)"getName()", (Object)"Collapse", (Object)this.fFilter.getNodeName());
        Assert.assertEquals((String)"hasChildren()", (Object)false, (Object)this.fFilter.hasChildren());
        Assert.assertEquals((String)"getChildrenCount()", (long)0L, (long)this.fFilter.getChildrenCount());
        Assert.assertEquals((String)"getChildren()", (long)0L, (long)this.fFilter.getChildren().length);
    }

    @Test
    public void testClone() {
        Assert.assertNotEquals((String)"clone()", (Object)this.fFilter, (Object)this.fFilter.clone());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetChild() {
        this.fFilter.getChild(0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemove() {
        this.fFilter.remove();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveChild() {
        this.fFilter.removeChild(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddChild() {
        this.fFilter.addChild(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testReplaceChild() {
        this.fFilter.replaceChild(0, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetValidChildren() {
        this.fFilter.getValidChildren();
    }

    private class CollapsibleEvent
    extends TmfEvent
    implements ITmfCollapsibleEvent {
        private final boolean fIsCollapsible;

        CollapsibleEvent(boolean isCollapsible) {
            super(TmfCollapseFilterTest.this.fTrace, -1L, null, null, null);
            this.fIsCollapsible = isCollapsible;
        }

        public boolean isCollapsibleWith(ITmfEvent otherEvent) {
            return ((CollapsibleEvent)otherEvent).fIsCollapsible;
        }
    }

    private class NonCollapsibleEvent
    extends PlatformObject
    implements ITmfEvent {
        private NonCollapsibleEvent() {
        }

        public ITmfTrace getTrace() {
            return TmfCollapseFilterTest.this.fTrace;
        }

        public long getRank() {
            return 0L;
        }

        public ITmfTimestamp getTimestamp() {
            return TmfTimestamp.fromNanos((long)100L);
        }

        public ITmfEventType getType() {
            return new TmfEventType();
        }

        public String getName() {
            return "";
        }

        public ITmfEventField getContent() {
            return new TmfEventField("testField", (Object)"test", null);
        }
    }
}

