/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.request;

import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.core.component.TmfProviderManager;
import org.eclipse.tracecompass.internal.tmf.core.request.TmfCoalescedEventRequest;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.filter.ITmfFilter;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.tests.stubs.request.TmfEventRequestStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;

public class TmfEventRequestIntegrationTest {
    @Rule
    public TestRule globalTimeout = new Timeout(2L, TimeUnit.MINUTES);
    private static final TmfTestTrace TEST_TRACE = TmfTestTrace.A_TEST_10K;
    private static TmfTraceStub fTrace = null;

    @BeforeClass
    public static void setUp() {
        try {
            fTrace = new TmfTraceStub(TEST_TRACE.getFullPath(), 1000, false, null);
            TmfSignalManager.deregister((Object)((Object)fTrace));
            fTrace.indexTrace(true);
        }
        catch (TmfTraceException e) {
            e.printStackTrace();
            Assert.fail((String)"Error setting up test trace");
        }
    }

    @AfterClass
    public static void tearDown() {
        if (fTrace != null) {
            fTrace.dispose();
            fTrace = null;
            Assert.assertEquals((long)0L, (long)TmfProviderManager.getProviders(ITmfEvent.class).length);
        }
    }

    @Test
    public void testSingleRequestException() throws InterruptedException {
        TmfTraceStub trace = fTrace;
        TmfEventRequestStub requestFail = new TmfEventRequestStub(ITmfEvent.class, TmfTimeRange.ETERNITY, 2, 0, ITmfEventRequest.ExecutionType.BACKGROUND, 0){

            @Override
            public void handleData(@NonNull ITmfEvent data) {
                throw new IllegalArgumentException();
            }
        };
        trace.sendRequest((ITmfEventRequest)requestFail);
        requestFail.waitForCompletion();
        Assert.assertTrue((boolean)requestFail.isCompleted());
        Assert.assertFalse((boolean)requestFail.isCancelled());
        Assert.assertTrue((boolean)requestFail.isFailed());
    }

    @Test
    public void testRequestException() throws InterruptedException {
        TmfTraceStub trace = fTrace;
        TmfCoalescedEventRequest allRequests = new TmfCoalescedEventRequest(ITmfEvent.class, TmfTimeRange.ETERNITY, 2L, 0, ITmfEventRequest.ExecutionType.BACKGROUND, 0);
        TmfEventRequestStub requestOk = new TmfEventRequestStub(ITmfEvent.class, TmfTimeRange.ETERNITY, 2, 0, ITmfEventRequest.ExecutionType.BACKGROUND, 0);
        requestOk.setProviderFilter((ITmfFilter)trace);
        allRequests.addRequest((ITmfEventRequest)requestOk);
        TmfEventRequestStub requestFail = new TmfEventRequestStub(ITmfEvent.class, TmfTimeRange.ETERNITY, 2, 0, ITmfEventRequest.ExecutionType.BACKGROUND, 0){

            @Override
            public void handleData(@NonNull ITmfEvent data) {
                throw new IllegalArgumentException();
            }
        };
        requestFail.setProviderFilter((ITmfFilter)trace);
        allRequests.addRequest((ITmfEventRequest)requestFail);
        trace.sendRequest((ITmfEventRequest)allRequests);
        requestOk.waitForCompletion();
        requestFail.waitForCompletion();
        Assert.assertTrue((boolean)requestOk.isCompleted());
        Assert.assertFalse((boolean)requestOk.isCancelled());
        Assert.assertFalse((boolean)requestOk.isFailed());
        Assert.assertTrue((boolean)requestFail.isCompleted());
        Assert.assertFalse((boolean)requestFail.isCancelled());
        Assert.assertTrue((boolean)requestFail.isFailed());
    }
}

