/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.signal;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.tracecompass.tmf.core.component.ITmfComponent;
import org.eclipse.tracecompass.tmf.core.component.TmfComponent;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalThrottler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TmfSignalThrottlerTest {
    private MySender sender;
    private MyListener listener;

    @Before
    public void setUp() {
        this.sender = new MySender();
        this.listener = new MyListener();
    }

    @After
    public void tearDown() {
        this.sender.dispose();
        this.listener.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOneChannel() {
        MySignal sig1 = new MySignal(this.sender, 0);
        MySignal sig2 = new MySignal(this.sender, 0);
        MySignal sig3 = new MySignal(this.sender, 0);
        TmfSignalThrottlerTest tmfSignalThrottlerTest = this;
        synchronized (tmfSignalThrottlerTest) {
            this.sender.sendSignal(sig1);
            this.sender.sendSignal(sig2);
            this.sender.sendSignal(sig3);
        }
        TmfSignalThrottlerTest.sleep(5000L);
        Assert.assertEquals((long)1L, (long)this.listener.nbReceived[0]);
        Assert.assertEquals((long)0L, (long)this.listener.nbReceived[1]);
        Assert.assertEquals((long)0L, (long)this.listener.nbReceived[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleChannels() {
        ArrayList<MySignal> signals = new ArrayList<MySignal>();
        signals.add(new MySignal(this.sender, 0));
        signals.add(new MySignal(this.sender, 0));
        signals.add(new MySignal(this.sender, 0));
        signals.add(new MySignal(this.sender, 1));
        signals.add(new MySignal(this.sender, 1));
        signals.add(new MySignal(this.sender, 1));
        signals.add(new MySignal(this.sender, 2));
        signals.add(new MySignal(this.sender, 2));
        signals.add(new MySignal(this.sender, 2));
        Collections.shuffle(signals);
        TmfSignalThrottlerTest tmfSignalThrottlerTest = this;
        synchronized (tmfSignalThrottlerTest) {
            for (MySignal sig : signals) {
                this.sender.sendSignal(sig);
            }
        }
        TmfSignalThrottlerTest.sleep(5000L);
        int[] nArray = this.listener.nbReceived;
        int n = this.listener.nbReceived.length;
        int n2 = 0;
        while (n2 < n) {
            int nb = nArray[n2];
            Assert.assertEquals((long)1L, (long)nb);
            ++n2;
        }
    }

    @Test
    public void testDelay() {
        MySignal sig1 = new MySignal(this.sender, 0);
        MySignal sig2 = new MySignal(this.sender, 0);
        MySignal sig3 = new MySignal(this.sender, 0);
        this.sender.sendSignal(sig1);
        TmfSignalThrottlerTest.sleep(2000L);
        this.sender.sendSignal(sig2);
        TmfSignalThrottlerTest.sleep(2000L);
        this.sender.sendSignal(sig3);
        TmfSignalThrottlerTest.sleep(2000L);
        Assert.assertEquals((long)3L, (long)this.listener.nbReceived[0]);
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public class MyListener
    extends TmfComponent {
        int[] nbReceived;

        public MyListener() {
            super("MyListener");
            this.nbReceived = new int[3];
        }

        @TmfSignalHandler
        public void receiveSignal(MySignal sig) {
            int n = sig.getChannel();
            this.nbReceived[n] = this.nbReceived[n] + 1;
        }
    }

    private class MySender
    extends TmfComponent {
        private final TmfSignalThrottler[] throttlers;

        MySender() {
            super("MySender");
            this.throttlers = new TmfSignalThrottler[]{new TmfSignalThrottler((ITmfComponent)this, 200L), new TmfSignalThrottler((ITmfComponent)this, 500L), new TmfSignalThrottler((ITmfComponent)this, 1000L)};
        }

        void sendSignal(MySignal signal) {
            this.throttlers[signal.getChannel()].queue((TmfSignal)signal);
        }

        public void dispose() {
            super.dispose();
            TmfSignalThrottler[] tmfSignalThrottlerArray = this.throttlers;
            int n = this.throttlers.length;
            int n2 = 0;
            while (n2 < n) {
                TmfSignalThrottler elem = tmfSignalThrottlerArray[n2];
                elem.dispose();
                ++n2;
            }
        }
    }

    private class MySignal
    extends TmfSignal {
        private final int channel;

        public MySignal(MySender source, int channel) {
            super((Object)source);
            this.channel = channel;
        }

        public int getChannel() {
            return this.channel;
        }
    }
}

