/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.uml2sd;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.uml2sd.TmfSyncSequenceDiagramEvent;
import org.junit.Assert;
import org.junit.Test;

public class TmfSyncSequenceDiagramEventTest {
    private final @NonNull String fTypeId = "Some type";
    private final @NonNull String fLabel0 = "label1";
    private final @NonNull String fLabel1 = "label2";
    private final String[] fLabels = new String[]{"label1", "label2"};
    private final ITmfTimestamp fTimestamp1 = TmfTimestamp.create((long)12345L, (int)2);
    private final TmfEventType fType = new TmfEventType("Some type", TmfEventField.makeRoot((String[])this.fLabels));
    private final ITmfEvent fEvent1;
    private final TmfEventField fContent1 = new TmfEventField(":root:", (Object)"Some content", null);

    public TmfSyncSequenceDiagramEventTest() {
        this.fEvent1 = new TmfEvent(null, -1L, this.fTimestamp1, (ITmfEventType)this.fType, (ITmfEventField)this.fContent1);
    }

    @Test
    public void testTmfSyncSequenceDiagramEvent() {
        TmfSyncSequenceDiagramEvent event = null;
        try {
            event = new TmfSyncSequenceDiagramEvent(null, null, null, null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"testTmfSyncSequenceDiagramEvent", (boolean)e.getMessage().contains("startEvent=null"));
        }
        try {
            event = new TmfSyncSequenceDiagramEvent(this.fEvent1, null, null, null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"testTmfSyncSequenceDiagramEvent", (boolean)e.getMessage().contains("sender=null"));
        }
        try {
            event = new TmfSyncSequenceDiagramEvent(this.fEvent1, "sender", null, null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"testTmfSyncSequenceDiagramEvent", (boolean)e.getMessage().contains("receiver=null"));
        }
        try {
            event = new TmfSyncSequenceDiagramEvent(this.fEvent1, "sender", "receiver", null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"testTmfSyncSequenceDiagramEvent", (boolean)e.getMessage().contains("name=null"));
        }
        try {
            event = new TmfSyncSequenceDiagramEvent(this.fEvent1, "sender", "receiver", "signal");
            Assert.assertEquals((String)"testTmfSyncSequenceDiagramEvent", (long)0L, (long)event.getStartTime().compareTo(this.fTimestamp1));
            Assert.assertEquals((String)"testTmfSyncSequenceDiagramEvent", (Object)"sender", (Object)event.getSender());
            Assert.assertEquals((String)"testTmfSyncSequenceDiagramEvent", (Object)"receiver", (Object)event.getReceiver());
            Assert.assertEquals((String)"testTmfSyncSequenceDiagramEvent", (Object)"signal", (Object)event.getName());
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }
}

