/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.filter.TmfFilterHelper;
import org.eclipse.tracecompass.tmf.core.filter.ITmfFilter;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

@NonNullByDefault
public class TraceCompassFilter {
    private final @Nullable ITmfFilter fEventFilter;
    private final Collection<String> fRegex;
    private static final Map<ITmfTrace, TraceCompassFilter> FILTER_MAP = new WeakHashMap<ITmfTrace, TraceCompassFilter>();

    private TraceCompassFilter(@Nullable ITmfFilter filter, Collection<String> regex) {
        this.fEventFilter = filter;
        this.fRegex = regex;
    }

    public static synchronized TraceCompassFilter fromEventFilter(ITmfFilter filter, ITmfTrace trace) {
        TraceCompassFilter traceCompassFilter = new TraceCompassFilter(filter, Collections.singleton(TmfFilterHelper.getRegexFromFilter(filter)));
        FILTER_MAP.put(trace, traceCompassFilter);
        return traceCompassFilter;
    }

    public static synchronized TraceCompassFilter fromRegex(Collection<String> regex, ITmfTrace trace) {
        ITmfFilter filter = TmfFilterHelper.buildFilterFromRegex(regex, trace);
        TraceCompassFilter traceCompassFilter = new TraceCompassFilter(filter, regex);
        FILTER_MAP.put(trace, traceCompassFilter);
        return traceCompassFilter;
    }

    public @Nullable ITmfFilter getEventFilter() {
        return this.fEventFilter;
    }

    public Collection<String> getRegexes() {
        return this.fRegex;
    }

    @TmfSignalHandler
    public static synchronized void traceClosed(TmfTraceClosedSignal signal) {
        FILTER_MAP.remove(signal.getTrace());
    }

    public static @Nullable TraceCompassFilter getFilterForTrace(ITmfTrace trace) {
        return FILTER_MAP.get(trace);
    }
}

