/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.AbstractTracePackageOperation;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageTraceElement;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;

public abstract class AbstractGenerateManifestOperation
extends AbstractTracePackageOperation {
    protected static final Pattern GROUP_PATTERN = Pattern.compile("\\(group(\\d+)\\)");
    protected static final String METADATA_FILE_NAME = "metadata";
    protected Map<Pattern, TracePackageTraceElement> fTemplatePatternsToTraceElements;

    public AbstractGenerateManifestOperation(String fileName) {
        super(fileName);
    }

    protected Map<Pattern, TracePackageTraceElement> generatePatterns(TracePackageElement[] templateElements) {
        HashMap<Pattern, TracePackageTraceElement> templatePatterns = new HashMap<Pattern, TracePackageTraceElement>();
        TracePackageElement[] tracePackageElementArray = templateElements;
        int n = templateElements.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement[] children;
            TracePackageElement templateElement = tracePackageElementArray[n2];
            if (templateElement instanceof TracePackageTraceElement && (children = templateElement.getChildren()) != null) {
                TracePackageElement[] tracePackageElementArray2 = children;
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    TracePackageElement child = tracePackageElementArray2[n4];
                    if (child instanceof TracePackageFilesElement) {
                        TracePackageFilesElement tracePackageFilesElement = (TracePackageFilesElement)child;
                        Pattern pattern = Pattern.compile(tracePackageFilesElement.getFileName());
                        templatePatterns.put(pattern, (TracePackageTraceElement)templateElement);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return templatePatterns;
    }

    protected Map.Entry<Pattern, TracePackageTraceElement> getMatchingTemplateElement(IPath fullArchivePath) {
        for (Map.Entry<Pattern, TracePackageTraceElement> entry : this.fTemplatePatternsToTraceElements.entrySet()) {
            if (!(TmfTraceType.isDirectoryTraceType((String)entry.getValue().getTraceType()) ? this.matchesDirectoryTrace(fullArchivePath, entry) : entry.getKey().matcher(fullArchivePath.toPortableString()).matches())) continue;
            return entry;
        }
        return null;
    }

    protected boolean matchesDirectoryTrace(IPath archivePath, Map.Entry<Pattern, TracePackageTraceElement> entry) {
        if (archivePath.lastSegment().equals(METADATA_FILE_NAME)) {
            IPath archiveParentPath = archivePath.removeLastSegments(1);
            if (entry.getKey().matcher(archiveParentPath.toPortableString()).matches() && TmfTraceType.isDirectoryTraceType((String)entry.getValue().getTraceType())) {
                return true;
            }
        }
        return false;
    }

    protected String substituteGroups(String traceName, Pattern fileNamePattern, String fileName) {
        Object newString = traceName;
        Matcher fileNameMatcher = fileNamePattern.matcher(fileName);
        fileNameMatcher.find();
        int groupCount = fileNameMatcher.groupCount();
        Matcher matcher = GROUP_PATTERN.matcher((CharSequence)newString);
        while (matcher.find()) {
            String substitutedString;
            int groupNo;
            if (matcher.groupCount() != 1 || (groupNo = Integer.parseInt(matcher.group(1))) > groupCount || (substitutedString = ((String)newString).substring(0, matcher.start()) + fileNameMatcher.group(groupNo) + ((String)newString).substring(matcher.end())).equals(newString)) continue;
            newString = substitutedString;
            matcher = GROUP_PATTERN.matcher((CharSequence)newString);
        }
        return newString;
    }
}

