/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.StringUtils;
import org.springframework.validation.MessageCodesResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessageCodesResolver
implements MessageCodesResolver,
Serializable {
    public static final String CODE_SEPARATOR = ".";
    private String prefix = "";

    public void setPrefix(String prefix) {
        this.prefix = prefix != null ? prefix : "";
    }

    protected String getPrefix() {
        return this.prefix;
    }

    @Override
    public String[] resolveMessageCodes(String errorCode, String objectName) {
        return new String[]{this.postProcessMessageCode(String.valueOf(errorCode) + CODE_SEPARATOR + objectName), this.postProcessMessageCode(errorCode)};
    }

    @Override
    public String[] resolveMessageCodes(String errorCode, String objectName, String field, Class<?> fieldType) {
        ArrayList<String> codeList = new ArrayList<String>();
        ArrayList<String> fieldList = new ArrayList<String>();
        this.buildFieldList(field, fieldList);
        for (String fieldInList : fieldList) {
            codeList.add(this.postProcessMessageCode(String.valueOf(errorCode) + CODE_SEPARATOR + objectName + CODE_SEPARATOR + fieldInList));
        }
        int dotIndex = field.lastIndexOf(46);
        if (dotIndex != -1) {
            this.buildFieldList(field.substring(dotIndex + 1), fieldList);
        }
        for (String fieldInList : fieldList) {
            codeList.add(this.postProcessMessageCode(String.valueOf(errorCode) + CODE_SEPARATOR + fieldInList));
        }
        if (fieldType != null) {
            codeList.add(this.postProcessMessageCode(String.valueOf(errorCode) + CODE_SEPARATOR + fieldType.getName()));
        }
        codeList.add(this.postProcessMessageCode(errorCode));
        return StringUtils.toStringArray(codeList);
    }

    protected void buildFieldList(String field, List<String> fieldList) {
        fieldList.add(field);
        String plainField = field;
        int keyIndex = plainField.lastIndexOf(91);
        while (keyIndex != -1) {
            int endKeyIndex = plainField.indexOf(93, keyIndex);
            if (endKeyIndex != -1) {
                plainField = String.valueOf(plainField.substring(0, keyIndex)) + plainField.substring(endKeyIndex + 1);
                fieldList.add(plainField);
                keyIndex = plainField.lastIndexOf(91);
                continue;
            }
            keyIndex = -1;
        }
    }

    protected String postProcessMessageCode(String code) {
        return String.valueOf(this.getPrefix()) + code;
    }
}

