/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.bval.util.AccessStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldAccess
extends AccessStrategy {
    private final Field field;

    public FieldAccess(final Field field) {
        this.field = field;
        if (!field.isAccessible()) {
            FieldAccess.run(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    field.setAccessible(true);
                    return null;
                }
            });
        }
    }

    @Override
    public Object get(Object instance) {
        try {
            return this.field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public ElementType getElementType() {
        return ElementType.FIELD;
    }

    @Override
    public Type getJavaType() {
        return this.field.getGenericType();
    }

    @Override
    public String getPropertyName() {
        return this.field.getName();
    }

    public String toString() {
        return this.field.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldAccess that = (FieldAccess)o;
        return this.field.equals(that.field);
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    private static <T> T run(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return action.run();
    }
}

