/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.examples.templates.java.utils;

import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.functionblock.Event;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.Operation;

public class ModelHelper {
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";

    public static boolean isReadable(Property property, FunctionBlock fb) {
        String getterName = GETTER_PREFIX + property.getName();
        return ModelHelper.findOperationByName(getterName, fb) != null;
    }

    public static boolean isWritable(Property property, FunctionBlock fb) {
        String setterName = SETTER_PREFIX + property.getName();
        return ModelHelper.findOperationByName(setterName, fb) != null;
    }

    public static boolean isEventable(Property property, FunctionBlock fb) {
        return ModelHelper.findEventByName(property.getName(), fb) != null;
    }

    public static Operation findOperationByName(String operationName, FunctionBlock fb) {
        for (Operation operation : fb.getOperations()) {
            if (!operation.getName().equalsIgnoreCase(operationName)) continue;
            return operation;
        }
        return null;
    }

    public static Event findEventByName(String eventName, FunctionBlock fb) {
        for (Event event : fb.getEvents()) {
            if (!event.getName().equalsIgnoreCase(eventName)) continue;
            return event;
        }
        return null;
    }
}

