/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={AllCleanRule.class})
public class TestESLint {
    private IProject project;

    @BeforeEach
    public void setUpProject() throws Exception {
        InputStream eslintRc;
        String projectName = String.valueOf(this.getClass().getName()) + System.nanoTime();
        IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        IPath projectLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(projectName);
        desc.setLocation(projectLocation);
        File projectDirectory = projectLocation.toFile();
        projectDirectory.mkdir();
        Throwable throwable = null;
        Object var6_11 = null;
        try {
            eslintRc = this.getClass().getResourceAsStream("/testProjects/eslint/.eslintrc");
            try {
                Files.copy(eslintRc, new File(projectDirectory, ".eslintrc").toPath(), new CopyOption[0]);
            }
            finally {
                if (eslintRc != null) {
                    eslintRc.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var6_11 = null;
        try {
            eslintRc = this.getClass().getResourceAsStream("/testProjects/eslint/tsconfig.json");
            try {
                Files.copy(eslintRc, new File(projectDirectory, "tsconfig.json").toPath(), new CopyOption[0]);
            }
            finally {
                if (eslintRc != null) {
                    eslintRc.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var6_11 = null;
        try {
            eslintRc = this.getClass().getResourceAsStream("/testProjects/eslint/package.json");
            try {
                Files.copy(eslintRc, new File(projectDirectory, "package.json").toPath(), new CopyOption[0]);
            }
            finally {
                if (eslintRc != null) {
                    eslintRc.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        throwable = null;
        var6_11 = null;
        try {
            eslintRc = this.getClass().getResourceAsStream("/testProjects/eslint/ESLintProj.js");
            try {
                Files.copy(eslintRc, new File(projectDirectory, "ESLintProj.js").toPath(), new CopyOption[0]);
            }
            finally {
                if (eslintRc != null) {
                    eslintRc.close();
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
        throwable = null;
        var6_11 = null;
        try {
            eslintRc = this.getClass().getResourceAsStream("/testProjects/eslint/ESLintProj.js");
            try {
                Files.copy(eslintRc, new File(projectDirectory, "ESLintProj.ts").toPath(), new CopyOption[0]);
            }
            finally {
                if (eslintRc != null) {
                    eslintRc.close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        Process dependencyInstaller = new ProcessBuilder(NodeJSManager.getNpmLocation().getAbsolutePath(), "install").directory(projectDirectory).start();
        Assertions.assertEquals((int)0, (int)dependencyInstaller.waitFor(), (String)"npm install didn't complete properly");
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        this.project.create(desc, null);
        this.project.open(null);
    }

    @Test
    public void testESLintDiagnostics() throws Exception {
        IFile file = this.project.getFile("ESLintProj.js");
        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        this.assertESLintIndentMarkerExists(file);
        file = this.project.getFile("ESLintProj.ts");
        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        this.assertESLintIndentMarkerExists(file);
    }

    private void assertESLintIndentMarkerExists(final IFile file) throws PartInitException {
        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 10000L), (String)"Diagnostic not published");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0)[0].getAttribute("message", null).toLowerCase().contains("indentation");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L), (String)"Diagnostic content is incorrect");
    }
}

