"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Original code forked from https://github.com/Quramy/ts-graphql-plugin
Object.defineProperty(exports, "__esModule", { value: true });
exports.isTagged = exports.isTaggedLiteral = exports.findAllNodes = exports.findNode = exports.relative = void 0;
const regexp_1 = require("./util/regexp");
function relative(from, to) {
    return {
        line: to.line - from.line,
        character: to.line === from.line ? to.character - from.character : to.character,
    };
}
exports.relative = relative;
function findNode(typescript, sourceFile, position) {
    function find(node) {
        if (position >= node.getStart() && position < node.getEnd()) {
            return typescript.forEachChild(node, find) || node;
        }
    }
    return find(sourceFile);
}
exports.findNode = findNode;
function findAllNodes(typescript, sourceFile, cond) {
    const result = [];
    function find(node) {
        if (cond(node)) {
            result.push(node);
            return;
        }
        else {
            typescript.forEachChild(node, find);
        }
    }
    find(sourceFile);
    return result;
}
exports.findAllNodes = findAllNodes;
function isTaggedLiteral(typescript, node, tags) {
    if (!node || !node.parent) {
        return false;
    }
    if (node.parent.kind !== typescript.SyntaxKind.TaggedTemplateExpression) {
        return false;
    }
    const tagNode = node.parent;
    return isTagged(tagNode, tags);
}
exports.isTaggedLiteral = isTaggedLiteral;
function isTagged(node, tags) {
    const text = node.tag.getText();
    return tags.some(tag => text === tag
        || new RegExp(`$${(0, regexp_1.escapeRegExp)(tag)}\\s*^`).test(text)
        || text.startsWith(tag + '.')
        || text.endsWith('.' + tag)
        || text.startsWith(tag + '(')
        || text.startsWith(tag + '<')
        || text.startsWith(tag + '['));
}
exports.isTagged = isTagged;
