/// <reference types="node" />
import { EventEmitter } from 'events';
export declare type TimingsReport = {
    [stepName: string]: [number] | number;
};
export declare const stepStartedEventName = "stepStarted";
export declare const milestoneReachedEventName = "milestoneReached";
export declare const stepCompletedEventName = "stepCompleted";
export declare const requestCompletedEventName = "requestCompleted";
export interface IStepStartedEventArguments {
    stepName: string;
}
export interface IMilestoneReachedEventArguments {
    milestoneName: string;
}
export interface IStepCompletedEventArguments {
    stepName: string;
}
export interface IRequestCompletedEventArguments {
    requestName: string;
    startTime: number;
    timeTakenInMilliseconds: number;
}
export interface IObservableEvents<T> {
    events: T;
}
export interface IStepStartedEventsEmitter {
    on(event: 'stepStarted', listener: (args: IStepStartedEventArguments) => void): this;
    on(event: 'milestoneReached', listener: (args: IMilestoneReachedEventArguments) => void): this;
    removeListener(event: 'stepStarted', listener: (args: IStepStartedEventArguments) => void): this;
    removeListener(event: 'milestoneReached', listener: (args: IMilestoneReachedEventArguments) => void): this;
}
export interface FinishedStartingUpEventArguments {
    requestedContentWasDetected: boolean;
    reasonForNotDetected: string;
}
export interface IFinishedStartingUpEventsEmitter {
    on(event: 'finishedStartingUp', listener: (args: FinishedStartingUpEventArguments) => void): this;
    once(event: 'finishedStartingUp', listener: (args: FinishedStartingUpEventArguments) => void): this;
    removeListener(event: 'finishedStartingUp', listener: () => void): this;
    removeListener(event: 'finishedStartingUp', listener: () => void): this;
}
export declare class StepProgressEventsEmitter extends EventEmitter implements IStepStartedEventsEmitter, IFinishedStartingUpEventsEmitter {
    private readonly _nestedEmitters;
    constructor(_nestedEmitters?: IStepStartedEventsEmitter[]);
    emitStepStarted(stepName: string): void;
    emitMilestoneReached(milestoneName: string): void;
    emitStepCompleted(stepName: string): void;
    emitRequestCompleted(requestName: string, requestStartTime: number, timeTakenByRequestInMilliseconds: number): void;
    on(event: string, listener: (...args: any[]) => void): this;
    removeListener(event: string, listener: (...args: any[]) => void): this;
}
export interface IAllRequestProperties {
    [propertyName: string]: number[];
}
export declare class ExecutionTimingsReporter {
    private readonly _allStartTime;
    private readonly _eventsExecutionTimesInMilliseconds;
    private readonly _stepsList;
    private readonly _subscriptionManager;
    private readonly _requestProperties;
    private _currentStepStartTime;
    private _currentStepName;
    constructor();
    private recordPreviousStepAndConfigureNewStep(newStepName);
    private recordTimeTaken(eventName, sinceWhen);
    private recordTotalTimeUntilMilestone(milestoneName);
    generateReport(): {
        [stepName: string]: [number] | number;
    };
    recordRequestCompleted(requestName: string, startTime: number, timeTakenInMilliseconds: number): void;
    private addElementToArrayProperty<T>(object, propertyName, elementToAdd);
    subscribeTo(eventEmitter: EventEmitter): void;
}
