/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.hash;

import gnu.crypto.hash.BaseHash;
import gnu.crypto.util.Util;

public class MD4
extends BaseHash {
    private static final int DIGEST_LENGTH = 16;
    private static final int BLOCK_LENGTH = 64;
    private static final int A = 1732584193;
    private static final int B = -271733879;
    private static final int C = -1732584194;
    private static final int D = 271733878;
    private static final String DIGEST0 = "31D6CFE0D16AE931B73C59D7E0C089C0";
    private static Boolean valid;
    private final int[] X = new int[16];
    private int a;
    private int b;
    private int c;
    private int d;

    public MD4() {
        super("md4", 16, 64);
    }

    private MD4(MD4 that) {
        this();
        this.a = that.a;
        this.b = that.b;
        this.c = that.c;
        this.d = that.d;
        this.count = that.count;
        this.buffer = (byte[])that.buffer.clone();
    }

    public Object clone() {
        return new MD4(this);
    }

    protected byte[] getResult() {
        byte[] digest = new byte[]{(byte)this.a, (byte)(this.a >>> 8), (byte)(this.a >>> 16), (byte)(this.a >>> 24), (byte)this.b, (byte)(this.b >>> 8), (byte)(this.b >>> 16), (byte)(this.b >>> 24), (byte)this.c, (byte)(this.c >>> 8), (byte)(this.c >>> 16), (byte)(this.c >>> 24), (byte)this.d, (byte)(this.d >>> 8), (byte)(this.d >>> 16), (byte)(this.d >>> 24)};
        return digest;
    }

    protected void resetContext() {
        this.a = 1732584193;
        this.b = -271733879;
        this.c = -1732584194;
        this.d = 271733878;
    }

    public boolean selfTest() {
        if (valid == null) {
            valid = new Boolean(DIGEST0.equals(Util.toString(new MD4().digest())));
        }
        return valid;
    }

    protected byte[] padBuffer() {
        int n = (int)(this.count % 64L);
        int padding = n < 56 ? 56 - n : 120 - n;
        byte[] pad = new byte[padding + 8];
        pad[0] = -128;
        long bits = this.count << 3;
        pad[padding++] = (byte)bits;
        pad[padding++] = (byte)(bits >>> 8);
        pad[padding++] = (byte)(bits >>> 16);
        pad[padding++] = (byte)(bits >>> 24);
        pad[padding++] = (byte)(bits >>> 32);
        pad[padding++] = (byte)(bits >>> 40);
        pad[padding++] = (byte)(bits >>> 48);
        pad[padding] = (byte)(bits >>> 56);
        return pad;
    }

    protected void transform(byte[] in, int offset) {
        int i = 0;
        boolean n = false;
        while (i < 16) {
            this.X[i] = in[offset++] & 0xFF | (in[offset++] & 0xFF) << 8 | (in[offset++] & 0xFF) << 16 | in[offset++] << 24;
            ++i;
        }
        int aa = this.a;
        int bb = this.b;
        int cc = this.c;
        int dd = this.d;
        this.a += (this.b & this.c | ~this.b & this.d) + this.X[0];
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a & this.b | ~this.a & this.c) + this.X[1];
        this.d = this.d << 7 | this.d >>> 25;
        this.c += (this.d & this.a | ~this.d & this.b) + this.X[2];
        this.c = this.c << 11 | this.c >>> 21;
        this.b += (this.c & this.d | ~this.c & this.a) + this.X[3];
        this.b = this.b << 19 | this.b >>> 13;
        this.a += (this.b & this.c | ~this.b & this.d) + this.X[4];
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a & this.b | ~this.a & this.c) + this.X[5];
        this.d = this.d << 7 | this.d >>> 25;
        this.c += (this.d & this.a | ~this.d & this.b) + this.X[6];
        this.c = this.c << 11 | this.c >>> 21;
        this.b += (this.c & this.d | ~this.c & this.a) + this.X[7];
        this.b = this.b << 19 | this.b >>> 13;
        this.a += (this.b & this.c | ~this.b & this.d) + this.X[8];
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a & this.b | ~this.a & this.c) + this.X[9];
        this.d = this.d << 7 | this.d >>> 25;
        this.c += (this.d & this.a | ~this.d & this.b) + this.X[10];
        this.c = this.c << 11 | this.c >>> 21;
        this.b += (this.c & this.d | ~this.c & this.a) + this.X[11];
        this.b = this.b << 19 | this.b >>> 13;
        this.a += (this.b & this.c | ~this.b & this.d) + this.X[12];
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a & this.b | ~this.a & this.c) + this.X[13];
        this.d = this.d << 7 | this.d >>> 25;
        this.c += (this.d & this.a | ~this.d & this.b) + this.X[14];
        this.c = this.c << 11 | this.c >>> 21;
        this.b += (this.c & this.d | ~this.c & this.a) + this.X[15];
        this.b = this.b << 19 | this.b >>> 13;
        this.a += (this.b & (this.c | this.d) | this.c & this.d) + this.X[0] + 1518500249;
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a & (this.b | this.c) | this.b & this.c) + this.X[4] + 1518500249;
        this.d = this.d << 5 | this.d >>> 27;
        this.c += (this.d & (this.a | this.b) | this.a & this.b) + this.X[8] + 1518500249;
        this.c = this.c << 9 | this.c >>> 23;
        this.b += (this.c & (this.d | this.a) | this.d & this.a) + this.X[12] + 1518500249;
        this.b = this.b << 13 | this.b >>> 19;
        this.a += (this.b & (this.c | this.d) | this.c & this.d) + this.X[1] + 1518500249;
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a & (this.b | this.c) | this.b & this.c) + this.X[5] + 1518500249;
        this.d = this.d << 5 | this.d >>> 27;
        this.c += (this.d & (this.a | this.b) | this.a & this.b) + this.X[9] + 1518500249;
        this.c = this.c << 9 | this.c >>> 23;
        this.b += (this.c & (this.d | this.a) | this.d & this.a) + this.X[13] + 1518500249;
        this.b = this.b << 13 | this.b >>> 19;
        this.a += (this.b & (this.c | this.d) | this.c & this.d) + this.X[2] + 1518500249;
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a & (this.b | this.c) | this.b & this.c) + this.X[6] + 1518500249;
        this.d = this.d << 5 | this.d >>> 27;
        this.c += (this.d & (this.a | this.b) | this.a & this.b) + this.X[10] + 1518500249;
        this.c = this.c << 9 | this.c >>> 23;
        this.b += (this.c & (this.d | this.a) | this.d & this.a) + this.X[14] + 1518500249;
        this.b = this.b << 13 | this.b >>> 19;
        this.a += (this.b & (this.c | this.d) | this.c & this.d) + this.X[3] + 1518500249;
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a & (this.b | this.c) | this.b & this.c) + this.X[7] + 1518500249;
        this.d = this.d << 5 | this.d >>> 27;
        this.c += (this.d & (this.a | this.b) | this.a & this.b) + this.X[11] + 1518500249;
        this.c = this.c << 9 | this.c >>> 23;
        this.b += (this.c & (this.d | this.a) | this.d & this.a) + this.X[15] + 1518500249;
        this.b = this.b << 13 | this.b >>> 19;
        this.a += (this.b ^ this.c ^ this.d) + this.X[0] + 1859775393;
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a ^ this.b ^ this.c) + this.X[8] + 1859775393;
        this.d = this.d << 9 | this.d >>> 23;
        this.c += (this.d ^ this.a ^ this.b) + this.X[4] + 1859775393;
        this.c = this.c << 11 | this.c >>> 21;
        this.b += (this.c ^ this.d ^ this.a) + this.X[12] + 1859775393;
        this.b = this.b << 15 | this.b >>> 17;
        this.a += (this.b ^ this.c ^ this.d) + this.X[2] + 1859775393;
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a ^ this.b ^ this.c) + this.X[10] + 1859775393;
        this.d = this.d << 9 | this.d >>> 23;
        this.c += (this.d ^ this.a ^ this.b) + this.X[6] + 1859775393;
        this.c = this.c << 11 | this.c >>> 21;
        this.b += (this.c ^ this.d ^ this.a) + this.X[14] + 1859775393;
        this.b = this.b << 15 | this.b >>> 17;
        this.a += (this.b ^ this.c ^ this.d) + this.X[1] + 1859775393;
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a ^ this.b ^ this.c) + this.X[9] + 1859775393;
        this.d = this.d << 9 | this.d >>> 23;
        this.c += (this.d ^ this.a ^ this.b) + this.X[5] + 1859775393;
        this.c = this.c << 11 | this.c >>> 21;
        this.b += (this.c ^ this.d ^ this.a) + this.X[13] + 1859775393;
        this.b = this.b << 15 | this.b >>> 17;
        this.a += (this.b ^ this.c ^ this.d) + this.X[3] + 1859775393;
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a ^ this.b ^ this.c) + this.X[11] + 1859775393;
        this.d = this.d << 9 | this.d >>> 23;
        this.c += (this.d ^ this.a ^ this.b) + this.X[7] + 1859775393;
        this.c = this.c << 11 | this.c >>> 21;
        this.b += (this.c ^ this.d ^ this.a) + this.X[15] + 1859775393;
        this.b = this.b << 15 | this.b >>> 17;
        this.a += aa;
        this.b += bb;
        this.c += cc;
        this.d += dd;
    }
}

