/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.hash;

import gnu.crypto.hash.BaseHash;
import gnu.crypto.util.Util;

public class MD5
extends BaseHash {
    private static final int BLOCK_SIZE = 64;
    private static final String DIGEST0 = "D41D8CD98F00B204E9800998ECF8427E";
    private static Boolean valid;
    private final int[] X = new int[16];
    private int h0;
    private int h1;
    private int h2;
    private int h3;

    public MD5() {
        super("md5", 16, 64);
    }

    private MD5(MD5 md) {
        this();
        this.h0 = md.h0;
        this.h1 = md.h1;
        this.h2 = md.h2;
        this.h3 = md.h3;
        this.count = md.count;
        this.buffer = (byte[])md.buffer.clone();
    }

    public Object clone() {
        return new MD5(this);
    }

    protected void transform(byte[] in, int offset) {
        int i = 0;
        while (i < 16) {
            this.X[i] = in[offset++] & 0xFF | (in[offset++] & 0xFF) << 8 | (in[offset++] & 0xFF) << 16 | in[offset++] << 24;
            ++i;
        }
        int A = this.h0;
        int B = this.h1;
        int C = this.h2;
        int D = this.h3;
        A = MD5.FF(A, B, C, D, this.X[0], 7, -680876936);
        D = MD5.FF(D, A, B, C, this.X[1], 12, -389564586);
        C = MD5.FF(C, D, A, B, this.X[2], 17, 606105819);
        B = MD5.FF(B, C, D, A, this.X[3], 22, -1044525330);
        A = MD5.FF(A, B, C, D, this.X[4], 7, -176418897);
        D = MD5.FF(D, A, B, C, this.X[5], 12, 1200080426);
        C = MD5.FF(C, D, A, B, this.X[6], 17, -1473231341);
        B = MD5.FF(B, C, D, A, this.X[7], 22, -45705983);
        A = MD5.FF(A, B, C, D, this.X[8], 7, 1770035416);
        D = MD5.FF(D, A, B, C, this.X[9], 12, -1958414417);
        C = MD5.FF(C, D, A, B, this.X[10], 17, -42063);
        B = MD5.FF(B, C, D, A, this.X[11], 22, -1990404162);
        A = MD5.FF(A, B, C, D, this.X[12], 7, 1804603682);
        D = MD5.FF(D, A, B, C, this.X[13], 12, -40341101);
        C = MD5.FF(C, D, A, B, this.X[14], 17, -1502002290);
        B = MD5.FF(B, C, D, A, this.X[15], 22, 1236535329);
        A = MD5.GG(A, B, C, D, this.X[1], 5, -165796510);
        D = MD5.GG(D, A, B, C, this.X[6], 9, -1069501632);
        C = MD5.GG(C, D, A, B, this.X[11], 14, 643717713);
        B = MD5.GG(B, C, D, A, this.X[0], 20, -373897302);
        A = MD5.GG(A, B, C, D, this.X[5], 5, -701558691);
        D = MD5.GG(D, A, B, C, this.X[10], 9, 38016083);
        C = MD5.GG(C, D, A, B, this.X[15], 14, -660478335);
        B = MD5.GG(B, C, D, A, this.X[4], 20, -405537848);
        A = MD5.GG(A, B, C, D, this.X[9], 5, 568446438);
        D = MD5.GG(D, A, B, C, this.X[14], 9, -1019803690);
        C = MD5.GG(C, D, A, B, this.X[3], 14, -187363961);
        B = MD5.GG(B, C, D, A, this.X[8], 20, 1163531501);
        A = MD5.GG(A, B, C, D, this.X[13], 5, -1444681467);
        D = MD5.GG(D, A, B, C, this.X[2], 9, -51403784);
        C = MD5.GG(C, D, A, B, this.X[7], 14, 1735328473);
        B = MD5.GG(B, C, D, A, this.X[12], 20, -1926607734);
        A = MD5.HH(A, B, C, D, this.X[5], 4, -378558);
        D = MD5.HH(D, A, B, C, this.X[8], 11, -2022574463);
        C = MD5.HH(C, D, A, B, this.X[11], 16, 1839030562);
        B = MD5.HH(B, C, D, A, this.X[14], 23, -35309556);
        A = MD5.HH(A, B, C, D, this.X[1], 4, -1530992060);
        D = MD5.HH(D, A, B, C, this.X[4], 11, 1272893353);
        C = MD5.HH(C, D, A, B, this.X[7], 16, -155497632);
        B = MD5.HH(B, C, D, A, this.X[10], 23, -1094730640);
        A = MD5.HH(A, B, C, D, this.X[13], 4, 681279174);
        D = MD5.HH(D, A, B, C, this.X[0], 11, -358537222);
        C = MD5.HH(C, D, A, B, this.X[3], 16, -722521979);
        B = MD5.HH(B, C, D, A, this.X[6], 23, 76029189);
        A = MD5.HH(A, B, C, D, this.X[9], 4, -640364487);
        D = MD5.HH(D, A, B, C, this.X[12], 11, -421815835);
        C = MD5.HH(C, D, A, B, this.X[15], 16, 530742520);
        B = MD5.HH(B, C, D, A, this.X[2], 23, -995338651);
        A = MD5.II(A, B, C, D, this.X[0], 6, -198630844);
        D = MD5.II(D, A, B, C, this.X[7], 10, 1126891415);
        C = MD5.II(C, D, A, B, this.X[14], 15, -1416354905);
        B = MD5.II(B, C, D, A, this.X[5], 21, -57434055);
        A = MD5.II(A, B, C, D, this.X[12], 6, 1700485571);
        D = MD5.II(D, A, B, C, this.X[3], 10, -1894986606);
        C = MD5.II(C, D, A, B, this.X[10], 15, -1051523);
        B = MD5.II(B, C, D, A, this.X[1], 21, -2054922799);
        A = MD5.II(A, B, C, D, this.X[8], 6, 1873313359);
        D = MD5.II(D, A, B, C, this.X[15], 10, -30611744);
        C = MD5.II(C, D, A, B, this.X[6], 15, -1560198380);
        B = MD5.II(B, C, D, A, this.X[13], 21, 1309151649);
        A = MD5.II(A, B, C, D, this.X[4], 6, -145523070);
        D = MD5.II(D, A, B, C, this.X[11], 10, -1120210379);
        C = MD5.II(C, D, A, B, this.X[2], 15, 718787259);
        B = MD5.II(B, C, D, A, this.X[9], 21, -343485551);
        this.h0 += A;
        this.h1 += B;
        this.h2 += C;
        this.h3 += D;
    }

    protected byte[] padBuffer() {
        int n = (int)(this.count % 64L);
        int padding = n < 56 ? 56 - n : 120 - n;
        byte[] result = new byte[padding + 8];
        result[0] = -128;
        long bits = this.count << 3;
        result[padding++] = (byte)bits;
        result[padding++] = (byte)(bits >>> 8);
        result[padding++] = (byte)(bits >>> 16);
        result[padding++] = (byte)(bits >>> 24);
        result[padding++] = (byte)(bits >>> 32);
        result[padding++] = (byte)(bits >>> 40);
        result[padding++] = (byte)(bits >>> 48);
        result[padding] = (byte)(bits >>> 56);
        return result;
    }

    protected byte[] getResult() {
        byte[] result = new byte[]{(byte)this.h0, (byte)(this.h0 >>> 8), (byte)(this.h0 >>> 16), (byte)(this.h0 >>> 24), (byte)this.h1, (byte)(this.h1 >>> 8), (byte)(this.h1 >>> 16), (byte)(this.h1 >>> 24), (byte)this.h2, (byte)(this.h2 >>> 8), (byte)(this.h2 >>> 16), (byte)(this.h2 >>> 24), (byte)this.h3, (byte)(this.h3 >>> 8), (byte)(this.h3 >>> 16), (byte)(this.h3 >>> 24)};
        return result;
    }

    protected void resetContext() {
        this.h0 = 1732584193;
        this.h1 = -271733879;
        this.h2 = -1732584194;
        this.h3 = 271733878;
    }

    public boolean selfTest() {
        if (valid == null) {
            valid = new Boolean(DIGEST0.equals(Util.toString(new MD5().digest())));
        }
        return valid;
    }

    private static final int FF(int a, int b, int c, int d, int k, int s, int i) {
        return b + ((a += (b & c | ~b & d) + k + i) << s | a >>> -s);
    }

    private static final int GG(int a, int b, int c, int d, int k, int s, int i) {
        return b + ((a += (b & d | c & ~d) + k + i) << s | a >>> -s);
    }

    private static final int HH(int a, int b, int c, int d, int k, int s, int i) {
        return b + ((a += (b ^ c ^ d) + k + i) << s | a >>> -s);
    }

    private static final int II(int a, int b, int c, int d, int k, int s, int i) {
        return b + ((a += (c ^ (b | ~d)) + k + i) << s | a >>> -s);
    }
}

