/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig;

import gnu.crypto.Registry;
import gnu.crypto.sig.IKeyPairGenerator;
import gnu.crypto.sig.dss.DSSKeyPairGenerator;
import gnu.crypto.sig.rsa.RSAKeyPairGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class KeyPairGeneratorFactory
implements Registry {
    private KeyPairGeneratorFactory() {
    }

    public static IKeyPairGenerator getInstance(String name) {
        if (name == null) {
            return null;
        }
        name = name.trim();
        IKeyPairGenerator result = null;
        if (name.equalsIgnoreCase("dsa") || name.equals("dss")) {
            result = new DSSKeyPairGenerator();
        } else if (name.equalsIgnoreCase("rsa")) {
            result = new RSAKeyPairGenerator();
        }
        return result;
    }

    public static final Set getNames() {
        HashSet<String> hs = new HashSet<String>();
        hs.add("dss");
        hs.add("rsa");
        return Collections.unmodifiableSet(hs);
    }
}

