/* testmap.c generated by valac, the Vala compiler
 * generated from testmap.vala, do not modify */

/* testmap.vala
 *
 * Copyright (C) 2008  Jürg Billeter, Maciej Piechotka
 * Copyright (C) 2009  Didier Villevalois, Julien Peeters
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 * 	Julien Peeters <contact@julienpeeters.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_MAP_TESTS (map_tests_get_type ())
#define MAP_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP_TESTS, MapTests))
#define MAP_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP_TESTS, MapTestsClass))
#define IS_MAP_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP_TESTS))
#define IS_MAP_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP_TESTS))
#define MAP_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP_TESTS, MapTestsClass))

typedef struct _MapTests MapTests;
typedef struct _MapTestsClass MapTestsClass;
typedef struct _MapTestsPrivate MapTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define MAP_TESTS_TYPE_TEST_ENTRY (map_tests_test_entry_get_type ())
#define MAP_TESTS_TEST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAP_TESTS_TYPE_TEST_ENTRY, MapTestsTestEntry))
#define MAP_TESTS_TEST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAP_TESTS_TYPE_TEST_ENTRY, MapTestsTestEntryClass))
#define MAP_TESTS_IS_TEST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAP_TESTS_TYPE_TEST_ENTRY))
#define MAP_TESTS_IS_TEST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAP_TESTS_TYPE_TEST_ENTRY))
#define MAP_TESTS_TEST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAP_TESTS_TYPE_TEST_ENTRY, MapTestsTestEntryClass))

typedef struct _MapTestsTestEntry MapTestsTestEntry;
typedef struct _MapTestsTestEntryClass MapTestsTestEntryClass;
typedef struct _MapTestsTestEntryPrivate MapTestsTestEntryPrivate;
#define _k_destroy_func0(var) (((var == NULL) || (k_destroy_func == NULL)) ? NULL : (var = (k_destroy_func (var), NULL)))

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _MapTests {
	GeeTestCase parent_instance;
	MapTestsPrivate * priv;
	GeeMap* test_map;
};

struct _MapTestsClass {
	GeeTestCaseClass parent_class;
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);
struct _MapTestsTestEntry {
	GeeMapEntry parent_instance;
	MapTestsTestEntryPrivate * priv;
};

struct _MapTestsTestEntryClass {
	GeeMapEntryClass parent_class;
};

struct _MapTestsTestEntryPrivate {
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
	gpointer _key;
	gpointer _value;
};


static gpointer map_tests_test_entry_parent_class = NULL;
static gpointer map_tests_parent_class = NULL;

GType gee_test_case_get_type (void);
GType map_tests_get_type (void);
enum  {
	MAP_TESTS_DUMMY_PROPERTY
};
GeeTestCase* gee_test_case_construct (GType object_type, const char* name);
void gee_test_case_add_test (GeeTestCase* self, const char* name, GeeTestCaseTestMethod test, void* test_target);
void map_tests_test_type_correctness (MapTests* self);
static void _map_tests_test_type_correctness_gee_test_case_test_method (gpointer self);
void map_tests_test_has_key_size_is_empty (MapTests* self);
static void _map_tests_test_has_key_size_is_empty_gee_test_case_test_method (gpointer self);
void map_tests_test_keys (MapTests* self);
static void _map_tests_test_keys_gee_test_case_test_method (gpointer self);
void map_tests_test_values (MapTests* self);
static void _map_tests_test_values_gee_test_case_test_method (gpointer self);
void map_tests_test_entries (MapTests* self);
static void _map_tests_test_entries_gee_test_case_test_method (gpointer self);
void map_tests_test_set_all (MapTests* self);
static void _map_tests_test_set_all_gee_test_case_test_method (gpointer self);
void map_tests_test_unset_all (MapTests* self);
static void _map_tests_test_unset_all_gee_test_case_test_method (gpointer self);
void map_tests_test_has_all (MapTests* self);
static void _map_tests_test_has_all_gee_test_case_test_method (gpointer self);
void map_tests_test_gobject_properties (MapTests* self);
static void _map_tests_test_gobject_properties_gee_test_case_test_method (gpointer self);
MapTests* map_tests_construct (GType object_type, const char* name);
MapTestsTestEntry* map_tests_test_entry_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, gconstpointer key, gconstpointer value);
MapTestsTestEntry* map_tests_test_entry_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, gconstpointer key, gconstpointer value);
GType map_tests_test_entry_get_type (void);
#define MAP_TESTS_TEST_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MAP_TESTS_TYPE_TEST_ENTRY, MapTestsTestEntryPrivate))
enum  {
	MAP_TESTS_TEST_ENTRY_DUMMY_PROPERTY,
	MAP_TESTS_TEST_ENTRY_KEY,
	MAP_TESTS_TEST_ENTRY_VALUE,
	MAP_TESTS_TEST_ENTRY_K_TYPE,
	MAP_TESTS_TEST_ENTRY_K_DUP_FUNC,
	MAP_TESTS_TEST_ENTRY_K_DESTROY_FUNC,
	MAP_TESTS_TEST_ENTRY_V_TYPE,
	MAP_TESTS_TEST_ENTRY_V_DUP_FUNC,
	MAP_TESTS_TEST_ENTRY_V_DESTROY_FUNC
};
static void map_tests_test_entry_finalize (GObject* obj);
static void map_tests_test_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void map_tests_test_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void map_tests_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _map_tests_test_type_correctness_gee_test_case_test_method (gpointer self) {
	map_tests_test_type_correctness (self);
}


static void _map_tests_test_has_key_size_is_empty_gee_test_case_test_method (gpointer self) {
	map_tests_test_has_key_size_is_empty (self);
}


static void _map_tests_test_keys_gee_test_case_test_method (gpointer self) {
	map_tests_test_keys (self);
}


static void _map_tests_test_values_gee_test_case_test_method (gpointer self) {
	map_tests_test_values (self);
}


static void _map_tests_test_entries_gee_test_case_test_method (gpointer self) {
	map_tests_test_entries (self);
}


static void _map_tests_test_set_all_gee_test_case_test_method (gpointer self) {
	map_tests_test_set_all (self);
}


static void _map_tests_test_unset_all_gee_test_case_test_method (gpointer self) {
	map_tests_test_unset_all (self);
}


static void _map_tests_test_has_all_gee_test_case_test_method (gpointer self) {
	map_tests_test_has_all (self);
}


static void _map_tests_test_gobject_properties_gee_test_case_test_method (gpointer self) {
	map_tests_test_gobject_properties (self);
}


MapTests* map_tests_construct (GType object_type, const char* name) {
	MapTests * self;
	g_return_val_if_fail (name != NULL, NULL);
	self = (MapTests*) gee_test_case_construct (object_type, name);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] type correctness", _map_tests_test_type_correctness_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] has_key, size and is_empty", _map_tests_test_has_key_size_is_empty_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] keys", _map_tests_test_keys_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] values", _map_tests_test_values_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] entries", _map_tests_test_entries_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] set all", _map_tests_test_set_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] unset all", _map_tests_test_unset_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] has all", _map_tests_test_has_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Map] GObject properties", _map_tests_test_gobject_properties_gee_test_case_test_method, self);
	return self;
}


void map_tests_test_type_correctness (MapTests* self) {
	g_return_if_fail (self != NULL);
	g_assert (self->test_map != NULL);
	g_assert (gee_map_get_key_type (self->test_map) == G_TYPE_STRING);
	g_assert (gee_map_get_value_type (self->test_map) == G_TYPE_STRING);
}


void map_tests_test_has_key_size_is_empty (MapTests* self) {
	char* value;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	char* _tmp12_;
	char* _tmp13_;
	char* _tmp14_;
	char* _tmp15_;
	char* _tmp16_;
	char* _tmp17_;
	char* _tmp20_;
	gboolean _tmp19_;
	gpointer _tmp18_ = NULL;
	char* _tmp21_;
	char* _tmp22_;
	char* _tmp23_;
	char* _tmp26_;
	gboolean _tmp25_;
	gpointer _tmp24_ = NULL;
	char* _tmp27_;
	char* _tmp28_;
	char* _tmp29_;
	g_return_if_fail (self != NULL);
	g_assert (self->test_map != NULL);
	value = NULL;
	g_assert (!gee_map_has_key (self->test_map, "one"));
	g_assert (!gee_map_has_key (self->test_map, "two"));
	g_assert (!gee_map_has_key (self->test_map, "three"));
	g_assert (gee_map_get_size (self->test_map) == 0);
	g_assert (gee_map_get_is_empty (self->test_map));
	gee_map_set (self->test_map, "one", "value_of_one");
	g_assert (gee_map_has_key (self->test_map, "one"));
	g_assert (gee_map_has (self->test_map, "one", "value_of_one"));
	g_assert (!gee_map_has (self->test_map, "one", "another_value_for_one"));
	g_assert (_vala_strcmp0 (_tmp0_ = (char*) gee_map_get (self->test_map, "one"), "value_of_one") == 0);
	_g_free0 (_tmp0_);
	g_assert (!gee_map_has_key (self->test_map, "two"));
	g_assert ((_tmp1_ = (char*) gee_map_get (self->test_map, "two")) == NULL);
	_g_free0 (_tmp1_);
	g_assert (!gee_map_has_key (self->test_map, "three"));
	g_assert ((_tmp2_ = (char*) gee_map_get (self->test_map, "three")) == NULL);
	_g_free0 (_tmp2_);
	g_assert (gee_map_get_size (self->test_map) == 1);
	g_assert (!gee_map_get_is_empty (self->test_map));
	g_assert (gee_map_unset (self->test_map, "one", NULL));
	g_assert (!gee_map_has_key (self->test_map, "one"));
	g_assert (!gee_map_has (self->test_map, "one", "value_of_one"));
	g_assert (!gee_map_has (self->test_map, "one", "another_value_for_one"));
	g_assert ((_tmp3_ = (char*) gee_map_get (self->test_map, "one")) == NULL);
	_g_free0 (_tmp3_);
	g_assert (!gee_map_has_key (self->test_map, "two"));
	g_assert ((_tmp4_ = (char*) gee_map_get (self->test_map, "two")) == NULL);
	_g_free0 (_tmp4_);
	g_assert (!gee_map_has_key (self->test_map, "three"));
	g_assert ((_tmp5_ = (char*) gee_map_get (self->test_map, "three")) == NULL);
	_g_free0 (_tmp5_);
	g_assert (gee_map_get_size (self->test_map) == 0);
	g_assert (gee_map_get_is_empty (self->test_map));
	gee_map_set (self->test_map, "one", "value_of_one");
	g_assert (gee_map_has_key (self->test_map, "one"));
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_map_get (self->test_map, "one"), "value_of_one") == 0);
	_g_free0 (_tmp6_);
	g_assert (!gee_map_has_key (self->test_map, "two"));
	g_assert ((_tmp7_ = (char*) gee_map_get (self->test_map, "two")) == NULL);
	_g_free0 (_tmp7_);
	g_assert (!gee_map_has_key (self->test_map, "three"));
	g_assert ((_tmp8_ = (char*) gee_map_get (self->test_map, "three")) == NULL);
	_g_free0 (_tmp8_);
	g_assert (gee_map_get_size (self->test_map) == 1);
	g_assert (!gee_map_get_is_empty (self->test_map));
	gee_map_set (self->test_map, "two", "value_of_two");
	g_assert (gee_map_has_key (self->test_map, "one"));
	g_assert (_vala_strcmp0 (_tmp9_ = (char*) gee_map_get (self->test_map, "one"), "value_of_one") == 0);
	_g_free0 (_tmp9_);
	g_assert (gee_map_has_key (self->test_map, "two"));
	g_assert (_vala_strcmp0 (_tmp10_ = (char*) gee_map_get (self->test_map, "two"), "value_of_two") == 0);
	_g_free0 (_tmp10_);
	g_assert (!gee_map_has_key (self->test_map, "three"));
	g_assert ((_tmp11_ = (char*) gee_map_get (self->test_map, "three")) == NULL);
	_g_free0 (_tmp11_);
	g_assert (gee_map_get_size (self->test_map) == 2);
	g_assert (!gee_map_get_is_empty (self->test_map));
	gee_map_set (self->test_map, "three", "value_of_three");
	g_assert (gee_map_has_key (self->test_map, "one"));
	g_assert (_vala_strcmp0 (_tmp12_ = (char*) gee_map_get (self->test_map, "one"), "value_of_one") == 0);
	_g_free0 (_tmp12_);
	g_assert (gee_map_has_key (self->test_map, "two"));
	g_assert (_vala_strcmp0 (_tmp13_ = (char*) gee_map_get (self->test_map, "two"), "value_of_two") == 0);
	_g_free0 (_tmp13_);
	g_assert (gee_map_has_key (self->test_map, "three"));
	g_assert (_vala_strcmp0 (_tmp14_ = (char*) gee_map_get (self->test_map, "three"), "value_of_three") == 0);
	_g_free0 (_tmp14_);
	g_assert (gee_map_get_size (self->test_map) == 3);
	g_assert (!gee_map_get_is_empty (self->test_map));
	gee_map_set (self->test_map, "two", "value_of_two_new");
	g_assert (gee_map_has_key (self->test_map, "one"));
	g_assert (_vala_strcmp0 (_tmp15_ = (char*) gee_map_get (self->test_map, "one"), "value_of_one") == 0);
	_g_free0 (_tmp15_);
	g_assert (gee_map_has_key (self->test_map, "two"));
	g_assert (_vala_strcmp0 (_tmp16_ = (char*) gee_map_get (self->test_map, "two"), "value_of_two_new") == 0);
	_g_free0 (_tmp16_);
	g_assert (gee_map_has_key (self->test_map, "three"));
	g_assert (_vala_strcmp0 (_tmp17_ = (char*) gee_map_get (self->test_map, "three"), "value_of_three") == 0);
	_g_free0 (_tmp17_);
	g_assert (gee_map_get_size (self->test_map) == 3);
	g_assert (!gee_map_get_is_empty (self->test_map));
	g_assert ((_tmp19_ = gee_map_unset (self->test_map, "two", &_tmp18_), value = (_tmp20_ = (char*) _tmp18_, _g_free0 (value), _tmp20_), _tmp19_));
	g_assert (_vala_strcmp0 (value, "value_of_two_new") == 0);
	g_assert (gee_map_has_key (self->test_map, "one"));
	g_assert (_vala_strcmp0 (_tmp21_ = (char*) gee_map_get (self->test_map, "one"), "value_of_one") == 0);
	_g_free0 (_tmp21_);
	g_assert (!gee_map_has_key (self->test_map, "two"));
	g_assert ((_tmp22_ = (char*) gee_map_get (self->test_map, "two")) == NULL);
	_g_free0 (_tmp22_);
	g_assert (gee_map_has_key (self->test_map, "three"));
	g_assert (_vala_strcmp0 (_tmp23_ = (char*) gee_map_get (self->test_map, "three"), "value_of_three") == 0);
	_g_free0 (_tmp23_);
	g_assert (gee_map_get_size (self->test_map) == 2);
	g_assert (!gee_map_get_is_empty (self->test_map));
	g_assert (!(_tmp25_ = gee_map_unset (self->test_map, "two", &_tmp24_), value = (_tmp26_ = (char*) _tmp24_, _g_free0 (value), _tmp26_), _tmp25_));
	g_assert (value == NULL);
	g_assert (gee_map_has_key (self->test_map, "one"));
	g_assert (!gee_map_has_key (self->test_map, "two"));
	g_assert (gee_map_has_key (self->test_map, "three"));
	g_assert (gee_map_get_size (self->test_map) == 2);
	g_assert (!gee_map_get_is_empty (self->test_map));
	gee_map_clear (self->test_map);
	g_assert (!gee_map_has_key (self->test_map, "one"));
	g_assert ((_tmp27_ = (char*) gee_map_get (self->test_map, "one")) == NULL);
	_g_free0 (_tmp27_);
	g_assert (!gee_map_has_key (self->test_map, "two"));
	g_assert ((_tmp28_ = (char*) gee_map_get (self->test_map, "two")) == NULL);
	_g_free0 (_tmp28_);
	g_assert (!gee_map_has_key (self->test_map, "three"));
	g_assert ((_tmp29_ = (char*) gee_map_get (self->test_map, "three")) == NULL);
	_g_free0 (_tmp29_);
	g_assert (gee_map_get_size (self->test_map) == 0);
	g_assert (gee_map_get_is_empty (self->test_map));
	_g_free0 (value);
}


void map_tests_test_keys (MapTests* self) {
	GeeSet* keys;
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	g_return_if_fail (self != NULL);
	keys = gee_map_get_keys (self->test_map);
	g_assert (gee_collection_get_size ((GeeCollection*) keys) == 0);
	gee_map_set (self->test_map, "one", "value_of_one");
	g_assert (gee_collection_get_size ((GeeCollection*) keys) == 1);
	g_assert (gee_collection_contains ((GeeCollection*) keys, "one"));
	keys = (_tmp0_ = gee_map_get_keys (self->test_map), _g_object_unref0 (keys), _tmp0_);
	g_assert (gee_collection_get_size ((GeeCollection*) keys) == 1);
	g_assert (gee_collection_contains ((GeeCollection*) keys, "one"));
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		g_assert (!gee_collection_add ((GeeCollection*) keys, "three"));
		_g_object_unref0 (keys);
		return;
	}
	g_test_trap_assert_failed ();
	g_test_trap_assert_stderr ("*code should not be reached*");
	gee_map_set (self->test_map, "two", "value_of_two");
	g_assert (gee_collection_get_size ((GeeCollection*) keys) == 2);
	g_assert (gee_collection_contains ((GeeCollection*) keys, "one"));
	g_assert (gee_collection_contains ((GeeCollection*) keys, "two"));
	keys = (_tmp1_ = gee_map_get_keys (self->test_map), _g_object_unref0 (keys), _tmp1_);
	g_assert (gee_collection_get_size ((GeeCollection*) keys) == 2);
	g_assert (gee_collection_contains ((GeeCollection*) keys, "one"));
	g_assert (gee_collection_contains ((GeeCollection*) keys, "two"));
	gee_map_clear (self->test_map);
	g_assert (gee_collection_get_size ((GeeCollection*) keys) == 0);
	keys = (_tmp2_ = gee_map_get_keys (self->test_map), _g_object_unref0 (keys), _tmp2_);
	g_assert (gee_collection_get_size ((GeeCollection*) keys) == 0);
	_g_object_unref0 (keys);
}


void map_tests_test_values (MapTests* self) {
	GeeCollection* values;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	g_return_if_fail (self != NULL);
	values = gee_map_get_values (self->test_map);
	g_assert (gee_collection_get_size (values) == 0);
	gee_map_set (self->test_map, "one", "value_of_one");
	g_assert (gee_collection_get_size (values) == 1);
	g_assert (gee_collection_contains (values, "value_of_one"));
	values = (_tmp0_ = gee_map_get_values (self->test_map), _g_object_unref0 (values), _tmp0_);
	g_assert (gee_collection_get_size (values) == 1);
	g_assert (gee_collection_contains (values, "value_of_one"));
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		g_assert (!gee_collection_add (values, "two"));
		_g_object_unref0 (values);
		return;
	}
	g_test_trap_assert_failed ();
	g_test_trap_assert_stderr ("*code should not be reached*");
	gee_map_set (self->test_map, "two", "value_of_two");
	g_assert (gee_collection_get_size (values) == 2);
	g_assert (gee_collection_contains (values, "value_of_one"));
	g_assert (gee_collection_contains (values, "value_of_two"));
	values = (_tmp1_ = gee_map_get_values (self->test_map), _g_object_unref0 (values), _tmp1_);
	g_assert (gee_collection_get_size (values) == 2);
	g_assert (gee_collection_contains (values, "value_of_one"));
	g_assert (gee_collection_contains (values, "value_of_two"));
	gee_map_clear (self->test_map);
	g_assert (gee_collection_get_size (values) == 0);
	values = (_tmp2_ = gee_map_get_values (self->test_map), _g_object_unref0 (values), _tmp2_);
	g_assert (gee_collection_get_size (values) == 0);
	_g_object_unref0 (values);
}


void map_tests_test_entries (MapTests* self) {
	GeeSet* entries;
	MapTestsTestEntry* _tmp0_;
	GeeSet* _tmp1_;
	MapTestsTestEntry* _tmp2_;
	MapTestsTestEntry* _tmp4_;
	MapTestsTestEntry* _tmp5_;
	GeeSet* _tmp6_;
	MapTestsTestEntry* _tmp7_;
	MapTestsTestEntry* _tmp8_;
	GeeSet* _tmp9_;
	g_return_if_fail (self != NULL);
	entries = gee_map_get_entries (self->test_map);
	g_assert (gee_collection_get_size ((GeeCollection*) entries) == 0);
	gee_map_set (self->test_map, "one", "value_of_one");
	g_assert (gee_collection_get_size ((GeeCollection*) entries) == 1);
	g_assert (gee_collection_contains ((GeeCollection*) entries, (GeeMapEntry*) (_tmp0_ = map_tests_test_entry_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, "one", "value_of_one"))));
	_g_object_unref0 (_tmp0_);
	entries = (_tmp1_ = gee_map_get_entries (self->test_map), _g_object_unref0 (entries), _tmp1_);
	g_assert (gee_collection_get_size ((GeeCollection*) entries) == 1);
	g_assert (gee_collection_contains ((GeeCollection*) entries, (GeeMapEntry*) (_tmp2_ = map_tests_test_entry_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, "one", "value_of_one"))));
	_g_object_unref0 (_tmp2_);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		MapTestsTestEntry* _tmp3_;
		g_assert (!gee_collection_add ((GeeCollection*) entries, (GeeMapEntry*) (_tmp3_ = map_tests_test_entry_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, "two", "value_of_two"))));
		_g_object_unref0 (_tmp3_);
		_g_object_unref0 (entries);
		return;
	}
	g_test_trap_assert_failed ();
	g_test_trap_assert_stderr ("*code should not be reached*");
	gee_map_set (self->test_map, "two", "value_of_two");
	g_assert (gee_collection_get_size ((GeeCollection*) entries) == 2);
	g_assert (gee_collection_contains ((GeeCollection*) entries, (GeeMapEntry*) (_tmp4_ = map_tests_test_entry_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, "one", "value_of_one"))));
	_g_object_unref0 (_tmp4_);
	g_assert (gee_collection_contains ((GeeCollection*) entries, (GeeMapEntry*) (_tmp5_ = map_tests_test_entry_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, "two", "value_of_two"))));
	_g_object_unref0 (_tmp5_);
	entries = (_tmp6_ = gee_map_get_entries (self->test_map), _g_object_unref0 (entries), _tmp6_);
	g_assert (gee_collection_get_size ((GeeCollection*) entries) == 2);
	g_assert (gee_collection_contains ((GeeCollection*) entries, (GeeMapEntry*) (_tmp7_ = map_tests_test_entry_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, "one", "value_of_one"))));
	_g_object_unref0 (_tmp7_);
	g_assert (gee_collection_contains ((GeeCollection*) entries, (GeeMapEntry*) (_tmp8_ = map_tests_test_entry_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, "two", "value_of_two"))));
	_g_object_unref0 (_tmp8_);
	gee_map_clear (self->test_map);
	g_assert (gee_collection_get_size ((GeeCollection*) entries) == 0);
	entries = (_tmp9_ = gee_map_get_entries (self->test_map), _g_object_unref0 (entries), _tmp9_);
	g_assert (gee_collection_get_size ((GeeCollection*) entries) == 0);
	_g_object_unref0 (entries);
}


void map_tests_test_set_all (MapTests* self) {
	GeeHashMap* another_map;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	g_return_if_fail (self != NULL);
	another_map = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_str_equal);
	gee_map_set (self->test_map, "one", "value_of_one");
	gee_map_set (self->test_map, "two", "value_of_two");
	gee_map_set (self->test_map, "three", "value_of_three");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "four", "value_of_four");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "five", "value_of_five");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "six", "value_of_six");
	gee_map_set_all (self->test_map, (GeeMap*) another_map);
	g_assert (gee_map_get_size (self->test_map) == 6);
	g_assert (gee_map_has_key (self->test_map, "one"));
	g_assert (gee_map_has_key (self->test_map, "two"));
	g_assert (gee_map_has_key (self->test_map, "three"));
	g_assert (gee_map_has_key (self->test_map, "four"));
	g_assert (gee_map_has_key (self->test_map, "five"));
	g_assert (gee_map_has_key (self->test_map, "six"));
	g_assert (_vala_strcmp0 (_tmp0_ = (char*) gee_map_get (self->test_map, "one"), "value_of_one") == 0);
	_g_free0 (_tmp0_);
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_map_get (self->test_map, "two"), "value_of_two") == 0);
	_g_free0 (_tmp1_);
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_map_get (self->test_map, "three"), "value_of_three") == 0);
	_g_free0 (_tmp2_);
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_map_get (self->test_map, "four"), "value_of_four") == 0);
	_g_free0 (_tmp3_);
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_map_get (self->test_map, "five"), "value_of_five") == 0);
	_g_free0 (_tmp4_);
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_map_get (self->test_map, "six"), "value_of_six") == 0);
	_g_free0 (_tmp5_);
	_g_object_unref0 (another_map);
}


void map_tests_test_unset_all (MapTests* self) {
	GeeHashMap* another_map;
	g_return_if_fail (self != NULL);
	another_map = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_str_equal);
	g_assert (gee_map_get_is_empty (self->test_map));
	g_assert (gee_abstract_map_get_is_empty ((GeeAbstractMap*) another_map));
	g_assert (!gee_map_unset_all (self->test_map, (GeeMap*) another_map));
	g_assert (gee_map_get_is_empty (self->test_map));
	g_assert (gee_abstract_map_get_is_empty ((GeeAbstractMap*) another_map));
	gee_map_clear (self->test_map);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "one", "value_of_one");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "value_of_two");
	g_assert (gee_map_get_is_empty (self->test_map));
	g_assert (gee_map_get_size ((GeeMap*) another_map) == 2);
	g_assert (!gee_map_unset_all (self->test_map, (GeeMap*) another_map));
	g_assert (gee_map_get_is_empty (self->test_map));
	g_assert (gee_map_get_size ((GeeMap*) another_map) == 2);
	gee_map_clear (self->test_map);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	gee_map_set (self->test_map, "one", "value_of_one");
	gee_map_set (self->test_map, "two", "value_of_two");
	g_assert (gee_map_get_size (self->test_map) == 2);
	g_assert (gee_abstract_map_get_is_empty ((GeeAbstractMap*) another_map));
	g_assert (!gee_map_unset_all (self->test_map, (GeeMap*) another_map));
	g_assert (gee_map_get_size (self->test_map) == 2);
	g_assert (gee_abstract_map_get_is_empty ((GeeAbstractMap*) another_map));
	gee_map_clear (self->test_map);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	gee_map_set (self->test_map, "one", "value_of_one");
	gee_map_set (self->test_map, "two", "value_of_two");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "one", "value_of_one");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "value_of_two");
	g_assert (gee_map_get_size (self->test_map) == 2);
	g_assert (gee_map_get_size ((GeeMap*) another_map) == 2);
	g_assert (gee_map_unset_all (self->test_map, (GeeMap*) another_map));
	g_assert (gee_map_get_is_empty (self->test_map));
	g_assert (gee_map_get_size ((GeeMap*) another_map) == 2);
	gee_map_clear (self->test_map);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	gee_map_set (self->test_map, "one", "value_of_one");
	gee_map_set (self->test_map, "two", "value_of_two");
	gee_map_set (self->test_map, "three", "value_of_three");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "value_of_two");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "three", "value_of_three");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "four", "value_of_four");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "five", "value_of_five");
	g_assert (gee_map_get_size (self->test_map) == 3);
	g_assert (gee_map_get_size ((GeeMap*) another_map) == 4);
	g_assert (gee_map_unset_all (self->test_map, (GeeMap*) another_map));
	g_assert (gee_map_get_size (self->test_map) == 1);
	g_assert (gee_map_get_size ((GeeMap*) another_map) == 4);
	g_assert (gee_map_has_key (self->test_map, "one"));
	_g_object_unref0 (another_map);
}


void map_tests_test_has_all (MapTests* self) {
	GeeHashMap* another_map;
	g_return_if_fail (self != NULL);
	another_map = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_str_equal);
	g_assert (gee_map_has_all (self->test_map, (GeeMap*) another_map));
	gee_map_set (self->test_map, "one", "value_of_one");
	g_assert (gee_map_has_all (self->test_map, (GeeMap*) another_map));
	gee_map_clear (self->test_map);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "one", "value_of_one");
	g_assert (!gee_map_has_all (self->test_map, (GeeMap*) another_map));
	gee_map_clear (self->test_map);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	gee_map_set (self->test_map, "one", "value_of_one");
	gee_map_set (self->test_map, "two", "value_of_two");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "one", "value_of_one");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "value_of_two");
	g_assert (gee_map_has_all (self->test_map, (GeeMap*) another_map));
	gee_map_clear (self->test_map);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	gee_map_set (self->test_map, "one", "value_of_one");
	gee_map_set (self->test_map, "two", "value_of_two");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "one", "another_value_of_one");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "another_value_of_two");
	g_assert (!gee_map_has_all (self->test_map, (GeeMap*) another_map));
	gee_map_clear (self->test_map);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	gee_map_set (self->test_map, "one", "value_of_one");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "value_of_two");
	g_assert (!gee_map_has_all (self->test_map, (GeeMap*) another_map));
	gee_map_clear (self->test_map);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	gee_map_set (self->test_map, "one", "value_of_one");
	gee_map_set (self->test_map, "two", "value_of_two");
	gee_map_set (self->test_map, "three", "value_of_three");
	gee_map_set (self->test_map, "four", "value_of_four");
	gee_map_set (self->test_map, "five", "value_of_five");
	gee_map_set (self->test_map, "six", "value_of_six");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "value_of_two");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "three", "value_of_three");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "four", "value_of_four");
	g_assert (gee_map_has_all (self->test_map, (GeeMap*) another_map));
	gee_map_clear (self->test_map);
	gee_abstract_map_clear ((GeeAbstractMap*) another_map);
	gee_map_set (self->test_map, "one", "value_of_one");
	gee_map_set (self->test_map, "two", "value_of_two");
	gee_map_set (self->test_map, "three", "value_of_three");
	gee_map_set (self->test_map, "four", "value_of_four");
	gee_map_set (self->test_map, "five", "value_of_five");
	gee_map_set (self->test_map, "six", "value_of_six");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "two", "value_of_two");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "three", "value_of_three");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "four", "value_of_four");
	gee_abstract_map_set ((GeeAbstractMap*) another_map, "height", "value_of_height");
	g_assert (!gee_map_has_all (self->test_map, (GeeMap*) another_map));
	_g_object_unref0 (another_map);
}


void map_tests_test_gobject_properties (MapTests* self) {
	GValue value = {0};
	GValue _tmp1_;
	GValue _tmp0_ = {0};
	GValue _tmp3_;
	GValue _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	g_assert (self->test_map != NULL);
	value = (_tmp1_ = (g_value_init (&_tmp0_, G_TYPE_BOOLEAN), _tmp0_), G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp1_);
	g_object_get_property ((GObject*) self->test_map, "is-empty", &value);
	g_assert (g_value_get_boolean (&value) == gee_map_get_is_empty (self->test_map));
	g_value_unset (&value);
	value = (_tmp3_ = (g_value_init (&_tmp2_, G_TYPE_INT), _tmp2_), G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp3_);
	g_object_get_property ((GObject*) self->test_map, "size", &value);
	g_assert (g_value_get_int (&value) == gee_map_get_size (self->test_map));
	g_value_unset (&value);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
}


MapTestsTestEntry* map_tests_test_entry_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, gconstpointer key, gconstpointer value) {
	MapTestsTestEntry * self;
	gpointer _tmp1_;
	gconstpointer _tmp0_;
	self = (MapTestsTestEntry*) gee_map_entry_construct (object_type, k_type, (GBoxedCopyFunc) k_dup_func, k_destroy_func, v_type, (GBoxedCopyFunc) v_dup_func, v_destroy_func);
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	self->priv->_key = (_tmp1_ = (_tmp0_ = key, ((_tmp0_ == NULL) || (k_dup_func == NULL)) ? ((gpointer) _tmp0_) : k_dup_func ((gpointer) _tmp0_)), _k_destroy_func0 (self->priv->_key), _tmp1_);
	gee_map_entry_set_value ((GeeMapEntry*) self, value);
	return self;
}


MapTestsTestEntry* map_tests_test_entry_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, gconstpointer key, gconstpointer value) {
	return map_tests_test_entry_construct (MAP_TESTS_TYPE_TEST_ENTRY, k_type, k_dup_func, k_destroy_func, v_type, v_dup_func, v_destroy_func, key, value);
}


static gconstpointer map_tests_test_entry_real_get_key (GeeMapEntry* base) {
	gconstpointer result;
	MapTestsTestEntry* self;
	self = (MapTestsTestEntry*) base;
	result = self->priv->_key;
	return result;
}


static gconstpointer map_tests_test_entry_real_get_value (GeeMapEntry* base) {
	gconstpointer result;
	MapTestsTestEntry* self;
	self = (MapTestsTestEntry*) base;
	result = self->priv->_value;
	return result;
}


static void map_tests_test_entry_real_set_value (GeeMapEntry* base, gconstpointer value) {
	MapTestsTestEntry* self;
	gpointer _tmp1_;
	gconstpointer _tmp0_;
	self = (MapTestsTestEntry*) base;
	self->priv->_value = (_tmp1_ = (_tmp0_ = value, ((_tmp0_ == NULL) || (self->priv->v_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->v_dup_func ((gpointer) _tmp0_)), ((self->priv->_value == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : (self->priv->_value = (self->priv->v_destroy_func (self->priv->_value), NULL)), _tmp1_);
	g_object_notify ((GObject *) self, "value");
}


static void map_tests_test_entry_class_init (MapTestsTestEntryClass * klass) {
	map_tests_test_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MapTestsTestEntryPrivate));
	GEE_MAP_ENTRY_CLASS (klass)->get_key = map_tests_test_entry_real_get_key;
	GEE_MAP_ENTRY_CLASS (klass)->get_value = map_tests_test_entry_real_get_value;
	GEE_MAP_ENTRY_CLASS (klass)->set_value = map_tests_test_entry_real_set_value;
	G_OBJECT_CLASS (klass)->get_property = map_tests_test_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = map_tests_test_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = map_tests_test_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_K_TYPE, g_param_spec_gtype ("k-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_K_DUP_FUNC, g_param_spec_pointer ("k-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_K_DESTROY_FUNC, g_param_spec_pointer ("k-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_V_TYPE, g_param_spec_gtype ("v-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_V_DUP_FUNC, g_param_spec_pointer ("v-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_V_DESTROY_FUNC, g_param_spec_pointer ("v-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_override_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_KEY, "key");
	g_object_class_override_property (G_OBJECT_CLASS (klass), MAP_TESTS_TEST_ENTRY_VALUE, "value");
}


static void map_tests_test_entry_instance_init (MapTestsTestEntry * self) {
	self->priv = MAP_TESTS_TEST_ENTRY_GET_PRIVATE (self);
}


static void map_tests_test_entry_finalize (GObject* obj) {
	MapTestsTestEntry * self;
	self = MAP_TESTS_TEST_ENTRY (obj);
	((self->priv->_key == NULL) || (self->priv->k_destroy_func == NULL)) ? NULL : (self->priv->_key = (self->priv->k_destroy_func (self->priv->_key), NULL));
	((self->priv->_value == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : (self->priv->_value = (self->priv->v_destroy_func (self->priv->_value), NULL));
	G_OBJECT_CLASS (map_tests_test_entry_parent_class)->finalize (obj);
}


GType map_tests_test_entry_get_type (void) {
	static GType map_tests_test_entry_type_id = 0;
	if (map_tests_test_entry_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (MapTestsTestEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) map_tests_test_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MapTestsTestEntry), 0, (GInstanceInitFunc) map_tests_test_entry_instance_init, NULL };
		map_tests_test_entry_type_id = g_type_register_static (GEE_MAP_TYPE_ENTRY, "MapTestsTestEntry", &g_define_type_info, 0);
	}
	return map_tests_test_entry_type_id;
}


static void map_tests_test_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MapTestsTestEntry * self;
	self = MAP_TESTS_TEST_ENTRY (object);
	switch (property_id) {
		case MAP_TESTS_TEST_ENTRY_KEY:
		g_value_set_pointer (value, gee_map_entry_get_key ((GeeMapEntry*) self));
		break;
		case MAP_TESTS_TEST_ENTRY_VALUE:
		g_value_set_pointer (value, gee_map_entry_get_value ((GeeMapEntry*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void map_tests_test_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MapTestsTestEntry * self;
	self = MAP_TESTS_TEST_ENTRY (object);
	switch (property_id) {
		case MAP_TESTS_TEST_ENTRY_VALUE:
		gee_map_entry_set_value ((GeeMapEntry*) self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case MAP_TESTS_TEST_ENTRY_K_TYPE:
		self->priv->k_type = g_value_get_gtype (value);
		break;
		case MAP_TESTS_TEST_ENTRY_K_DUP_FUNC:
		self->priv->k_dup_func = g_value_get_pointer (value);
		break;
		case MAP_TESTS_TEST_ENTRY_K_DESTROY_FUNC:
		self->priv->k_destroy_func = g_value_get_pointer (value);
		break;
		case MAP_TESTS_TEST_ENTRY_V_TYPE:
		self->priv->v_type = g_value_get_gtype (value);
		break;
		case MAP_TESTS_TEST_ENTRY_V_DUP_FUNC:
		self->priv->v_dup_func = g_value_get_pointer (value);
		break;
		case MAP_TESTS_TEST_ENTRY_V_DESTROY_FUNC:
		self->priv->v_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void map_tests_class_init (MapTestsClass * klass) {
	map_tests_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = map_tests_finalize;
}


static void map_tests_instance_init (MapTests * self) {
}


static void map_tests_finalize (GObject* obj) {
	MapTests * self;
	self = MAP_TESTS (obj);
	_g_object_unref0 (self->test_map);
	G_OBJECT_CLASS (map_tests_parent_class)->finalize (obj);
}


GType map_tests_get_type (void) {
	static GType map_tests_type_id = 0;
	if (map_tests_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (MapTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) map_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MapTests), 0, (GInstanceInitFunc) map_tests_instance_init, NULL };
		map_tests_type_id = g_type_register_static (GEE_TYPE_TEST_CASE, "MapTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return map_tests_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




