/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.processors;

import io.swagger.models.Operation;
import io.swagger.models.RefResponse;
import io.swagger.models.Response;
import io.swagger.models.Responses;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import io.swagger.parser.ResolverCache;
import io.swagger.parser.processors.ParameterProcessor;
import io.swagger.parser.processors.ResponseProcessor;
import java.util.List;

public class OperationProcessor {
    private final ParameterProcessor parameterProcessor;
    private final ResponseProcessor responseProcessor;
    private final ResolverCache cache;

    public OperationProcessor(ResolverCache cache, Swagger swagger) {
        this.cache = cache;
        this.parameterProcessor = new ParameterProcessor(cache, swagger);
        this.responseProcessor = new ResponseProcessor(cache, swagger);
    }

    public void processOperation(Operation operation) {
        List<Parameter> processedOperationParameters = this.parameterProcessor.processParameters(operation.getParameters());
        operation.setParameters(processedOperationParameters);
        Responses responses = operation.getResponsesObject();
        if (responses != null) {
            for (String responseCode : responses.keySet()) {
                Response response = (Response)responses.get(responseCode);
                if (response == null) continue;
                if (response instanceof RefResponse) {
                    RefResponse refResponse = (RefResponse)response;
                    this.responseProcessor.processResponse(response);
                    Response resolvedResponse = this.cache.loadRef(refResponse.get$ref(), refResponse.getRefFormat(), Response.class);
                    if (resolvedResponse != null) {
                        response = resolvedResponse;
                        responses.put(responseCode, resolvedResponse);
                    }
                }
                this.responseProcessor.processResponse(response);
            }
        }
    }
}

