from collections import OrderedDict

from faker.typing import OrderedDictType

from .. import Provider as ColorProvider

localized = True


class Provider(ColorProvider):
    """
    Color provider for ``de`` locale. Source: https://www.sttmedia.com/colornames
    """

    all_colors: OrderedDictType[str, str] = OrderedDict(
        (
            ("Eisfarben", "#F0F8FF"),
            ("Antikweiß", "#FAEBD7"),
            ("Wasser", "#00FFFF"),
            ("Aquamarinblau", "#7FFFD4"),
            ("Azur", "#F0FFFF"),
            ("Beige", "#F5F5DC"),
            ("Biskuit", "#FFE4C4"),
            ("Schwarz", "#000000"),
            ("Mandelweiß", "#FFEBCD"),
            ("Blau", "#0000FF"),
            ("Blauviolett", "#8A2BE2"),
            ("Braun", "#A52A2A"),
            ("Gelbbraun", "#DEB887"),
            ("Kadettenblau", "#5F9EA0"),
            ("Hellgrün", "#7FFF00"),
            ("Schokolade", "#D2691E"),
            ("Koralle", "#FF7F50"),
            ("Kornblumenblau", "#6495ED"),
            ("Mais", "#FFF8DC"),
            ("Karminrot", "#DC143C"),
            ("Cyan", "#00FFFF"),
            ("Dunkelblau", "#00008B"),
            ("Dunkelcyan", "#008B8B"),
            ("Dunkle Goldrutenfarbe", "#B8860B"),
            ("Dunkelgrau", "#A9A9A9"),
            ("Dunkelgrün", "#006400"),
            ("Dunkelkhaki", "#BDB76B"),
            ("Dunkelmagenta", "#8B008B"),
            ("Dunkles Olivgrün", "#556B2F"),
            ("Dunkles Orange", "#FF8C00"),
            ("Dunkle Orchidee", "#9932CC"),
            ("Dunkelrot", "#8B0000"),
            ("Dunkle Lachsfarbe", "#E9967A"),
            ("Dunkles Seegrün", "#8FBC8F"),
            ("Dunkles Schieferblau", "#483D8B"),
            ("Dunkles Schiefergrau", "#2F4F4F"),
            ("Dunkeltürkis", "#00CED1"),
            ("Dunkelviolett", "#9400D3"),
            ("Tiefrosa", "#FF1493"),
            ("Tiefes Himmelblau", "#00BFFF"),
            ("Trübes Grau", "#696969"),
            ("Persenningblau", "#1E90FF"),
            ("Backstein", "#B22222"),
            ("Blütenweiß", "#FFFAF0"),
            ("Waldgrün", "#228B22"),
            ("Fuchsia", "#FF00FF"),
            ("Gainsboro", "#DCDCDC"),
            ("Geisterweiß", "#F8F8FF"),
            ("Gold", "#FFD700"),
            ("Goldrute", "#DAA520"),
            ("Grau", "#808080"),
            ("Grün", "#008000"),
            ("Grüngelb", "#ADFF2F"),
            ("Honigmelone", "#F0FFF0"),
            ("Leuchtendes Rosa", "#FF69B4"),
            ("Indischrot", "#CD5C5C"),
            ("Indigo", "#4B0082"),
            ("Elfenbein", "#FFFFF0"),
            ("Khaki", "#F0E68C"),
            ("Lavendel", "#E6E6FA"),
            ("Lavendelrosa", "#FFF0F5"),
            ("Rasengrün", "#7CFC00"),
            ("Chiffongelb", "#FFFACD"),
            ("Hellblau", "#ADD8E6"),
            ("Helles Korallenrot", "#F08080"),
            ("Helles Cyan", "#E0FFFF"),
            ("Helles Goldrutengelb", "#FAFAD2"),
            ("Hellgrau", "#D3D3D3"),
            ("Hellgrün", "#90EE90"),
            ("Hellrosa", "#FFB6C1"),
            ("Helle Lachsfarbe", "#FFA07A"),
            ("Helles Seegrün", "#20B2AA"),
            ("Helles Himmelblau", "#87CEFA"),
            ("Helles Schiefergrau", "#778899"),
            ("Helles Stahlblau", "#B0C4DE"),
            ("Hellgelb", "#FFFFE0"),
            ("Limone", "#00FF00"),
            ("Limonengrün", "#32CD32"),
            ("Leinen", "#FAF0E6"),
            ("Magenta", "#FF00FF"),
            ("Kastanie", "#800000"),
            ("Mittleres Aquamarin", "#66CDAA"),
            ("Mittleres Blau", "#0000CD"),
            ("Mittlere Orchidee", "#BA55D3"),
            ("Mittleres Violett", "#9370DB"),
            ("Mittleres Seegrün", "#3CB371"),
            ("Mittleres Schieferblau", "#7B68EE"),
            ("Mittleres Frühlingsgrün", "#00FA9A"),
            ("Mittleres Türkis", "#48D1CC"),
            ("Mittleres Violettrot", "#C71585"),
            ("Mitternachtsblau", "#191970"),
            ("Minzcreme", "#F5FFFA"),
            ("Altrosa", "#FFE4E1"),
            ("Mokassin", "#FFE4B5"),
            ("Navajoweiß", "#FFDEAD"),
            ("Marineblau", "#000080"),
            ("Alte Spitze", "#FDF5E6"),
            ("Olivgrün", "#808000"),
            ("Olivgraubraun", "#6B8E23"),
            ("Orange", "#FFA500"),
            ("Orangerot", "#FF4500"),
            ("Orchidee", "#DA70D6"),
            ("Blasse Goldrutenfarbe", "#EEE8AA"),
            ("Blassgrün", "#98FB98"),
            ("Blasstürkis", "#AFEEEE"),
            ("Blasses Violetrot", "#DB7093"),
            ("Papayacreme", "#FFEFD5"),
            ("Pfirsich", "#FFDAB9"),
            ("Peru", "#CD853F"),
            ("Rosa", "#FFC0CB"),
            ("Pflaume", "#DDA0DD"),
            ("Taubenblau", "#B0E0E6"),
            ("Lila", "#800080"),
            ("Rot", "#FF0000"),
            ("Rosiges Braun", "#BC8F8F"),
            ("Königsblau", "#4169E1"),
            ("Sattelbraun", "#8B4513"),
            ("Lachsfarben", "#FA8072"),
            ("Sandbraun", "#F4A460"),
            ("Seegrün", "#2E8B57"),
            ("Muschelfarben", "#FFF5EE"),
            ("Siennaerde", "#A0522D"),
            ("Silber", "#C0C0C0"),
            ("Himmelblau", "#87CEEB"),
            ("Schieferblau", "#6A5ACD"),
            ("Schiefergrau", "#708090"),
            ("Schneeweiß", "#FFFAFA"),
            ("Frühlingsgrün", "#00FF7F"),
            ("Stahlblau", "#4682B4"),
            ("Hautfarben", "#D2B48C"),
            ("Petrol", "#008080"),
            ("Distel", "#D8BFD8"),
            ("Tomatenrot", "#FF6347"),
            ("Türkis", "#40E0D0"),
            ("Violett", "#EE82EE"),
            ("Weizen", "#F5DEB3"),
            ("Weiß", "#FFFFFF"),
            ("Rauchfarben", "#F5F5F5"),
            ("Gelb", "#FFFF00"),
            ("Gelbgrün", "#9ACD32"),
        )
    )
