/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.dotnet.wix;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.ant.dotnet.DotNetExecTask;
import org.apache.ant.dotnet.build.AbstractBuildTask;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;

public class WixTask
extends Task {
    private String vm;
    private ArrayList sources = new ArrayList();
    private ArrayList moreSources = new ArrayList();
    private File source;
    private File target;
    private Mode mode;
    private File wixHome = null;
    private File wixobjDestDir = null;
    private Commandline candleCmdl = new Commandline();
    private ArrayList candleParameters = new ArrayList();
    private Commandline lightCmdl = new Commandline();
    private ArrayList lightParameters = new ArrayList();
    private boolean useLit = false;

    public void setVm(String value) {
        this.vm = value;
    }

    public void setSource(File f) {
        this.source = f;
    }

    public void setTarget(File f) {
        this.target = f;
    }

    public void addSources(FileSet fs) {
        this.sources.add(fs);
    }

    public void addMoreSources(FileSet fs) {
        this.moreSources.add(fs);
    }

    public void setWixHome(File f) {
        this.wixHome = f;
    }

    public void setMode(Mode m) {
        this.mode = m;
    }

    public void setWixobjDestDir(File f) {
        this.wixobjDestDir = f;
    }

    public final void addCandleParameter(AbstractBuildTask.Property t) {
        this.candleParameters.add(t);
    }

    public final void addLightParameter(AbstractBuildTask.Property t) {
        this.lightParameters.add(t);
    }

    public Commandline.Argument createLightArg() {
        return this.lightCmdl.createArgument();
    }

    public Commandline.Argument createCandleArg() {
        return this.candleCmdl.createArgument();
    }

    public void setUseLit(boolean b) {
        this.useLit = b;
    }

    public void execute() {
        if (this.source == null && this.sources.size() == 0) {
            throw new BuildException("You must specify at least one source file.");
        }
        if (this.source != null && !this.source.exists()) {
            throw new BuildException("Source file " + this.source + " doesn't exist.");
        }
        String m = "both";
        if (this.mode != null) {
            m = this.mode.getValue();
        }
        if (this.target == null && !m.equals("candle")) {
            throw new BuildException("You must specify the target if you want to run light.");
        }
        HashSet<File> lightSources = null;
        if (!m.equals("light")) {
            lightSources = this.doCandle();
        } else {
            lightSources = new HashSet<File>();
            if (this.source != null) {
                lightSources.add(this.source);
            }
            if (this.sources.size() > 0) {
                lightSources.addAll(this.grabFiles(this.sources));
            }
        }
        if (!m.equals("candle")) {
            Collection moreLightSources = Collections.EMPTY_SET;
            if (this.moreSources.size() > 0) {
                moreLightSources = this.grabFiles(this.moreSources);
            }
            this.doLight(lightSources, moreLightSources);
        }
    }

    private Collection doCandle() {
        HashSet<File> s = new HashSet<File>();
        if (this.source != null) {
            s.add(this.source);
        }
        if (this.sources != null) {
            s.addAll(this.grabFiles(this.sources));
        }
        HashSet ms = new HashSet();
        if (this.moreSources != null) {
            ms.addAll(this.grabFiles(this.moreSources));
        }
        HashSet<File> toProcess = new HashSet<File>();
        HashSet<File> generatedTargets = new HashSet<File>();
        Iterator iter = s.iterator();
        while (iter.hasNext()) {
            File thisSource = (File)iter.next();
            File t = this.getTarget(thisSource);
            generatedTargets.add(t);
            if (!this.isOutOfDate(t, thisSource, ms)) continue;
            toProcess.add(thisSource);
        }
        if (toProcess.size() != 0) {
            this.runCandle(toProcess);
            return generatedTargets;
        }
        return Collections.EMPTY_SET;
    }

    private void doLight(Collection lightSources, Collection moreLightSources) {
        HashSet tmp = new HashSet(lightSources);
        tmp.addAll(moreLightSources);
        if (this.isOutOfDate(this.target, tmp)) {
            this.runLight(lightSources);
        }
    }

    private void runCandle(Collection s) {
        this.run(this.wixExecutable("candle.exe"), s, null, this.wixobjDestDir, this.candleParameters, this.candleCmdl);
    }

    private void runLight(Collection s) {
        this.run(this.wixExecutable(this.useLit ? "lit.exe" : "light.exe"), s, this.target, null, this.lightParameters, this.lightCmdl);
    }

    private String wixExecutable(String name) {
        return this.wixHome == null ? name : new File(this.wixHome, name).getAbsolutePath();
    }

    private void run(String executable, Collection s, File target, File runInDir, Collection params, Commandline cmdl) {
        DotNetExecTask exec = DotNetExecTask.getTask(this, this.vm, executable, null);
        if (runInDir != null) {
            exec.setDir(runInDir);
        }
        exec.setFailonerror(true);
        exec.setTaskType("wix");
        exec.createArg().setValue("/nologo");
        Iterator iter = s.iterator();
        while (iter.hasNext()) {
            File f = (File)iter.next();
            exec.createArg().setValue(f.getAbsolutePath());
        }
        if (target != null) {
            exec.createArg().setValue("/out");
            exec.createArg().setValue(target.getAbsolutePath());
        }
        iter = params.iterator();
        while (iter.hasNext()) {
            AbstractBuildTask.Property p = (AbstractBuildTask.Property)iter.next();
            exec.createArg().setValue("-d" + p.getName() + "=" + p.getValue());
        }
        String[] extraArgs = cmdl.getArguments();
        for (int i = 0; i < extraArgs.length; ++i) {
            exec.createArg().setValue(extraArgs[i]);
        }
        exec.execute();
    }

    private boolean isOutOfDate(File t, File s, Collection l) {
        return t.lastModified() < s.lastModified() || this.isOutOfDate(t, l);
    }

    private boolean isOutOfDate(File t, Collection l) {
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            File f = (File)iter.next();
            if (t.lastModified() >= f.lastModified()) continue;
            return true;
        }
        return false;
    }

    private Collection grabFiles(Collection s) {
        HashSet<File> r = new HashSet<File>();
        Iterator iter = s.iterator();
        while (iter.hasNext()) {
            FileSet fs = (FileSet)iter.next();
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] f = ds.getIncludedFiles();
            File base = fs.getDir(this.getProject());
            for (int i = 0; i < f.length; ++i) {
                r.add(new File(base, f[i]));
            }
        }
        return r;
    }

    private File getTarget(File s) {
        String name = s.getName();
        int dot = name.lastIndexOf(".");
        name = dot > -1 ? name.substring(0, dot) + ".wixobj" : name + ".wixobj";
        return this.wixobjDestDir == null ? new File(name) : new File(this.wixobjDestDir, name);
    }

    public static class Mode
    extends EnumeratedAttribute {
        private static final String CANDLE = "candle";
        private static final String LIGHT = "light";
        private static final String BOTH = "both";

        public String[] getValues() {
            return new String[]{CANDLE, LIGHT, BOTH};
        }
    }
}

