/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.cm.ansible;

import java.util.Map;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.entity.cm.ansible.AnsibleConfig;
import org.apache.brooklyn.entity.cm.ansible.AnsibleEntityDriver;
import org.apache.brooklyn.entity.cm.ansible.AnsibleEntityImpl;
import org.apache.brooklyn.entity.cm.ansible.AnsiblePlaybookTasks;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessSshDriver;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.text.Strings;

public class AnsibleEntitySshDriver
extends AbstractSoftwareProcessSshDriver
implements AnsibleEntityDriver {
    public AnsibleEntitySshDriver(AnsibleEntityImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"check-running").body.append((CharSequence)this.getStatusCmd()).execute() == 0;
    }

    public void stop() {
        String serviceName = (String)this.getEntity().config().get(AnsibleConfig.SERVICE_NAME);
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"stopping").updateTaskAndFailOnNonZeroResultCode().body.append((CharSequence)BashCommands.sudo((String)String.format((String)this.getEntity().config().get(AnsibleConfig.ANSIBLE_SERVICE_STOP), serviceName))).execute();
    }

    public void install() {
        Object extraVars = this.getEntity().config().get(AnsibleConfig.ANSIBLE_VARS);
        String playbookName = (String)this.getEntity().config().get(AnsibleConfig.ANSIBLE_PLAYBOOK);
        String playbookUrl = (String)this.getEntity().config().get(AnsibleConfig.ANSIBLE_PLAYBOOK_URL);
        String playbookYaml = (String)this.getEntity().config().get(AnsibleConfig.ANSIBLE_PLAYBOOK_YAML);
        if (playbookUrl != null && playbookYaml != null) {
            throw new IllegalArgumentException("You can not specify both " + AnsibleConfig.ANSIBLE_PLAYBOOK_URL.getName() + " and " + AnsibleConfig.ANSIBLE_PLAYBOOK_YAML.getName() + " as arguments.");
        }
        if (playbookUrl == null && playbookYaml == null) {
            throw new IllegalArgumentException("You have to specify either " + AnsibleConfig.ANSIBLE_PLAYBOOK_URL.getName() + " or " + AnsibleConfig.ANSIBLE_PLAYBOOK_YAML.getName() + " as arguments.");
        }
        DynamicTasks.queue(AnsiblePlaybookTasks.installAnsible(this.getInstallDir(), false));
        DynamicTasks.queue(AnsiblePlaybookTasks.setUpHostsFile(false));
        if (extraVars != null) {
            DynamicTasks.queue(AnsiblePlaybookTasks.configureExtraVars(this.getRunDir(), extraVars, false));
        }
        if (Strings.isNonBlank((CharSequence)playbookUrl)) {
            DynamicTasks.queue(AnsiblePlaybookTasks.installPlaybook(this.getRunDir(), playbookName, playbookUrl));
        }
        if (Strings.isNonBlank((CharSequence)playbookYaml)) {
            DynamicTasks.queue(AnsiblePlaybookTasks.buildPlaybookFile(this.getRunDir(), playbookName));
        }
        DynamicTasks.queue(AnsiblePlaybookTasks.runAnsible(this.getRunDir(), extraVars, playbookName));
    }

    public void customize() {
        this.newScript("customizing").execute();
    }

    public void launch() {
        String serviceName = (String)this.getEntity().config().get(AnsibleConfig.SERVICE_NAME);
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").updateTaskAndFailOnNonZeroResultCode().body.append((CharSequence)BashCommands.sudo((String)String.format((String)this.getEntity().config().get(AnsibleConfig.ANSIBLE_SERVICE_START), serviceName))).execute();
    }

    @Override
    public String getStatusCmd() {
        String serviceNameCheck = ((String)this.getEntity().config().get(AnsibleConfig.SERVICE_NAME)).replaceFirst("^(.)(.*)", "[$1]$2");
        String statusCmd = String.format("ps -ef | grep %s", serviceNameCheck);
        Integer serviceCheckPort = (Integer)this.getEntity().config().get(AnsibleConfig.ANSIBLE_SERVICE_CHECK_PORT);
        if (serviceCheckPort != null) {
            statusCmd = BashCommands.sudo((String)String.format("ansible localhost -c local -m wait_for -a \"host=" + (String)this.getEntity().config().get(AnsibleConfig.ANSIBLE_SERVICE_CHECK_HOST) + "\" port=%d\"", serviceCheckPort));
        }
        return statusCmd;
    }

    @Override
    public ProcessTaskWrapper<Integer> ansibleCommand(String module, String args) {
        return (ProcessTaskWrapper)DynamicTasks.queue(AnsiblePlaybookTasks.moduleCommand(module, this.getEntity().config().get(AnsibleConfig.ANSIBLE_VARS), this.getRunDir(), args));
    }
}

