/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.suppliers;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.AvailabilityZoneInfo;
import org.jclouds.ec2.features.AvailabilityZoneAndRegionApi;
import org.jclouds.ec2.options.DescribeAvailabilityZonesOptions;
import org.jclouds.location.Region;
import org.jclouds.location.suppliers.RegionIdToZoneIdsSupplier;

public final class DescribeAvailabilityZonesInRegion
implements RegionIdToZoneIdsSupplier {
    private final EC2Api api;
    private final Supplier<Set<String>> regions;

    @Inject
    DescribeAvailabilityZonesInRegion(EC2Api api, @Region Supplier<Set<String>> regions) {
        this.api = api;
        this.regions = regions;
    }

    public Map<String, Supplier<Set<String>>> get() {
        AvailabilityZoneAndRegionApi zoneApi = (AvailabilityZoneAndRegionApi)this.api.getAvailabilityZoneAndRegionApi().get();
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (String region : (Set)this.regions.get()) {
            ImmutableSet.Builder zoneBuilder = ImmutableSet.builder();
            for (AvailabilityZoneInfo zone : zoneApi.describeAvailabilityZonesInRegion(region, new DescribeAvailabilityZonesOptions[0])) {
                zoneBuilder.add((Object)zone.getZone());
            }
            map.put((Object)region, (Object)Suppliers.ofInstance((Object)zoneBuilder.build()));
        }
        return map.build();
    }
}

