/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.dns.geoscaling;

import com.google.common.base.Predicates;
import java.net.URI;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.dns.AbstractGeoDnsService;
import org.apache.brooklyn.entity.dns.geoscaling.GeoscalingDnsServiceImpl;
import org.apache.brooklyn.entity.webapp.WebAppServiceConstants;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@ImplementedBy(value=GeoscalingDnsServiceImpl.class)
public interface GeoscalingDnsService
extends AbstractGeoDnsService {
    @SetFromFlag(value="sslTrustAll")
    public static final ConfigKey<Boolean> SSL_TRUST_ALL = ConfigKeys.newBooleanConfigKey((String)"ssl.trustAll", (String)"Whether to trust all certificates, or to fail with 'peer not authenticated' if untrusted (default false)", (Boolean)false);
    @SetFromFlag(value="randomizeSubdomainName")
    public static final ConfigKey<Boolean> RANDOMIZE_SUBDOMAIN_NAME = ConfigKeys.newBooleanConfigKey((String)"randomize.subdomain.name");
    @SetFromFlag(value="username")
    public static final ConfigKey<String> GEOSCALING_USERNAME = ConfigKeys.builder(String.class).name("geoscaling.username").constraint(Predicates.notNull()).build();
    @SetFromFlag(value="password")
    public static final ConfigKey<String> GEOSCALING_PASSWORD = ConfigKeys.builder(String.class).name("geoscaling.password").constraint(Predicates.notNull()).build();
    @SetFromFlag(value="primaryDomainName")
    public static final ConfigKey<String> GEOSCALING_PRIMARY_DOMAIN_NAME = ConfigKeys.builder(String.class).name("geoscaling.primary.domain.name").constraint(Predicates.notNull()).build();
    @SetFromFlag(value="smartSubdomainName")
    public static final ConfigKey<String> GEOSCALING_SMART_SUBDOMAIN_NAME = ConfigKeys.newStringConfigKey((String)"geoscaling.smart.subdomain.name");
    public static final AttributeSensor<String> GEOSCALING_ACCOUNT = Sensors.newStringSensor((String)"geoscaling.account", (String)"Active user account for the GeoScaling.com service");
    public static final AttributeSensor<URI> MAIN_URI = Attributes.MAIN_URI;
    public static final AttributeSensor<String> ROOT_URL = WebAppServiceConstants.ROOT_URL;
    public static final AttributeSensor<String> MANAGED_DOMAIN = Sensors.newStringSensor((String)"geoscaling.managed.domain", (String)("Fully qualified domain name that will be geo-redirected; this will be the same as " + ROOT_URL.getName() + " but the latter will only be set when the domain has active targets"));

    public void applyConfig();

    public long getTimeToLiveSeconds();
}

