/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationplatformspec;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1.integrationplatformspec.Build;
import org.apache.camel.v1.integrationplatformspec.build.BuildConfiguration;
import org.apache.camel.v1.integrationplatformspec.build.BuildConfigurationBuilder;
import org.apache.camel.v1.integrationplatformspec.build.BuildConfigurationFluent;
import org.apache.camel.v1.integrationplatformspec.build.Maven;
import org.apache.camel.v1.integrationplatformspec.build.MavenBuilder;
import org.apache.camel.v1.integrationplatformspec.build.MavenFluent;
import org.apache.camel.v1.integrationplatformspec.build.Registry;
import org.apache.camel.v1.integrationplatformspec.build.RegistryBuilder;
import org.apache.camel.v1.integrationplatformspec.build.RegistryFluent;

public class BuildFluent<A extends BuildFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> PublishStrategyOptions;
    private String baseImage;
    private String buildCatalogToolTimeout;
    private BuildConfigurationBuilder buildConfiguration;
    private MavenBuilder maven;
    private Integer maxRunningBuilds;
    private String publishStrategy;
    private RegistryBuilder registry;
    private String runtimeProvider;
    private String runtimeVersion;
    private String timeout;

    public BuildFluent() {
    }

    public BuildFluent(Build instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Build instance) {
        Build build = instance = instance != null ? instance : new Build();
        if (instance != null) {
            this.withPublishStrategyOptions(instance.getPublishStrategyOptions());
            this.withBaseImage(instance.getBaseImage());
            this.withBuildCatalogToolTimeout(instance.getBuildCatalogToolTimeout());
            this.withBuildConfiguration(instance.getBuildConfiguration());
            this.withMaven(instance.getMaven());
            this.withMaxRunningBuilds(instance.getMaxRunningBuilds());
            this.withPublishStrategy(instance.getPublishStrategy());
            this.withRegistry(instance.getRegistry());
            this.withRuntimeProvider(instance.getRuntimeProvider());
            this.withRuntimeVersion(instance.getRuntimeVersion());
            this.withTimeout(instance.getTimeout());
        }
    }

    public A addToPublishStrategyOptions(String key, String value) {
        if (this.PublishStrategyOptions == null && key != null && value != null) {
            this.PublishStrategyOptions = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.PublishStrategyOptions.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToPublishStrategyOptions(Map<String, String> map) {
        if (this.PublishStrategyOptions == null && map != null) {
            this.PublishStrategyOptions = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.PublishStrategyOptions.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromPublishStrategyOptions(String key) {
        if (this.PublishStrategyOptions == null) {
            return (A)((Object)this);
        }
        if (key != null && this.PublishStrategyOptions != null) {
            this.PublishStrategyOptions.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromPublishStrategyOptions(Map<String, String> map) {
        if (this.PublishStrategyOptions == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.PublishStrategyOptions == null) continue;
                this.PublishStrategyOptions.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getPublishStrategyOptions() {
        return this.PublishStrategyOptions;
    }

    public <K, V> A withPublishStrategyOptions(Map<String, String> PublishStrategyOptions) {
        this.PublishStrategyOptions = PublishStrategyOptions == null ? null : new LinkedHashMap<String, String>(PublishStrategyOptions);
        return (A)((Object)this);
    }

    public boolean hasPublishStrategyOptions() {
        return this.PublishStrategyOptions != null;
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public A withBaseImage(String baseImage) {
        this.baseImage = baseImage;
        return (A)((Object)this);
    }

    public boolean hasBaseImage() {
        return this.baseImage != null;
    }

    public String getBuildCatalogToolTimeout() {
        return this.buildCatalogToolTimeout;
    }

    public A withBuildCatalogToolTimeout(String buildCatalogToolTimeout) {
        this.buildCatalogToolTimeout = buildCatalogToolTimeout;
        return (A)((Object)this);
    }

    public boolean hasBuildCatalogToolTimeout() {
        return this.buildCatalogToolTimeout != null;
    }

    public BuildConfiguration buildBuildConfiguration() {
        return this.buildConfiguration != null ? this.buildConfiguration.build() : null;
    }

    public A withBuildConfiguration(BuildConfiguration buildConfiguration) {
        this._visitables.remove((Object)"buildConfiguration");
        if (buildConfiguration != null) {
            this.buildConfiguration = new BuildConfigurationBuilder(buildConfiguration);
            this._visitables.get((Object)"buildConfiguration").add(this.buildConfiguration);
        } else {
            this.buildConfiguration = null;
            this._visitables.get((Object)"buildConfiguration").remove((Object)this.buildConfiguration);
        }
        return (A)((Object)this);
    }

    public boolean hasBuildConfiguration() {
        return this.buildConfiguration != null;
    }

    public BuildConfigurationNested<A> withNewBuildConfiguration() {
        return new BuildConfigurationNested(null);
    }

    public BuildConfigurationNested<A> withNewBuildConfigurationLike(BuildConfiguration item) {
        return new BuildConfigurationNested(item);
    }

    public BuildConfigurationNested<A> editBuildConfiguration() {
        return this.withNewBuildConfigurationLike(Optional.ofNullable(this.buildBuildConfiguration()).orElse(null));
    }

    public BuildConfigurationNested<A> editOrNewBuildConfiguration() {
        return this.withNewBuildConfigurationLike(Optional.ofNullable(this.buildBuildConfiguration()).orElse(new BuildConfigurationBuilder().build()));
    }

    public BuildConfigurationNested<A> editOrNewBuildConfigurationLike(BuildConfiguration item) {
        return this.withNewBuildConfigurationLike(Optional.ofNullable(this.buildBuildConfiguration()).orElse(item));
    }

    public Maven buildMaven() {
        return this.maven != null ? this.maven.build() : null;
    }

    public A withMaven(Maven maven) {
        this._visitables.remove((Object)"maven");
        if (maven != null) {
            this.maven = new MavenBuilder(maven);
            this._visitables.get((Object)"maven").add(this.maven);
        } else {
            this.maven = null;
            this._visitables.get((Object)"maven").remove((Object)this.maven);
        }
        return (A)((Object)this);
    }

    public boolean hasMaven() {
        return this.maven != null;
    }

    public MavenNested<A> withNewMaven() {
        return new MavenNested(null);
    }

    public MavenNested<A> withNewMavenLike(Maven item) {
        return new MavenNested(item);
    }

    public MavenNested<A> editBuildMaven() {
        return this.withNewMavenLike(Optional.ofNullable(this.buildMaven()).orElse(null));
    }

    public MavenNested<A> editOrNewMaven() {
        return this.withNewMavenLike(Optional.ofNullable(this.buildMaven()).orElse(new MavenBuilder().build()));
    }

    public MavenNested<A> editOrNewMavenLike(Maven item) {
        return this.withNewMavenLike(Optional.ofNullable(this.buildMaven()).orElse(item));
    }

    public Integer getMaxRunningBuilds() {
        return this.maxRunningBuilds;
    }

    public A withMaxRunningBuilds(Integer maxRunningBuilds) {
        this.maxRunningBuilds = maxRunningBuilds;
        return (A)((Object)this);
    }

    public boolean hasMaxRunningBuilds() {
        return this.maxRunningBuilds != null;
    }

    public String getPublishStrategy() {
        return this.publishStrategy;
    }

    public A withPublishStrategy(String publishStrategy) {
        this.publishStrategy = publishStrategy;
        return (A)((Object)this);
    }

    public boolean hasPublishStrategy() {
        return this.publishStrategy != null;
    }

    public Registry buildRegistry() {
        return this.registry != null ? this.registry.build() : null;
    }

    public A withRegistry(Registry registry) {
        this._visitables.remove((Object)"registry");
        if (registry != null) {
            this.registry = new RegistryBuilder(registry);
            this._visitables.get((Object)"registry").add(this.registry);
        } else {
            this.registry = null;
            this._visitables.get((Object)"registry").remove((Object)this.registry);
        }
        return (A)((Object)this);
    }

    public boolean hasRegistry() {
        return this.registry != null;
    }

    public RegistryNested<A> withNewRegistry() {
        return new RegistryNested(null);
    }

    public RegistryNested<A> withNewRegistryLike(Registry item) {
        return new RegistryNested(item);
    }

    public RegistryNested<A> editBuildRegistry() {
        return this.withNewRegistryLike(Optional.ofNullable(this.buildRegistry()).orElse(null));
    }

    public RegistryNested<A> editOrNewRegistry() {
        return this.withNewRegistryLike(Optional.ofNullable(this.buildRegistry()).orElse(new RegistryBuilder().build()));
    }

    public RegistryNested<A> editOrNewRegistryLike(Registry item) {
        return this.withNewRegistryLike(Optional.ofNullable(this.buildRegistry()).orElse(item));
    }

    public String getRuntimeProvider() {
        return this.runtimeProvider;
    }

    public A withRuntimeProvider(String runtimeProvider) {
        this.runtimeProvider = runtimeProvider;
        return (A)((Object)this);
    }

    public boolean hasRuntimeProvider() {
        return this.runtimeProvider != null;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public A withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return (A)((Object)this);
    }

    public boolean hasRuntimeVersion() {
        return this.runtimeVersion != null;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public A withTimeout(String timeout) {
        this.timeout = timeout;
        return (A)((Object)this);
    }

    public boolean hasTimeout() {
        return this.timeout != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildFluent that = (BuildFluent)((Object)o);
        if (!Objects.equals(this.PublishStrategyOptions, that.PublishStrategyOptions)) {
            return false;
        }
        if (!Objects.equals(this.baseImage, that.baseImage)) {
            return false;
        }
        if (!Objects.equals(this.buildCatalogToolTimeout, that.buildCatalogToolTimeout)) {
            return false;
        }
        if (!Objects.equals((Object)this.buildConfiguration, (Object)that.buildConfiguration)) {
            return false;
        }
        if (!Objects.equals((Object)this.maven, (Object)that.maven)) {
            return false;
        }
        if (!Objects.equals(this.maxRunningBuilds, that.maxRunningBuilds)) {
            return false;
        }
        if (!Objects.equals(this.publishStrategy, that.publishStrategy)) {
            return false;
        }
        if (!Objects.equals((Object)this.registry, (Object)that.registry)) {
            return false;
        }
        if (!Objects.equals(this.runtimeProvider, that.runtimeProvider)) {
            return false;
        }
        if (!Objects.equals(this.runtimeVersion, that.runtimeVersion)) {
            return false;
        }
        return Objects.equals(this.timeout, that.timeout);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.PublishStrategyOptions, this.baseImage, this.buildCatalogToolTimeout, this.buildConfiguration, this.maven, this.maxRunningBuilds, this.publishStrategy, this.registry, this.runtimeProvider, this.runtimeVersion, this.timeout, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.PublishStrategyOptions != null && !this.PublishStrategyOptions.isEmpty()) {
            sb.append("PublishStrategyOptions:");
            sb.append(this.PublishStrategyOptions + ",");
        }
        if (this.baseImage != null) {
            sb.append("baseImage:");
            sb.append(this.baseImage + ",");
        }
        if (this.buildCatalogToolTimeout != null) {
            sb.append("buildCatalogToolTimeout:");
            sb.append(this.buildCatalogToolTimeout + ",");
        }
        if (this.buildConfiguration != null) {
            sb.append("buildConfiguration:");
            sb.append(this.buildConfiguration + ",");
        }
        if (this.maven != null) {
            sb.append("maven:");
            sb.append(this.maven + ",");
        }
        if (this.maxRunningBuilds != null) {
            sb.append("maxRunningBuilds:");
            sb.append(this.maxRunningBuilds + ",");
        }
        if (this.publishStrategy != null) {
            sb.append("publishStrategy:");
            sb.append(this.publishStrategy + ",");
        }
        if (this.registry != null) {
            sb.append("registry:");
            sb.append(this.registry + ",");
        }
        if (this.runtimeProvider != null) {
            sb.append("runtimeProvider:");
            sb.append(this.runtimeProvider + ",");
        }
        if (this.runtimeVersion != null) {
            sb.append("runtimeVersion:");
            sb.append(this.runtimeVersion + ",");
        }
        if (this.timeout != null) {
            sb.append("timeout:");
            sb.append(this.timeout);
        }
        sb.append("}");
        return sb.toString();
    }

    public class BuildConfigurationNested<N>
    extends BuildConfigurationFluent<BuildConfigurationNested<N>>
    implements Nested<N> {
        BuildConfigurationBuilder builder;

        BuildConfigurationNested(BuildConfiguration item) {
            this.builder = new BuildConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)BuildFluent.this.withBuildConfiguration(this.builder.build());
        }

        public N endBuildConfiguration() {
            return this.and();
        }
    }

    public class MavenNested<N>
    extends MavenFluent<MavenNested<N>>
    implements Nested<N> {
        MavenBuilder builder;

        MavenNested(Maven item) {
            this.builder = new MavenBuilder(this, item);
        }

        public N and() {
            return (N)BuildFluent.this.withMaven(this.builder.build());
        }

        public N endBuildMaven() {
            return this.and();
        }
    }

    public class RegistryNested<N>
    extends RegistryFluent<RegistryNested<N>>
    implements Nested<N> {
        RegistryBuilder builder;

        RegistryNested(Registry item) {
            this.builder = new RegistryBuilder(this, item);
        }

        public N and() {
            return (N)BuildFluent.this.withRegistry(this.builder.build());
        }

        public N endBuildRegistry() {
            return this.and();
        }
    }
}

