/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationplatformspec.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.integrationplatformspec.traits.Quarkus;
import org.apache.camel.v1.integrationplatformspec.traits.quarkus.Configuration;
import org.apache.camel.v1.integrationplatformspec.traits.quarkus.ConfigurationBuilder;
import org.apache.camel.v1.integrationplatformspec.traits.quarkus.ConfigurationFluent;

public class QuarkusFluent<A extends QuarkusFluent<A>>
extends BaseFluent<A> {
    private List<Quarkus.BuildMode> buildMode;
    private ConfigurationBuilder configuration;
    private Boolean enabled;
    private String nativeBaseImage;
    private String nativeBuilderImage;
    private List<Quarkus.PackageTypes> packageTypes;

    public QuarkusFluent() {
    }

    public QuarkusFluent(Quarkus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Quarkus instance) {
        Quarkus quarkus = instance = instance != null ? instance : new Quarkus();
        if (instance != null) {
            this.withBuildMode(instance.getBuildMode());
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
            this.withNativeBaseImage(instance.getNativeBaseImage());
            this.withNativeBuilderImage(instance.getNativeBuilderImage());
            this.withPackageTypes(instance.getPackageTypes());
        }
    }

    public A addToBuildMode(int index, Quarkus.BuildMode item) {
        if (this.buildMode == null) {
            this.buildMode = new ArrayList<Quarkus.BuildMode>();
        }
        this.buildMode.add(index, item);
        return (A)((Object)this);
    }

    public A setToBuildMode(int index, Quarkus.BuildMode item) {
        if (this.buildMode == null) {
            this.buildMode = new ArrayList<Quarkus.BuildMode>();
        }
        this.buildMode.set(index, item);
        return (A)((Object)this);
    }

    public A addToBuildMode(Quarkus.BuildMode ... items) {
        if (this.buildMode == null) {
            this.buildMode = new ArrayList<Quarkus.BuildMode>();
        }
        for (Quarkus.BuildMode item : items) {
            this.buildMode.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToBuildMode(Collection<Quarkus.BuildMode> items) {
        if (this.buildMode == null) {
            this.buildMode = new ArrayList<Quarkus.BuildMode>();
        }
        for (Quarkus.BuildMode item : items) {
            this.buildMode.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromBuildMode(Quarkus.BuildMode ... items) {
        if (this.buildMode == null) {
            return (A)((Object)this);
        }
        for (Quarkus.BuildMode item : items) {
            this.buildMode.remove((Object)item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBuildMode(Collection<Quarkus.BuildMode> items) {
        if (this.buildMode == null) {
            return (A)((Object)this);
        }
        for (Quarkus.BuildMode item : items) {
            this.buildMode.remove((Object)item);
        }
        return (A)((Object)this);
    }

    public List<Quarkus.BuildMode> getBuildMode() {
        return this.buildMode;
    }

    public Quarkus.BuildMode getBuildMode(int index) {
        return this.buildMode.get(index);
    }

    public Quarkus.BuildMode getFirstBuildMode() {
        return this.buildMode.get(0);
    }

    public Quarkus.BuildMode getLastBuildMode() {
        return this.buildMode.get(this.buildMode.size() - 1);
    }

    public Quarkus.BuildMode getMatchingBuildMode(Predicate<Quarkus.BuildMode> predicate) {
        for (Quarkus.BuildMode item : this.buildMode) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingBuildMode(Predicate<Quarkus.BuildMode> predicate) {
        for (Quarkus.BuildMode item : this.buildMode) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBuildMode(List<Quarkus.BuildMode> buildMode) {
        if (buildMode != null) {
            this.buildMode = new ArrayList<Quarkus.BuildMode>();
            for (Quarkus.BuildMode item : buildMode) {
                this.addToBuildMode(item);
            }
        } else {
            this.buildMode = null;
        }
        return (A)((Object)this);
    }

    public A withBuildMode(Quarkus.BuildMode ... buildMode) {
        if (this.buildMode != null) {
            this.buildMode.clear();
            this._visitables.remove((Object)"buildMode");
        }
        if (buildMode != null) {
            for (Quarkus.BuildMode item : buildMode) {
                this.addToBuildMode(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasBuildMode() {
        return this.buildMode != null && !this.buildMode.isEmpty();
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public String getNativeBaseImage() {
        return this.nativeBaseImage;
    }

    public A withNativeBaseImage(String nativeBaseImage) {
        this.nativeBaseImage = nativeBaseImage;
        return (A)((Object)this);
    }

    public boolean hasNativeBaseImage() {
        return this.nativeBaseImage != null;
    }

    public String getNativeBuilderImage() {
        return this.nativeBuilderImage;
    }

    public A withNativeBuilderImage(String nativeBuilderImage) {
        this.nativeBuilderImage = nativeBuilderImage;
        return (A)((Object)this);
    }

    public boolean hasNativeBuilderImage() {
        return this.nativeBuilderImage != null;
    }

    public A addToPackageTypes(int index, Quarkus.PackageTypes item) {
        if (this.packageTypes == null) {
            this.packageTypes = new ArrayList<Quarkus.PackageTypes>();
        }
        this.packageTypes.add(index, item);
        return (A)((Object)this);
    }

    public A setToPackageTypes(int index, Quarkus.PackageTypes item) {
        if (this.packageTypes == null) {
            this.packageTypes = new ArrayList<Quarkus.PackageTypes>();
        }
        this.packageTypes.set(index, item);
        return (A)((Object)this);
    }

    public A addToPackageTypes(Quarkus.PackageTypes ... items) {
        if (this.packageTypes == null) {
            this.packageTypes = new ArrayList<Quarkus.PackageTypes>();
        }
        for (Quarkus.PackageTypes item : items) {
            this.packageTypes.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToPackageTypes(Collection<Quarkus.PackageTypes> items) {
        if (this.packageTypes == null) {
            this.packageTypes = new ArrayList<Quarkus.PackageTypes>();
        }
        for (Quarkus.PackageTypes item : items) {
            this.packageTypes.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromPackageTypes(Quarkus.PackageTypes ... items) {
        if (this.packageTypes == null) {
            return (A)((Object)this);
        }
        for (Quarkus.PackageTypes item : items) {
            this.packageTypes.remove((Object)item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPackageTypes(Collection<Quarkus.PackageTypes> items) {
        if (this.packageTypes == null) {
            return (A)((Object)this);
        }
        for (Quarkus.PackageTypes item : items) {
            this.packageTypes.remove((Object)item);
        }
        return (A)((Object)this);
    }

    public List<Quarkus.PackageTypes> getPackageTypes() {
        return this.packageTypes;
    }

    public Quarkus.PackageTypes getPackageType(int index) {
        return this.packageTypes.get(index);
    }

    public Quarkus.PackageTypes getFirstPackageType() {
        return this.packageTypes.get(0);
    }

    public Quarkus.PackageTypes getLastPackageType() {
        return this.packageTypes.get(this.packageTypes.size() - 1);
    }

    public Quarkus.PackageTypes getMatchingPackageType(Predicate<Quarkus.PackageTypes> predicate) {
        for (Quarkus.PackageTypes item : this.packageTypes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPackageType(Predicate<Quarkus.PackageTypes> predicate) {
        for (Quarkus.PackageTypes item : this.packageTypes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPackageTypes(List<Quarkus.PackageTypes> packageTypes) {
        if (packageTypes != null) {
            this.packageTypes = new ArrayList<Quarkus.PackageTypes>();
            for (Quarkus.PackageTypes item : packageTypes) {
                this.addToPackageTypes(item);
            }
        } else {
            this.packageTypes = null;
        }
        return (A)((Object)this);
    }

    public A withPackageTypes(Quarkus.PackageTypes ... packageTypes) {
        if (this.packageTypes != null) {
            this.packageTypes.clear();
            this._visitables.remove((Object)"packageTypes");
        }
        if (packageTypes != null) {
            for (Quarkus.PackageTypes item : packageTypes) {
                this.addToPackageTypes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPackageTypes() {
        return this.packageTypes != null && !this.packageTypes.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QuarkusFluent that = (QuarkusFluent)((Object)o);
        if (!Objects.equals(this.buildMode, that.buildMode)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.nativeBaseImage, that.nativeBaseImage)) {
            return false;
        }
        if (!Objects.equals(this.nativeBuilderImage, that.nativeBuilderImage)) {
            return false;
        }
        return Objects.equals(this.packageTypes, that.packageTypes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.buildMode, this.configuration, this.enabled, this.nativeBaseImage, this.nativeBuilderImage, this.packageTypes, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.buildMode != null && !this.buildMode.isEmpty()) {
            sb.append("buildMode:");
            sb.append(this.buildMode + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.nativeBaseImage != null) {
            sb.append("nativeBaseImage:");
            sb.append(this.nativeBaseImage + ",");
        }
        if (this.nativeBuilderImage != null) {
            sb.append("nativeBuilderImage:");
            sb.append(this.nativeBuilderImage + ",");
        }
        if (this.packageTypes != null && !this.packageTypes.isEmpty()) {
            sb.append("packageTypes:");
            sb.append(this.packageTypes);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)QuarkusFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

