/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationspec.template.spec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1.integrationspec.template.spec.SecurityContextBuilder;
import org.apache.camel.v1.integrationspec.template.spec.securitycontext.SeLinuxOptions;
import org.apache.camel.v1.integrationspec.template.spec.securitycontext.SeccompProfile;
import org.apache.camel.v1.integrationspec.template.spec.securitycontext.Sysctls;
import org.apache.camel.v1.integrationspec.template.spec.securitycontext.WindowsOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"fsGroup", "fsGroupChangePolicy", "runAsGroup", "runAsNonRoot", "runAsUser", "seLinuxOptions", "seccompProfile", "supplementalGroups", "sysctls", "windowsOptions"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class SecurityContext
implements Editable<SecurityContextBuilder>,
KubernetesResource {
    @JsonProperty(value="fsGroup")
    @JsonPropertyDescription(value="A special supplemental group that applies to all containers in a pod.\nSome volume types allow the Kubelet to change the ownership of that volume\nto be owned by the pod:\n\n\n1. The owning GID will be the FSGroup\n2. The setgid bit is set (new files created in the volume will be owned by FSGroup)\n3. The permission bits are OR'd with rw-rw----\n\n\nIf unset, the Kubelet will not modify the ownership and permissions of any volume.\nNote that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long fsGroup;
    @JsonProperty(value="fsGroupChangePolicy")
    @JsonPropertyDescription(value="fsGroupChangePolicy defines behavior of changing ownership and permission of the volume\nbefore being exposed inside Pod. This field will only apply to\nvolume types which support fsGroup based ownership(and permissions).\nIt will have no effect on ephemeral volume types such as: secret, configmaps\nand emptydir.\nValid values are \"OnRootMismatch\" and \"Always\". If not specified, \"Always\" is used.\nNote that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String fsGroupChangePolicy;
    @JsonProperty(value="runAsGroup")
    @JsonPropertyDescription(value="The GID to run the entrypoint of the container process.\nUses runtime default if unset.\nMay also be set in SecurityContext.  If set in both SecurityContext and\nPodSecurityContext, the value specified in SecurityContext takes precedence\nfor that container.\nNote that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long runAsGroup;
    @JsonProperty(value="runAsNonRoot")
    @JsonPropertyDescription(value="Indicates that the container must run as a non-root user.\nIf true, the Kubelet will validate the image at runtime to ensure that it\ndoes not run as UID 0 (root) and fail to start the container if it does.\nIf unset or false, no such validation will be performed.\nMay also be set in SecurityContext.  If set in both SecurityContext and\nPodSecurityContext, the value specified in SecurityContext takes precedence.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean runAsNonRoot;
    @JsonProperty(value="runAsUser")
    @JsonPropertyDescription(value="The UID to run the entrypoint of the container process.\nDefaults to user specified in image metadata if unspecified.\nMay also be set in SecurityContext.  If set in both SecurityContext and\nPodSecurityContext, the value specified in SecurityContext takes precedence\nfor that container.\nNote that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long runAsUser;
    @JsonProperty(value="seLinuxOptions")
    @JsonPropertyDescription(value="The SELinux context to be applied to all containers.\nIf unspecified, the container runtime will allocate a random SELinux context for each\ncontainer.  May also be set in SecurityContext.  If set in\nboth SecurityContext and PodSecurityContext, the value specified in SecurityContext\ntakes precedence for that container.\nNote that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private SeLinuxOptions seLinuxOptions;
    @JsonProperty(value="seccompProfile")
    @JsonPropertyDescription(value="The seccomp options to use by the containers in this pod.\nNote that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private SeccompProfile seccompProfile;
    @JsonProperty(value="supplementalGroups")
    @JsonPropertyDescription(value="A list of groups applied to the first process run in each container, in addition\nto the container's primary GID, the fsGroup (if specified), and group memberships\ndefined in the container image for the uid of the container process. If unspecified,\nno additional groups are added to any container. Note that group memberships\ndefined in the container image for the uid of the container process are still effective,\neven if they are not included in this list.\nNote that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Long> supplementalGroups;
    @JsonProperty(value="sysctls")
    @JsonPropertyDescription(value="Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported\nsysctls (by the container runtime) might fail to launch.\nNote that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Sysctls> sysctls;
    @JsonProperty(value="windowsOptions")
    @JsonPropertyDescription(value="The Windows specific settings applied to all containers.\nIf unspecified, the options within a container's SecurityContext will be used.\nIf set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.\nNote that this field cannot be set when spec.os.name is linux.")
    @JsonSetter(nulls=Nulls.SKIP)
    private WindowsOptions windowsOptions;

    public SecurityContextBuilder edit() {
        return new SecurityContextBuilder(this);
    }

    public Long getFsGroup() {
        return this.fsGroup;
    }

    public void setFsGroup(Long fsGroup) {
        this.fsGroup = fsGroup;
    }

    public String getFsGroupChangePolicy() {
        return this.fsGroupChangePolicy;
    }

    public void setFsGroupChangePolicy(String fsGroupChangePolicy) {
        this.fsGroupChangePolicy = fsGroupChangePolicy;
    }

    public Long getRunAsGroup() {
        return this.runAsGroup;
    }

    public void setRunAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
    }

    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public void setRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
    }

    public Long getRunAsUser() {
        return this.runAsUser;
    }

    public void setRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
    }

    public SeLinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions;
    }

    public void setSeLinuxOptions(SeLinuxOptions seLinuxOptions) {
        this.seLinuxOptions = seLinuxOptions;
    }

    public SeccompProfile getSeccompProfile() {
        return this.seccompProfile;
    }

    public void setSeccompProfile(SeccompProfile seccompProfile) {
        this.seccompProfile = seccompProfile;
    }

    public List<Long> getSupplementalGroups() {
        return this.supplementalGroups;
    }

    public void setSupplementalGroups(List<Long> supplementalGroups) {
        this.supplementalGroups = supplementalGroups;
    }

    public List<Sysctls> getSysctls() {
        return this.sysctls;
    }

    public void setSysctls(List<Sysctls> sysctls) {
        this.sysctls = sysctls;
    }

    public WindowsOptions getWindowsOptions() {
        return this.windowsOptions;
    }

    public void setWindowsOptions(WindowsOptions windowsOptions) {
        this.windowsOptions = windowsOptions;
    }

    public String toString() {
        return "SecurityContext(fsGroup=" + this.getFsGroup() + ", fsGroupChangePolicy=" + this.getFsGroupChangePolicy() + ", runAsGroup=" + this.getRunAsGroup() + ", runAsNonRoot=" + this.getRunAsNonRoot() + ", runAsUser=" + this.getRunAsUser() + ", seLinuxOptions=" + this.getSeLinuxOptions() + ", seccompProfile=" + this.getSeccompProfile() + ", supplementalGroups=" + this.getSupplementalGroups() + ", sysctls=" + this.getSysctls() + ", windowsOptions=" + this.getWindowsOptions() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecurityContext)) {
            return false;
        }
        SecurityContext other = (SecurityContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$fsGroup = this.getFsGroup();
        Long other$fsGroup = other.getFsGroup();
        if (this$fsGroup == null ? other$fsGroup != null : !((Object)this$fsGroup).equals(other$fsGroup)) {
            return false;
        }
        Long this$runAsGroup = this.getRunAsGroup();
        Long other$runAsGroup = other.getRunAsGroup();
        if (this$runAsGroup == null ? other$runAsGroup != null : !((Object)this$runAsGroup).equals(other$runAsGroup)) {
            return false;
        }
        Boolean this$runAsNonRoot = this.getRunAsNonRoot();
        Boolean other$runAsNonRoot = other.getRunAsNonRoot();
        if (this$runAsNonRoot == null ? other$runAsNonRoot != null : !((Object)this$runAsNonRoot).equals(other$runAsNonRoot)) {
            return false;
        }
        Long this$runAsUser = this.getRunAsUser();
        Long other$runAsUser = other.getRunAsUser();
        if (this$runAsUser == null ? other$runAsUser != null : !((Object)this$runAsUser).equals(other$runAsUser)) {
            return false;
        }
        String this$fsGroupChangePolicy = this.getFsGroupChangePolicy();
        String other$fsGroupChangePolicy = other.getFsGroupChangePolicy();
        if (this$fsGroupChangePolicy == null ? other$fsGroupChangePolicy != null : !this$fsGroupChangePolicy.equals(other$fsGroupChangePolicy)) {
            return false;
        }
        SeLinuxOptions this$seLinuxOptions = this.getSeLinuxOptions();
        SeLinuxOptions other$seLinuxOptions = other.getSeLinuxOptions();
        if (this$seLinuxOptions == null ? other$seLinuxOptions != null : !((Object)this$seLinuxOptions).equals(other$seLinuxOptions)) {
            return false;
        }
        SeccompProfile this$seccompProfile = this.getSeccompProfile();
        SeccompProfile other$seccompProfile = other.getSeccompProfile();
        if (this$seccompProfile == null ? other$seccompProfile != null : !((Object)this$seccompProfile).equals(other$seccompProfile)) {
            return false;
        }
        List<Long> this$supplementalGroups = this.getSupplementalGroups();
        List<Long> other$supplementalGroups = other.getSupplementalGroups();
        if (this$supplementalGroups == null ? other$supplementalGroups != null : !((Object)this$supplementalGroups).equals(other$supplementalGroups)) {
            return false;
        }
        List<Sysctls> this$sysctls = this.getSysctls();
        List<Sysctls> other$sysctls = other.getSysctls();
        if (this$sysctls == null ? other$sysctls != null : !((Object)this$sysctls).equals(other$sysctls)) {
            return false;
        }
        WindowsOptions this$windowsOptions = this.getWindowsOptions();
        WindowsOptions other$windowsOptions = other.getWindowsOptions();
        return !(this$windowsOptions == null ? other$windowsOptions != null : !((Object)this$windowsOptions).equals(other$windowsOptions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecurityContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $fsGroup = this.getFsGroup();
        result = result * 59 + ($fsGroup == null ? 43 : ((Object)$fsGroup).hashCode());
        Long $runAsGroup = this.getRunAsGroup();
        result = result * 59 + ($runAsGroup == null ? 43 : ((Object)$runAsGroup).hashCode());
        Boolean $runAsNonRoot = this.getRunAsNonRoot();
        result = result * 59 + ($runAsNonRoot == null ? 43 : ((Object)$runAsNonRoot).hashCode());
        Long $runAsUser = this.getRunAsUser();
        result = result * 59 + ($runAsUser == null ? 43 : ((Object)$runAsUser).hashCode());
        String $fsGroupChangePolicy = this.getFsGroupChangePolicy();
        result = result * 59 + ($fsGroupChangePolicy == null ? 43 : $fsGroupChangePolicy.hashCode());
        SeLinuxOptions $seLinuxOptions = this.getSeLinuxOptions();
        result = result * 59 + ($seLinuxOptions == null ? 43 : ((Object)$seLinuxOptions).hashCode());
        SeccompProfile $seccompProfile = this.getSeccompProfile();
        result = result * 59 + ($seccompProfile == null ? 43 : ((Object)$seccompProfile).hashCode());
        List<Long> $supplementalGroups = this.getSupplementalGroups();
        result = result * 59 + ($supplementalGroups == null ? 43 : ((Object)$supplementalGroups).hashCode());
        List<Sysctls> $sysctls = this.getSysctls();
        result = result * 59 + ($sysctls == null ? 43 : ((Object)$sysctls).hashCode());
        WindowsOptions $windowsOptions = this.getWindowsOptions();
        result = result * 59 + ($windowsOptions == null ? 43 : ((Object)$windowsOptions).hashCode());
        return result;
    }
}

