/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.kameletspec.versions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1.kameletspec.versions.Types;
import org.apache.camel.v1.kameletspec.versions.types.Schema;
import org.apache.camel.v1.kameletspec.versions.types.SchemaBuilder;
import org.apache.camel.v1.kameletspec.versions.types.SchemaFluent;

public class TypesFluent<A extends TypesFluent<A>>
extends BaseFluent<A> {
    private String mediaType;
    private SchemaBuilder schema;

    public TypesFluent() {
    }

    public TypesFluent(Types instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Types instance) {
        Types types = instance = instance != null ? instance : new Types();
        if (instance != null) {
            this.withMediaType(instance.getMediaType());
            this.withSchema(instance.getSchema());
        }
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public A withMediaType(String mediaType) {
        this.mediaType = mediaType;
        return (A)((Object)this);
    }

    public boolean hasMediaType() {
        return this.mediaType != null;
    }

    public Schema buildSchema() {
        return this.schema != null ? this.schema.build() : null;
    }

    public A withSchema(Schema schema) {
        this._visitables.remove((Object)"schema");
        if (schema != null) {
            this.schema = new SchemaBuilder(schema);
            this._visitables.get((Object)"schema").add(this.schema);
        } else {
            this.schema = null;
            this._visitables.get((Object)"schema").remove((Object)this.schema);
        }
        return (A)((Object)this);
    }

    public boolean hasSchema() {
        return this.schema != null;
    }

    public SchemaNested<A> withNewSchema() {
        return new SchemaNested(null);
    }

    public SchemaNested<A> withNewSchemaLike(Schema item) {
        return new SchemaNested(item);
    }

    public SchemaNested<A> editVersionsSchema() {
        return this.withNewSchemaLike(Optional.ofNullable(this.buildSchema()).orElse(null));
    }

    public SchemaNested<A> editOrNewSchema() {
        return this.withNewSchemaLike(Optional.ofNullable(this.buildSchema()).orElse(new SchemaBuilder().build()));
    }

    public SchemaNested<A> editOrNewSchemaLike(Schema item) {
        return this.withNewSchemaLike(Optional.ofNullable(this.buildSchema()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypesFluent that = (TypesFluent)((Object)o);
        if (!Objects.equals(this.mediaType, that.mediaType)) {
            return false;
        }
        return Objects.equals((Object)this.schema, (Object)that.schema);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mediaType, this.schema, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mediaType != null) {
            sb.append("mediaType:");
            sb.append(this.mediaType + ",");
        }
        if (this.schema != null) {
            sb.append("schema:");
            sb.append((Object)this.schema);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SchemaNested<N>
    extends SchemaFluent<SchemaNested<N>>
    implements Nested<N> {
        SchemaBuilder builder;

        SchemaNested(Schema item) {
            this.builder = new SchemaBuilder(this, item);
        }

        public N and() {
            return (N)TypesFluent.this.withSchema(this.builder.build());
        }

        public N endVersionsSchema() {
            return this.and();
        }
    }
}

