/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.remote.ClientConnection;
import org.apache.cayenne.remote.ClientMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConnection
implements ClientConnection {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected long messageId;

    protected BaseConnection() {
    }

    @Override
    public Object sendMessage(ClientMessage message) throws CayenneRuntimeException {
        Object response;
        if (message == null) {
            throw new NullPointerException("Null message");
        }
        this.beforeSendMessage(message);
        long t0 = 0L;
        String messageLabel = "";
        long messageId = this.messageId++;
        if (this.logger.isInfoEnabled()) {
            t0 = System.currentTimeMillis();
            messageLabel = message.toString();
            this.logger.info("--- Message " + messageId + ": " + messageLabel);
        }
        try {
            response = this.doSendMessage(message);
        }
        catch (CayenneRuntimeException e) {
            if (this.logger.isInfoEnabled()) {
                long time = System.currentTimeMillis() - t0;
                this.logger.info("*** Message error for " + messageId + ": " + messageLabel + " - took " + time + " ms.");
            }
            throw e;
        }
        if (this.logger.isInfoEnabled()) {
            long time = System.currentTimeMillis() - t0;
            this.logger.info("=== Message " + messageId + ": " + messageLabel + " done - took " + time + " ms.");
        }
        return response;
    }

    public long getProcessedMessagesCount() {
        return this.messageId + 1L;
    }

    protected abstract void beforeSendMessage(ClientMessage var1) throws CayenneRuntimeException;

    protected abstract Object doSendMessage(ClientMessage var1) throws CayenneRuntimeException;
}

