/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.rop;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.remote.ClientMessage;
import org.apache.cayenne.remote.RemoteService;
import org.apache.cayenne.remote.RemoteSession;
import org.apache.cayenne.rop.ROPConnector;
import org.apache.cayenne.rop.ROPSerializationService;

public class ProxyRemoteService
implements RemoteService {
    protected ROPSerializationService serializationService;
    protected ROPConnector ropConnector;

    public ProxyRemoteService(@Inject ROPSerializationService serializationService, @Inject ROPConnector ropConnector) {
        this.serializationService = serializationService;
        this.ropConnector = ropConnector;
    }

    public RemoteSession establishSession() throws RemoteException {
        RemoteSession remoteSession;
        block8: {
            InputStream is = this.ropConnector.establishSession();
            try {
                remoteSession = (RemoteSession)this.serializationService.deserialize(is, RemoteSession.class);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RemoteException(e.getMessage(), e);
                }
            }
            is.close();
        }
        return remoteSession;
    }

    public RemoteSession establishSharedSession(String name) throws RemoteException {
        RemoteSession remoteSession;
        block8: {
            InputStream is = this.ropConnector.establishSharedSession(name);
            try {
                remoteSession = (RemoteSession)this.serializationService.deserialize(is, RemoteSession.class);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RemoteException(e.getMessage(), e);
                }
            }
            is.close();
        }
        return remoteSession;
    }

    public Object processMessage(ClientMessage message) throws RemoteException, Throwable {
        Object object;
        block8: {
            InputStream is = this.ropConnector.sendMessage(this.serializationService.serialize((Object)message));
            try {
                object = this.serializationService.deserialize(is, Object.class);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RemoteException(e.getMessage(), e);
                }
            }
            is.close();
        }
        return object;
    }

    public void close() throws RemoteException {
        try {
            this.ropConnector.close();
        }
        catch (IOException e) {
            throw new RemoteException("Exception while closing ROP resources", e);
        }
    }
}

