/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.PropertyDataSourceFactory;
import org.apache.cayenne.configuration.server.XMLPoolingDataSourceFactory;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.BeforeScopeEnd;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.ScopeEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingDataSourceFactory
implements DataSourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(DelegatingDataSourceFactory.class);
    @Inject
    protected AdhocObjectFactory objectFactory;
    @Inject
    protected RuntimeProperties properties;
    protected Map<DataSource, ScopeEventListener> managedDataSources = new ConcurrentHashMap<DataSource, ScopeEventListener>();

    @Override
    public DataSource getDataSource(DataNodeDescriptor nodeDescriptor) throws Exception {
        DataSource dataSource = this.getDataSourceFactory(nodeDescriptor).getDataSource(nodeDescriptor);
        this.attachToScope(dataSource);
        return dataSource;
    }

    @BeforeScopeEnd
    public void shutdown() {
        for (ScopeEventListener listener : this.managedDataSources.values()) {
            listener.beforeScopeEnd();
        }
        this.managedDataSources.clear();
    }

    protected void attachToScope(DataSource dataSource) {
        if (!this.managedDataSources.containsKey(dataSource) && dataSource instanceof ScopeEventListener) {
            this.managedDataSources.put(dataSource, (ScopeEventListener)((Object)dataSource));
        }
    }

    protected DataSourceFactory getDataSourceFactory(DataNodeDescriptor nodeDescriptor) {
        String typeName = this.shouldConfigureDataSourceFromProperties(nodeDescriptor) ? PropertyDataSourceFactory.class.getName() : nodeDescriptor.getDataSourceFactoryType();
        if (typeName == null) {
            if (nodeDescriptor.getDataSourceDescriptor() == null) {
                throw new CayenneRuntimeException("DataNodeDescriptor '%s' has null 'dataSourceFactoryType' and 'dataSourceDescriptor' properties", nodeDescriptor.getName());
            }
            typeName = XMLPoolingDataSourceFactory.class.getName();
        }
        return this.objectFactory.newInstance(DataSourceFactory.class, typeName);
    }

    private String getDataNodePropertyName(DataNodeDescriptor nodeDescriptor, String propertyConstant) {
        return propertyConstant + "." + nodeDescriptor.getDataChannelDescriptor().getName() + "." + nodeDescriptor.getName();
    }

    private void findUnusedProperties(DataNodeDescriptor nodeDescriptor) {
        String[] verifiableProperties;
        if (!logger.isInfoEnabled() || nodeDescriptor.getDataChannelDescriptor() == null) {
            return;
        }
        boolean found = false;
        StringBuilder logResult = new StringBuilder();
        String nodeName = nodeDescriptor.getDataChannelDescriptor().getName() + "." + nodeDescriptor.getName();
        logResult.append("Following runtime properties were ignored for node '").append(nodeName).append("': ");
        for (String propertyConstant : verifiableProperties = new String[]{"cayenne.jdbc.username", "cayenne.jdbc.password", "cayenne.jdbc.max_connections", "cayenne.jdbc.min_connections", "cayenne.jdbc.max_wait", "cayenne.jdbc.validation_query"}) {
            String property = this.properties.get(this.getDataNodePropertyName(nodeDescriptor, propertyConstant));
            if (property != null) {
                logResult.append(this.getDataNodePropertyName(nodeDescriptor, propertyConstant)).append(", ");
                found = true;
            }
            if ((property = this.properties.get(propertyConstant)) == null) continue;
            logResult.append(propertyConstant).append(", ");
            found = true;
        }
        if (found) {
            logResult.delete(logResult.length() - 2, logResult.length()).append(". Will use project DataSource configuration. ").append("Set driver and url properties to enable DataSource configuration override. ");
            logger.info(logResult.toString());
        }
    }

    protected boolean shouldConfigureDataSourceFromProperties(DataNodeDescriptor nodeDescriptor) {
        String channelName = nodeDescriptor.getDataChannelDescriptor() != null ? nodeDescriptor.getDataChannelDescriptor().getName() : null;
        String driver = this.properties.get("cayenne.jdbc.driver");
        if (driver == null && channelName != null) {
            driver = this.properties.get(this.getDataNodePropertyName(nodeDescriptor, "cayenne.jdbc.driver"));
        }
        if (driver == null) {
            this.findUnusedProperties(nodeDescriptor);
            return false;
        }
        String url = this.properties.get("cayenne.jdbc.url");
        if (url == null && channelName != null) {
            url = this.properties.get(this.getDataNodePropertyName(nodeDescriptor, "cayenne.jdbc.url"));
        }
        if (url == null) {
            this.findUnusedProperties(nodeDescriptor);
            return false;
        }
        logger.info(String.format("Found DataSourceFactory system property overrides for URL and Driver of '%s.%s' node. Will ignore project DataSource configuration.", channelName, nodeDescriptor.getName()));
        return true;
    }
}

