/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration2.convert.DefaultConversionHandler;
import org.apache.commons.configuration2.convert.LegacyListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.convert.MyNumber;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDefaultConversionHandler {
    private static final String VAR = "${test}";
    private static final String REPLACEMENT = "1";
    private DefaultConversionHandler handler;

    private static ConfigurationInterpolator createInterpolator() {
        return new ConfigurationInterpolator(){

            public Object interpolate(Object value) {
                if (TestDefaultConversionHandler.VAR.equals(value)) {
                    return TestDefaultConversionHandler.REPLACEMENT;
                }
                return value;
            }
        };
    }

    private void checkSingleValue(Integer expResult) {
        Assertions.assertEquals((int)Integer.parseInt(REPLACEMENT), (int)expResult);
    }

    @BeforeEach
    public void setUp() {
        this.handler = new DefaultConversionHandler();
    }

    @Test
    public void testGetDateFormatNotSet() {
        Assertions.assertEquals((Object)"yyyy-MM-dd HH:mm:ss", (Object)this.handler.getDateFormat());
    }

    @Test
    public synchronized void testListDelimiterHandler() {
        Assertions.assertEquals((Object)DefaultConversionHandler.LIST_DELIMITER_HANDLER, (Object)this.handler.getListDelimiterHandler());
        this.handler.setListDelimiterHandler(null);
        Assertions.assertEquals((Object)DefaultConversionHandler.LIST_DELIMITER_HANDLER, (Object)this.handler.getListDelimiterHandler());
        LegacyListDelimiterHandler legacyListDelimiterHandler = new LegacyListDelimiterHandler(',');
        this.handler.setListDelimiterHandler((ListDelimiterHandler)legacyListDelimiterHandler);
        Assertions.assertEquals((Object)legacyListDelimiterHandler, (Object)this.handler.getListDelimiterHandler());
        this.handler.setListDelimiterHandler(null);
        Assertions.assertEquals((Object)DefaultConversionHandler.LIST_DELIMITER_HANDLER, (Object)this.handler.getListDelimiterHandler());
    }

    @Test
    public void testSetDateFormat() {
        String dateFormat = "dd.MM.yyyy";
        this.handler.setDateFormat("dd.MM.yyyy");
        Assertions.assertEquals((Object)"dd.MM.yyyy", (Object)this.handler.getDateFormat());
    }

    @Test
    public void testToArrayEmptyString() {
        int[] array = (int[])this.handler.toArray((Object)"", Integer.TYPE, null);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    public void testToArrayNullInput() {
        Assertions.assertNull((Object)this.handler.toArray(null, Integer.class, null));
    }

    @Test
    public void testToArrayObject() {
        List<String> src = Arrays.asList(VAR, "100");
        Object[] array = (Integer[])this.handler.toArray(src, Integer.class, TestDefaultConversionHandler.createInterpolator());
        Assertions.assertArrayEquals((Object[])new Integer[]{Integer.valueOf(REPLACEMENT), Integer.valueOf(src.get(1))}, (Object[])array);
    }

    @Test
    public void testToArrayPrimitiveOtherType() {
        List<String> src = Arrays.asList(VAR, "100");
        int[] array = (int[])this.handler.toArray(src, Integer.TYPE, TestDefaultConversionHandler.createInterpolator());
        Assertions.assertArrayEquals((int[])new int[]{Integer.parseInt(REPLACEMENT), Integer.parseInt(src.get(1))}, (int[])array);
    }

    @Test
    public void testToArrayPrimitiveSameType() {
        int[] src = new int[]{1, 2, 3, 4, 5, 6};
        int[] array = (int[])this.handler.toArray((Object)src, Integer.TYPE, TestDefaultConversionHandler.createInterpolator());
        Assertions.assertArrayEquals((int[])src, (int[])array);
    }

    @Test
    public void testToArrayPrimitiveWrapperType() {
        Integer[] src = new Integer[]{0, 1, 2, 4, 8, 16, 32, 64, 128};
        int[] array = (int[])this.handler.toArray((Object)src, Integer.TYPE, TestDefaultConversionHandler.createInterpolator());
        Assertions.assertArrayEquals((int[])new int[]{0, 1, 2, 4, 8, 16, 32, 64, 128}, (int[])array);
    }

    @Test
    public void testToCalendarWithDefaultFormat() {
        Calendar cal = (Calendar)this.handler.to((Object)"2013-08-19 21:17:22", Calendar.class, null);
        Assertions.assertEquals((int)19, (int)cal.get(5));
        Assertions.assertEquals((int)7, (int)cal.get(2));
        Assertions.assertEquals((int)2013, (int)cal.get(1));
        Assertions.assertEquals((int)21, (int)cal.get(11));
        Assertions.assertEquals((int)17, (int)cal.get(12));
        Assertions.assertEquals((int)22, (int)cal.get(13));
    }

    @Test
    public void testToCollectionEmptyString() {
        ArrayList col = new ArrayList(1);
        this.handler.toCollection((Object)"", Integer.class, null, col);
        Assertions.assertTrue((boolean)col.isEmpty());
    }

    @Test
    public void testToCollectionNullCollection() {
        List<Integer> src = Arrays.asList(1, 2, 3);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.handler.toCollection((Object)src, Integer.class, null, null));
    }

    @Test
    public void testToCollectionNullInput() {
        ArrayList col = new ArrayList();
        this.handler.toCollection(null, Integer.class, null, col);
        Assertions.assertTrue((boolean)col.isEmpty());
    }

    @Test
    public void testToCollectionSuccess() {
        Object[] src = new Object[]{VAR, "100"};
        ArrayList col = new ArrayList(src.length);
        this.handler.toCollection((Object)src, Integer.class, TestDefaultConversionHandler.createInterpolator(), col);
        Assertions.assertEquals(Arrays.asList(Integer.valueOf(REPLACEMENT), Integer.valueOf(src[1].toString())), col);
    }

    @Test
    public void testToCustomNumber() {
        Assertions.assertEquals((Object)new MyNumber(1L), (Object)DefaultConversionHandler.INSTANCE.convertValue((Object)new MyNumber(1L), MyNumber.class, null));
        Assertions.assertEquals((Object)new MyNumber(2L), (Object)DefaultConversionHandler.INSTANCE.convertValue((Object)new MyNumber(2L), MyNumber.class, null));
        Assertions.assertEquals((Object)new MyNumber(3L), (Object)DefaultConversionHandler.INSTANCE.convertValue((Object)"3", MyNumber.class, null));
        Assertions.assertNull((Object)DefaultConversionHandler.INSTANCE.convertValue(null, MyNumber.class, null));
        Assertions.assertEquals((Object)new MyNumber(1L), (Object)DefaultConversionHandler.INSTANCE.to((Object)new MyNumber(1L), MyNumber.class, null));
        Assertions.assertEquals((Object)new MyNumber(2L), (Object)DefaultConversionHandler.INSTANCE.to((Object)new MyNumber(2L), MyNumber.class, null));
        Assertions.assertEquals((Object)new MyNumber(3L), (Object)DefaultConversionHandler.INSTANCE.to((Object)"3", MyNumber.class, null));
        Assertions.assertNull((Object)DefaultConversionHandler.INSTANCE.to(null, MyNumber.class, null));
    }

    @Test
    public void testToDateWithFormat() {
        this.handler.setDateFormat("dd.MM.yyyy");
        Date dt = (Date)this.handler.to((Object)"19.08.2013", Date.class, null);
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        Assertions.assertEquals((int)19, (int)cal.get(5));
        Assertions.assertEquals((int)7, (int)cal.get(2));
        Assertions.assertEquals((int)2013, (int)cal.get(1));
    }

    @Test
    public void testToFailedConversion() {
        Assertions.assertThrows(ConversionException.class, () -> this.handler.to((Object)VAR, Integer.class, null));
    }

    @Test
    public void testToFromArray() {
        Object[] src = new Object[]{VAR, true, 20130808221759L};
        this.checkSingleValue((Integer)this.handler.to((Object)src, Integer.class, TestDefaultConversionHandler.createInterpolator()));
    }

    @Test
    public void testToFromCollection() {
        List<String> src = Arrays.asList(VAR, "true", "1000");
        this.checkSingleValue((Integer)this.handler.to(src, Integer.class, TestDefaultConversionHandler.createInterpolator()));
    }

    @Test
    public void testToFromEmptyCollection() {
        Assertions.assertNull((Object)this.handler.to(new ArrayList(), Integer.class, TestDefaultConversionHandler.createInterpolator()));
    }

    @Test
    public void testToFromIterator() {
        Iterator<String> src = Arrays.asList(VAR, "true", "1000").iterator();
        this.checkSingleValue((Integer)this.handler.to(src, Integer.class, TestDefaultConversionHandler.createInterpolator()));
    }

    @Test
    public void testToNoInterpolator() {
        Integer result = (Integer)this.handler.to((Object)REPLACEMENT, Integer.class, null);
        this.checkSingleValue(result);
    }

    @Test
    public void testToNull() {
        Assertions.assertNull((Object)this.handler.to(null, Integer.class, null));
    }

    @Test
    public void testToPrimitive() {
        Long value = 20130819214935L;
        Object result = this.handler.to((Object)value.toString(), Long.TYPE, null);
        Assertions.assertEquals((Object)value, (Object)result);
    }

    @Test
    public void testToWithInterpolator() {
        Integer result = (Integer)this.handler.to((Object)VAR, Integer.class, TestDefaultConversionHandler.createInterpolator());
        this.checkSingleValue(result);
    }
}

