/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SynchronizerTestImpl;
import org.apache.commons.configuration2.TempDirUtils;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.DefaultFileSystem;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.io.FileHandlerListener;
import org.apache.commons.configuration2.io.FileHandlerListenerAdapter;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorAware;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystem;
import org.apache.commons.configuration2.io.InputStreamSupport;
import org.apache.commons.configuration2.io.ProvidedURLLocationStrategy;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;

public class TestFileHandler {
    private static final String TEST_FILENAME = "test.properties";
    private static final String CONTENT = "TestFileHandler: This is test content.";
    @TempDir
    public File tempFolder;

    private static void checkEmptyLocator(FileBasedFileLocatorAwareTestImpl content) {
        Assertions.assertNull((Object)content.getLocator().getSourceURL());
        Assertions.assertNull((Object)content.getLocator().getBasePath());
        Assertions.assertNull((Object)content.getLocator().getFileName());
    }

    private static String readFile(File f) {
        return (String)Assertions.assertDoesNotThrow(() -> {
            try (FileReader in = new FileReader(f);){
                String string = TestFileHandler.readReader(in);
                return string;
            }
        });
    }

    private static String readReader(Reader in) throws IOException {
        int c;
        StringBuilder buf = new StringBuilder();
        while ((c = in.read()) != -1) {
            buf.append((char)c);
        }
        return buf.toString();
    }

    private File createTestFile() {
        return this.createTestFile(null);
    }

    private File createTestFile(File f) {
        return (File)Assertions.assertDoesNotThrow(() -> {
            File file = f;
            if (file == null) {
                file = TempDirUtils.newFile(this.tempFolder);
            }
            try (FileWriter out = new FileWriter(file);){
                out.write(CONTENT);
            }
            return file;
        });
    }

    private Path createTestPath() {
        return this.createTestFile().toPath();
    }

    private URI createTestURI() {
        return this.createTestFile().toURI();
    }

    private URL createTestURL() throws MalformedURLException {
        return this.createTestURI().toURL();
    }

    @Test
    public void testAddFileHandlerListenerNull() {
        FileHandler fileHandler = new FileHandler();
        Assertions.assertThrows(IllegalArgumentException.class, () -> fileHandler.addFileHandlerListener(null));
    }

    @Test
    public void testAssignNullHandler() {
        FileBasedTestImpl obj = new FileBasedTestImpl();
        Assertions.assertThrows(IllegalArgumentException.class, () -> new FileHandler(obj, null));
    }

    @Test
    public void testAssignWithFileBased() {
        FileHandler h1 = new FileHandler();
        File f = new File("testfile.txt");
        h1.setFile(f);
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler h2 = new FileHandler((FileBased)content, h1);
        h1.setFileName("someOtherFile.txt");
        Assertions.assertSame((Object)content, (Object)h2.getContent());
        Assertions.assertEquals((Object)f, (Object)h2.getFile());
    }

    @Test
    public void testClearLocation() {
        FileHandler handler = new FileHandler();
        handler.setFile(this.createTestFile());
        handler.clearLocation();
        Assertions.assertFalse((boolean)handler.isLocationDefined());
        Assertions.assertNull((Object)handler.getFile());
        Assertions.assertNull((Object)handler.getURL());
        Assertions.assertNull((Object)handler.getBasePath());
        Assertions.assertNull((Object)handler.getPath());
    }

    @Test
    public void testGetBasePathUndefined() {
        Assertions.assertNull((Object)new FileHandler().getBasePath());
    }

    @Test
    public void testGetFileNameUndefined() {
        Assertions.assertNull((Object)new FileHandler().getFileName());
    }

    @Test
    public void testGetFileSystemDefault() {
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        Assertions.assertEquals((Object)FileLocatorUtils.DEFAULT_FILE_SYSTEM, (Object)handler.getFileSystem());
    }

    @Test
    public void testGetLocationStrategyDefault() {
        FileHandler handler = new FileHandler();
        Assertions.assertNull((Object)handler.getFileLocator().getLocationStrategy());
        Assertions.assertSame((Object)FileLocatorUtils.DEFAULT_LOCATION_STRATEGY, (Object)handler.getLocationStrategy());
    }

    @Test
    public void testInitFromMap() {
        FileLocator locator = FileLocatorUtils.fileLocator().fileName(TEST_FILENAME).basePath("someBasePath").encoding("someEncoding").create();
        HashMap map = new HashMap();
        FileLocatorUtils.put((FileLocator)locator, map);
        FileHandler handler = FileHandler.fromMap(map);
        Assertions.assertEquals((Object)locator, (Object)handler.getFileLocator());
    }

    @Test
    public void testInitPropertiesMultiThreaded() throws InterruptedException {
        String encoding = "TestEncoding";
        DefaultFileSystem fileSystem = new DefaultFileSystem();
        ProvidedURLLocationStrategy locationStrategy = new ProvidedURLLocationStrategy();
        int loops = 8;
        for (int i = 0; i < 8; ++i) {
            FileHandler handler = new FileHandler();
            Thread t1 = new Thread(() -> TestFileHandler.lambda$testInitPropertiesMultiThreaded$4(handler, (FileSystem)fileSystem));
            Thread t2 = new Thread(() -> handler.setFileName(TEST_FILENAME));
            Thread t3 = new Thread(() -> handler.setEncoding("TestEncoding"));
            Thread t4 = new Thread(() -> TestFileHandler.lambda$testInitPropertiesMultiThreaded$7(handler, (FileLocationStrategy)locationStrategy));
            List<Thread> threads = Arrays.asList(t1, t2, t3, t4);
            for (Thread t : threads) {
                t.start();
            }
            for (Thread t : threads) {
                t.join();
            }
            FileLocator locator = handler.getFileLocator();
            Assertions.assertEquals((Object)TEST_FILENAME, (Object)locator.getFileName());
            Assertions.assertNull((Object)locator.getSourceURL());
            Assertions.assertEquals((Object)"TestEncoding", (Object)locator.getEncoding());
            Assertions.assertSame((Object)fileSystem, (Object)locator.getFileSystem());
            Assertions.assertSame((Object)locationStrategy, (Object)locator.getLocationStrategy());
        }
    }

    @Test
    public void testIsLocationDefinedBasePathOnly() {
        FileHandler handler = new FileHandler();
        handler.setBasePath(this.createTestFile().getParent());
        Assertions.assertFalse((boolean)handler.isLocationDefined());
    }

    @Test
    public void testIsLocationDefinedFalse() {
        FileHandler handler = new FileHandler();
        Assertions.assertFalse((boolean)handler.isLocationDefined());
    }

    @Test
    public void testIsLocationDefinedFile() {
        FileHandler handler = new FileHandler();
        handler.setFile(this.createTestFile());
        Assertions.assertTrue((boolean)handler.isLocationDefined());
    }

    @Test
    public void testIsLocationDefinedFileName() {
        FileHandler handler = new FileHandler();
        handler.setFileName(this.createTestFile().getName());
        Assertions.assertTrue((boolean)handler.isLocationDefined());
    }

    @Test
    public void testIsLocationDefinedPath() {
        FileHandler handler = new FileHandler();
        handler.setPath(this.createTestFile().getAbsolutePath());
        Assertions.assertTrue((boolean)handler.isLocationDefined());
    }

    @Test
    public void testIsLocationDefinedURL() throws IOException {
        FileHandler handler = new FileHandler();
        handler.setURL(this.createTestURL());
        Assertions.assertTrue((boolean)handler.isLocationDefined());
    }

    @Test
    public void testLoadDirectoryFile() {
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        Assertions.assertThrows(ConfigurationException.class, () -> handler.load(ConfigurationAssert.TEST_DIR));
    }

    @Test
    public void testLoadDirectoryString() {
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        String fileName = ConfigurationAssert.TEST_DIR.getAbsolutePath();
        Assertions.assertThrows(ConfigurationException.class, () -> handler.load(fileName));
    }

    @Test
    public void testLoadEvents() throws ConfigurationException {
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        FileHandlerListenerTestImpl listener = new FileHandlerListenerTestImpl(handler);
        handler.addFileHandlerListener((FileHandlerListener)listener);
        handler.load(this.createTestFile());
        listener.checkMethods("loadingloaded");
    }

    @Test
    public void testLoadFileLocatorAware() throws IOException, ConfigurationException {
        File file = this.createTestFile();
        FileBasedFileLocatorAwareTestImpl content = new FileBasedFileLocatorAwareTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.setFile(file);
        handler.load();
        Assertions.assertEquals((Object)(file.toURI().toURL().toString() + ": " + CONTENT), (Object)content.getContent());
    }

    @Test
    public void testLoadFileLocatorAwareReader() throws ConfigurationException {
        FileBasedFileLocatorAwareTestImpl content = new FileBasedFileLocatorAwareTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.load((Reader)new StringReader(CONTENT));
        TestFileHandler.checkEmptyLocator(content);
    }

    @Test
    public void testLoadFileLocatorAwareStream() throws ConfigurationException {
        FileBasedFileLocatorAwareTestImpl content = new FileBasedFileLocatorAwareTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        ByteArrayInputStream bos = new ByteArrayInputStream(CONTENT.getBytes());
        handler.load((InputStream)bos);
        TestFileHandler.checkEmptyLocator(content);
    }

    @Test
    public void testLoadFromClassPath() throws ConfigurationException {
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler config1 = new FileHandler((FileBased)content);
        config1.setFileName("config/deep/deeptest.properties");
        config1.load();
        Assertions.assertFalse((boolean)content.getContent().isEmpty());
    }

    @Test
    public void testLoadFromFile() throws ConfigurationException {
        FileBasedTestImpl content = new FileBasedTestImpl();
        File file = this.createTestFile();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.load(file);
        Assertions.assertEquals((Object)CONTENT, (Object)content.getContent());
    }

    @Test
    public void testLoadFromFileNameLocation() throws ConfigurationException {
        File file = this.createTestFile();
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.setBasePath(file.getParentFile().getAbsolutePath());
        handler.setFileName(file.getName());
        handler.load();
        Assertions.assertEquals((Object)CONTENT, (Object)content.getContent());
    }

    @Test
    public void testLoadFromFileNoContent() {
        FileHandler handler = new FileHandler();
        File file = this.createTestFile();
        ConfigurationException cex = (ConfigurationException)Assertions.assertThrows(ConfigurationException.class, () -> handler.load(file));
        Assertions.assertEquals((Object)"No content available!", (Object)cex.getMessage());
    }

    @Test
    public void testLoadFromFilePath() throws ConfigurationException {
        File file = this.createTestFile();
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.load(file.getAbsolutePath());
        Assertions.assertEquals((Object)CONTENT, (Object)content.getContent());
    }

    @Test
    public void testLoadFromFilePathWithURLDefined() throws ConfigurationException {
        File file = this.createTestFile();
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.setURL(ConfigurationAssert.getTestURL("test.xml"));
        handler.load(file.getAbsolutePath());
        Assertions.assertEquals((Object)CONTENT, (Object)content.getContent());
    }

    @Test
    public void testLoadFromReader() throws Exception {
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        try (FileReader in = new FileReader(this.createTestFile());){
            handler.load((Reader)in);
        }
        Assertions.assertEquals((Object)CONTENT, (Object)content.getContent());
    }

    @Test
    public void testLoadFromReaderIOException() throws IOException, ConfigurationException {
        FileBased content = (FileBased)Mockito.mock(FileBased.class);
        StringReader in = new StringReader(CONTENT);
        IOException ioex = new IOException("Test exception");
        ((FileBased)Mockito.doThrow((Throwable[])new Throwable[]{ioex}).when((Object)content)).read((Reader)in);
        FileHandler handler = new FileHandler(content);
        ConfigurationException cex = (ConfigurationException)Assertions.assertThrows(ConfigurationException.class, () -> handler.load(in));
        Assertions.assertEquals((Object)ioex, (Object)cex.getCause());
        ((FileBased)Mockito.verify((Object)content)).read((Reader)in);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{content});
    }

    @Test
    public void testLoadFromStream() throws Exception {
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        try (InputStream in = Files.newInputStream(this.createTestPath(), new OpenOption[0]);){
            handler.load(in);
        }
        Assertions.assertEquals((Object)CONTENT, (Object)content.getContent());
    }

    @Test
    public void testLoadFromURL() throws Exception {
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.load(this.createTestURL());
        Assertions.assertEquals((Object)CONTENT, (Object)content.getContent());
    }

    @Test
    public void testLoadFromURLLocation() throws Exception {
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.setURL(this.createTestURL());
        handler.load();
        Assertions.assertEquals((Object)CONTENT, (Object)content.getContent());
    }

    @Test
    public void testLoadInputStreamSupport() throws ConfigurationException {
        FileBasedInputStreamSupportTestImpl content = new FileBasedInputStreamSupportTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        ByteArrayInputStream bin = new ByteArrayInputStream(CONTENT.getBytes());
        handler.load((InputStream)bin);
        Assertions.assertEquals((Object)"InputStream = TestFileHandler: This is test content.", (Object)content.getContent());
    }

    @Test
    public void testLoadInputStreamSupportIOException() throws ConfigurationException, IOException {
        FileBasedInputStreamSupportTestImpl content = (FileBasedInputStreamSupportTestImpl)Mockito.mock(FileBasedInputStreamSupportTestImpl.class);
        ByteArrayInputStream bin = new ByteArrayInputStream(CONTENT.getBytes());
        IOException ioex = new IOException();
        ((FileBasedInputStreamSupportTestImpl)Mockito.doThrow((Throwable[])new Throwable[]{ioex}).when((Object)content)).read(bin);
        FileHandler handler = new FileHandler((FileBased)content);
        ConfigurationException cex = (ConfigurationException)Assertions.assertThrows(ConfigurationException.class, () -> handler.load((InputStream)bin));
        Assertions.assertEquals((Object)ioex, (Object)cex.getCause());
        ((FileBasedInputStreamSupportTestImpl)Mockito.verify((Object)content)).read(bin);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{content});
    }

    @Test
    public void testLoadNoContent() {
        FileHandler handler = new FileHandler();
        StringReader reader = new StringReader(CONTENT);
        Assertions.assertThrows(ConfigurationException.class, () -> handler.load((Reader)reader));
    }

    @Test
    public void testLoadNoLocation() {
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        Assertions.assertThrows(ConfigurationException.class, () -> ((FileHandler)handler).load());
    }

    @Test
    public void testLoadSynchronized() throws ConfigurationException {
        PropertiesConfiguration config = new PropertiesConfiguration();
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        config.setSynchronizer((Synchronizer)sync);
        FileHandler handler = new FileHandler((FileBased)config);
        handler.load(ConfigurationAssert.getTestFile(TEST_FILENAME));
        sync.verifyStart(SynchronizerTestImpl.Methods.BEGIN_WRITE);
        sync.verifyEnd(SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testLocateSuccess() throws ConfigurationException {
        FileHandler handler = new FileHandler();
        handler.setFileName(TEST_FILENAME);
        Assertions.assertTrue((boolean)handler.locate());
        FileLocator locator = handler.getFileLocator();
        Assertions.assertNotNull((Object)locator.getSourceURL());
        Assertions.assertNotNull((Object)locator.getBasePath());
        Assertions.assertEquals((Object)TEST_FILENAME, (Object)locator.getFileName());
        PropertiesConfiguration config = new PropertiesConfiguration();
        FileHandler h2 = new FileHandler((FileBased)config);
        h2.setURL(locator.getSourceURL());
        h2.load();
        Assertions.assertTrue((boolean)config.getBoolean("configuration.loaded"));
    }

    @Test
    public void testLocateUndefinedLocator() {
        FileHandler handler = new FileHandler();
        handler.setBasePath("only/a/base/path");
        FileLocator locator = handler.getFileLocator();
        Assertions.assertFalse((boolean)handler.locate());
        Assertions.assertSame((Object)locator, (Object)handler.getFileLocator());
    }

    @Test
    public void testLocateUnknownFile() {
        FileHandler handler = new FileHandler();
        handler.setFileName("unknown file");
        FileLocator locator = handler.getFileLocator();
        Assertions.assertFalse((boolean)handler.locate());
        Assertions.assertSame((Object)locator, (Object)handler.getFileLocator());
    }

    @Test
    public void testLocationChangedBasePath() {
        FileHandler handler = new FileHandler();
        FileHandlerListenerTestImpl listener = new FileHandlerListenerTestImpl(handler);
        handler.addFileHandlerListener((FileHandlerListener)listener);
        handler.setBasePath(TEST_FILENAME);
        listener.checkMethods("locationChanged");
    }

    @Test
    public void testLocationChangedEncoding() {
        FileHandler handler = new FileHandler();
        FileHandlerListenerTestImpl listener = new FileHandlerListenerTestImpl(handler);
        handler.addFileHandlerListener((FileHandlerListener)listener);
        handler.setEncoding(StandardCharsets.UTF_8.name());
        listener.checkMethods("locationChanged");
    }

    @Test
    public void testLocationChangedFile() throws IOException {
        FileHandler handler = new FileHandler();
        FileHandlerListenerTestImpl listener = new FileHandlerListenerTestImpl(handler);
        handler.addFileHandlerListener((FileHandlerListener)listener);
        handler.setFile(TempDirUtils.newFile(this.tempFolder));
        listener.checkMethods("locationChanged");
    }

    @Test
    public void testLocationChangedFileName() {
        FileHandler handler = new FileHandler();
        FileHandlerListenerTestImpl listener = new FileHandlerListenerTestImpl(handler);
        handler.addFileHandlerListener((FileHandlerListener)listener);
        handler.setFileName(TEST_FILENAME);
        listener.checkMethods("locationChanged");
    }

    @Test
    public void testLocationChangedFileSystem() {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        FileHandler handler = new FileHandler();
        FileHandlerListenerTestImpl listener = new FileHandlerListenerTestImpl(handler);
        handler.addFileHandlerListener((FileHandlerListener)listener);
        handler.setFileSystem(fs);
        listener.checkMethods("locationChanged");
    }

    @Test
    public void testLocationChangedLocator() {
        FileHandler handler = new FileHandler();
        FileHandlerListenerTestImpl listener = new FileHandlerListenerTestImpl(handler);
        handler.addFileHandlerListener((FileHandlerListener)listener);
        handler.setFileLocator(FileLocatorUtils.fileLocator().fileName(TEST_FILENAME).create());
        listener.checkMethods("locationChanged");
    }

    @Test
    public void testLocationChangedPath() {
        FileHandler handler = new FileHandler();
        FileHandlerListenerTestImpl listener = new FileHandlerListenerTestImpl(handler);
        handler.addFileHandlerListener((FileHandlerListener)listener);
        handler.setPath(TEST_FILENAME);
        listener.checkMethods("locationChanged");
    }

    @Test
    public void testLocationChangedURL() throws IOException {
        FileHandler handler = new FileHandler();
        FileHandlerListenerTestImpl listener = new FileHandlerListenerTestImpl(handler);
        handler.addFileHandlerListener((FileHandlerListener)listener);
        URL url = TempDirUtils.newFile(this.tempFolder).toURI().toURL();
        handler.setURL(url);
        listener.checkMethods("locationChanged");
    }

    @Test
    public void testLocatorAwareEncoding() throws ConfigurationException {
        FileBasedFileLocatorAwareTestImpl content = new FileBasedFileLocatorAwareTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        String encoding = "testEncoding";
        handler.setEncoding("testEncoding");
        handler.save((Writer)new StringWriter());
        Assertions.assertEquals((Object)"testEncoding", (Object)content.getLocator().getEncoding());
    }

    @Test
    public void testPathWithPlus() throws ConfigurationException, IOException {
        File saveFile = TempDirUtils.newFile("test+config.properties", this.tempFolder);
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.setFile(saveFile);
        handler.save();
        Assertions.assertEquals((Object)CONTENT, (Object)TestFileHandler.readFile(saveFile));
    }

    @Test
    public void testPathWithSpaces() throws ConfigurationException, IOException {
        File path = TempDirUtils.newFolder("path with spaces", this.tempFolder);
        File confFile = new File(path, "config-test.properties");
        File testFile = this.createTestFile(confFile);
        URL url = testFile.toURI().toURL();
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.setURL(url);
        handler.load();
        Assertions.assertEquals((Object)CONTENT, (Object)content.getContent());
        File out = new File(path, "out.txt");
        handler.save(out);
        Assertions.assertEquals((Object)CONTENT, (Object)TestFileHandler.readFile(out));
    }

    @Test
    public void testResetFileSystem() {
        FileSystem sys = (FileSystem)Mockito.mock(FileSystem.class);
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.setFileSystem(sys);
        handler.resetFileSystem();
        Assertions.assertEquals((Object)FileLocatorUtils.DEFAULT_FILE_SYSTEM, (Object)handler.getFileSystem());
    }

    @Test
    public void testSaveEvents() throws IOException, ConfigurationException {
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        FileHandlerListenerTestImpl listener = new FileHandlerListenerTestImpl(handler);
        handler.addFileHandlerListener((FileHandlerListener)listener);
        File f = TempDirUtils.newFile(this.tempFolder);
        handler.save(f);
        listener.checkMethods("savingsaved");
    }

    @Test
    public void testSaveFileLocatorAware() throws ConfigurationException, IOException {
        File file = TempDirUtils.newFile(this.tempFolder);
        FileBasedFileLocatorAwareTestImpl content = new FileBasedFileLocatorAwareTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.save(file);
        Assertions.assertEquals((Object)(file.toURI().toURL() + ": " + CONTENT), (Object)TestFileHandler.readFile(file));
    }

    @Test
    public void testSaveFileLocatorAwareToStream() throws ConfigurationException {
        FileBasedFileLocatorAwareTestImpl content = new FileBasedFileLocatorAwareTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.save((OutputStream)new ByteArrayOutputStream());
        TestFileHandler.checkEmptyLocator(content);
    }

    @Test
    public void testSaveFileLocatorAwareToWriter() throws ConfigurationException {
        FileBasedFileLocatorAwareTestImpl content = new FileBasedFileLocatorAwareTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.save((Writer)new StringWriter());
        TestFileHandler.checkEmptyLocator(content);
    }

    @Test
    public void testSaveNoLocation() {
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        Assertions.assertThrows(ConfigurationException.class, () -> ((FileHandler)handler).save());
    }

    @Test
    public void testSaveSynchronized() throws ConfigurationException, IOException {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.addProperty("test.synchronized", (Object)Boolean.TRUE);
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        config.setSynchronizer((Synchronizer)sync);
        FileHandler handler = new FileHandler((FileBased)config);
        File f = TempDirUtils.newFile(this.tempFolder);
        handler.save(f);
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testSaveToFile() throws ConfigurationException, IOException {
        File file = TempDirUtils.newFile(this.tempFolder);
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.save(file);
        Assertions.assertEquals((Object)CONTENT, (Object)TestFileHandler.readFile(file));
    }

    @Test
    public void testSaveToFileName() throws ConfigurationException, IOException {
        File file = TempDirUtils.newFile(this.tempFolder);
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.save(file.getAbsolutePath());
        Assertions.assertEquals((Object)CONTENT, (Object)TestFileHandler.readFile(file));
    }

    @Test
    public void testSaveToFileNameLocation() throws ConfigurationException, IOException {
        File file = TempDirUtils.newFile(this.tempFolder);
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.setFileName(file.getAbsolutePath());
        handler.save();
        Assertions.assertEquals((Object)CONTENT, (Object)TestFileHandler.readFile(file));
    }

    @Test
    public void testSaveToFileNameURLException() throws IOException {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        File file = TempDirUtils.newFile(this.tempFolder);
        String basePath = "some base path";
        MalformedURLException urlex = new MalformedURLException("Test exception");
        String fileName = file.getName();
        Mockito.when((Object)fs.getURL("some base path", fileName)).thenThrow(new Throwable[]{urlex});
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.setBasePath("some base path");
        handler.setFileSystem(fs);
        ConfigurationException cex = (ConfigurationException)Assertions.assertThrows(ConfigurationException.class, () -> handler.save(fileName));
        Assertions.assertEquals((Object)urlex, (Object)cex.getCause());
        ((FileSystem)Mockito.verify((Object)fs)).getURL("some base path", fileName);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{fs});
    }

    @Test
    public void testSaveToFileNameURLNotResolved() throws IOException {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        File file = TempDirUtils.newFile(this.tempFolder);
        String fileName = file.getName();
        Mockito.when((Object)fs.getURL(null, fileName)).thenReturn(null);
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.setFileSystem(fs);
        Assertions.assertThrows(ConfigurationException.class, () -> handler.save(fileName));
        ((FileSystem)Mockito.verify((Object)fs)).getURL(null, fileName);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{fs});
    }

    @Test
    public void testSaveToStream() throws ConfigurationException, IOException {
        File file = TempDirUtils.newFile(this.tempFolder);
        try (FileOutputStream out = new FileOutputStream(file);){
            FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
            handler.save((OutputStream)out);
        }
        Assertions.assertEquals((Object)CONTENT, (Object)TestFileHandler.readFile(file));
    }

    @Test
    public void testSaveToURL() throws Exception {
        File file = TempDirUtils.newFile(this.tempFolder);
        URL url = file.toURI().toURL();
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.save(url);
        Assertions.assertEquals((Object)CONTENT, (Object)TestFileHandler.readFile(file));
    }

    @Test
    public void testSaveToURLLocation() throws ConfigurationException, IOException {
        File file = TempDirUtils.newFile(this.tempFolder);
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.setURL(file.toURI().toURL());
        handler.save();
        Assertions.assertEquals((Object)CONTENT, (Object)TestFileHandler.readFile(file));
    }

    @Test
    public void testSaveToWriter() throws ConfigurationException {
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        StringWriter out = new StringWriter();
        handler.save((Writer)out);
        Assertions.assertEquals((Object)CONTENT, (Object)out.toString());
    }

    @Test
    public void testSaveToWriterIOException() throws ConfigurationException, IOException {
        FileBased content = (FileBased)Mockito.mock(FileBased.class);
        StringWriter out = new StringWriter();
        IOException ioex = new IOException("Test exception!");
        ((FileBased)Mockito.doThrow((Throwable[])new Throwable[]{ioex}).when((Object)content)).write((Writer)out);
        FileHandler handler = new FileHandler(content);
        ConfigurationException cex = (ConfigurationException)Assertions.assertThrows(ConfigurationException.class, () -> handler.save((Writer)out));
        Assertions.assertEquals((Object)ioex, (Object)cex.getCause());
        ((FileBased)Mockito.verify((Object)content)).write((Writer)out);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{content});
    }

    @Test
    public void testSaveToWriterNoContent() {
        FileHandler handler = new FileHandler();
        StringWriter writer = new StringWriter();
        Assertions.assertThrows(ConfigurationException.class, () -> handler.save((Writer)writer));
    }

    @Test
    public void testSetBasePath() {
        FileHandler handler = new FileHandler();
        handler.setURL(ConfigurationAssert.getTestURL(TEST_FILENAME));
        String basePath = "target/test-classes";
        handler.setBasePath("target/test-classes");
        FileLocator locator = handler.getFileLocator();
        Assertions.assertEquals((Object)"target/test-classes", (Object)locator.getBasePath());
        Assertions.assertNull((Object)locator.getSourceURL());
        Assertions.assertNull((Object)locator.getFileName());
    }

    @Test
    public void testSetBasePathFileScheme() {
        FileHandler handler = new FileHandler();
        handler.setBasePath("file:/test/path/");
        Assertions.assertEquals((Object)"file:///test/path/", (Object)handler.getFileLocator().getBasePath());
    }

    @Test
    public void testSetFile() {
        FileHandler handler = new FileHandler();
        File directory = ConfigurationAssert.TEST_DIR;
        File file = ConfigurationAssert.getTestFile(TEST_FILENAME);
        handler.setFile(file);
        Assertions.assertEquals((Object)directory.getAbsolutePath(), (Object)handler.getBasePath());
        Assertions.assertEquals((Object)TEST_FILENAME, (Object)handler.getFileName());
        Assertions.assertEquals((Object)file.getAbsolutePath(), (Object)handler.getPath());
    }

    @Test
    public void testSetFileLocator() {
        FileLocator locator = FileLocatorUtils.fileLocator().fileName(TEST_FILENAME).create();
        FileHandler handler = new FileHandler();
        handler.setFileLocator(locator);
        Assertions.assertEquals((Object)TEST_FILENAME, (Object)handler.getFileName());
    }

    @Test
    public void testSetFileLocatorNull() {
        FileHandler handler = new FileHandler();
        Assertions.assertThrows(IllegalArgumentException.class, () -> handler.setFileLocator(null));
    }

    @Test
    public void testSetFileName() {
        FileHandler handler = new FileHandler();
        handler.setURL(ConfigurationAssert.getTestURL(TEST_FILENAME));
        handler.setFileName(TEST_FILENAME);
        Assertions.assertNull((Object)handler.getBasePath());
        Assertions.assertEquals((Object)TEST_FILENAME, (Object)handler.getFileName());
        Assertions.assertEquals((Object)TEST_FILENAME, (Object)handler.getFileLocator().getFileName());
        Assertions.assertNull((Object)handler.getFileLocator().getSourceURL());
    }

    @Test
    public void testSetFileNameFileScheme() {
        FileHandler handler = new FileHandler();
        handler.setFileName("file:/test/path/test.txt");
        Assertions.assertEquals((Object)"file:///test/path/test.txt", (Object)handler.getFileLocator().getFileName());
    }

    @Test
    public void testSetFileSystemNull() {
        FileSystem sys = (FileSystem)Mockito.mock(FileSystem.class);
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.setFileSystem(sys);
        Assertions.assertSame((Object)sys, (Object)handler.getFileSystem());
        handler.setFileSystem(null);
        Assertions.assertEquals((Object)FileLocatorUtils.DEFAULT_FILE_SYSTEM, (Object)handler.getFileSystem());
    }

    @Test
    public void testSetLocationStrategy() {
        FileLocationStrategy strategy = (FileLocationStrategy)Mockito.mock(FileLocationStrategy.class);
        FileHandler handler = new FileHandler();
        handler.setLocationStrategy(strategy);
        Assertions.assertSame((Object)strategy, (Object)handler.getFileLocator().getLocationStrategy());
        Assertions.assertSame((Object)strategy, (Object)handler.getLocationStrategy());
    }

    @Test
    public void testSetPath() throws MalformedURLException {
        FileHandler handler = new FileHandler();
        handler.setPath("target/test-classes" + File.separator + TEST_FILENAME);
        Assertions.assertEquals((Object)TEST_FILENAME, (Object)handler.getFileName());
        Assertions.assertEquals((Object)ConfigurationAssert.TEST_DIR.getAbsolutePath(), (Object)handler.getBasePath());
        File file = ConfigurationAssert.getTestFile(TEST_FILENAME);
        Assertions.assertEquals((Object)file.getAbsolutePath(), (Object)handler.getPath());
        Assertions.assertEquals((Object)file.toURI().toURL(), (Object)handler.getURL());
        Assertions.assertNull((Object)handler.getFileLocator().getSourceURL());
    }

    @Test
    public void testSettingFileNames() {
        String testProperties = ConfigurationAssert.getTestFile("test.xml").getAbsolutePath();
        String testBasePath = ConfigurationAssert.TEST_DIR.getAbsolutePath();
        FileHandler handler = new FileHandler();
        handler.setFileName(testProperties);
        Assertions.assertEquals((Object)testProperties.toString(), (Object)handler.getFileName());
        handler.setBasePath(testBasePath);
        handler.setFileName("hello.xml");
        Assertions.assertEquals((Object)"hello.xml", (Object)handler.getFileName());
        Assertions.assertEquals((Object)testBasePath.toString(), (Object)handler.getBasePath());
        Assertions.assertEquals((Object)new File(testBasePath, "hello.xml"), (Object)handler.getFile());
        handler.setBasePath(testBasePath);
        handler.setFileName("subdir/hello.xml");
        Assertions.assertEquals((Object)"subdir/hello.xml", (Object)handler.getFileName());
        Assertions.assertEquals((Object)testBasePath.toString(), (Object)handler.getBasePath());
        Assertions.assertEquals((Object)new File(testBasePath, "subdir/hello.xml"), (Object)handler.getFile());
    }

    @Test
    public void testSetURL() throws Exception {
        FileHandler handler = new FileHandler();
        handler.setURL(new URL("https://commons.apache.org/configuration/index.html"));
        Assertions.assertEquals((Object)"https://commons.apache.org/configuration/", (Object)handler.getBasePath());
        Assertions.assertEquals((Object)"index.html", (Object)handler.getFileName());
        Assertions.assertNull((Object)handler.getFileLocator().getFileName());
    }

    @Test
    public void testSetURLFileScheme() throws MalformedURLException {
        FileHandler handler = new FileHandler();
        handler.setURL(new URL("file:/temp/test.properties"));
        Assertions.assertEquals((Object)"file:///temp/", (Object)handler.getBasePath());
        Assertions.assertEquals((Object)TEST_FILENAME, (Object)handler.getFileName());
    }

    @Test
    public void testSetURLNull() {
        FileHandler handler = new FileHandler();
        handler.setURL(ConfigurationAssert.getTestURL(TEST_FILENAME));
        handler.setURL(null);
        FileLocator locator = handler.getFileLocator();
        Assertions.assertNull((Object)locator.getBasePath());
        Assertions.assertNull((Object)locator.getFileName());
        Assertions.assertNull((Object)locator.getSourceURL());
    }

    @Test
    public void testSetURLWithParams() throws Exception {
        FileHandler handler = new FileHandler();
        URL url = new URL("https://issues.apache.org/bugzilla/show_bug.cgi?id=37886");
        handler.setURL(url);
        Assertions.assertEquals((Object)"https://issues.apache.org/bugzilla/", (Object)handler.getBasePath());
        Assertions.assertEquals((Object)"show_bug.cgi", (Object)handler.getFileName());
        Assertions.assertEquals((Object)url, (Object)handler.getURL());
    }

    private static /* synthetic */ void lambda$testInitPropertiesMultiThreaded$7(FileHandler handler, FileLocationStrategy locationStrategy) {
        handler.setLocationStrategy(locationStrategy);
    }

    private static /* synthetic */ void lambda$testInitPropertiesMultiThreaded$4(FileHandler handler, FileSystem fileSystem) {
        handler.setFileSystem(fileSystem);
    }

    private static final class FileBasedFileLocatorAwareTestImpl
    extends FileBasedTestImpl
    implements FileLocatorAware {
        private FileLocator locator;

        private FileBasedFileLocatorAwareTestImpl() {
        }

        public FileLocator getLocator() {
            return this.locator;
        }

        public void initFileLocator(FileLocator loc) {
            this.locator = loc;
        }

        @Override
        public void read(Reader in) throws ConfigurationException, IOException {
            super.read(in);
            this.setContent(String.valueOf(this.locator.getSourceURL()) + ": " + this.getContent());
        }

        @Override
        public void write(Writer out) throws ConfigurationException, IOException {
            out.write(String.valueOf(this.locator.getSourceURL()) + ": ");
            super.write(out);
        }
    }

    private static class FileBasedTestImpl
    implements FileBased {
        private String content = "TestFileHandler: This is test content.";

        private FileBasedTestImpl() {
        }

        public String getContent() {
            return this.content;
        }

        public void read(Reader in) throws ConfigurationException, IOException {
            this.content = TestFileHandler.readReader(in);
        }

        public void setContent(String content) {
            this.content = content;
        }

        public void write(Writer out) throws ConfigurationException, IOException {
            out.write(this.getContent());
            out.flush();
        }
    }

    private static final class FileHandlerListenerTestImpl
    extends FileHandlerListenerAdapter {
        private final FileHandler expHandler;
        private final StringBuilder methods;

        public FileHandlerListenerTestImpl(FileHandler fh) {
            this.expHandler = fh;
            this.methods = new StringBuilder();
        }

        public void checkMethods(String expMethods) {
            Assertions.assertEquals((Object)expMethods, (Object)this.methods.toString());
        }

        public void loaded(FileHandler handler) {
            super.loaded(handler);
            this.methodCalled(handler, "loaded");
        }

        public void loading(FileHandler handler) {
            super.loading(handler);
            this.methodCalled(handler, "loading");
        }

        public void locationChanged(FileHandler handler) {
            super.locationChanged(handler);
            this.methodCalled(handler, "locationChanged");
        }

        private void methodCalled(FileHandler handler, String method) {
            Assertions.assertEquals((Object)this.expHandler, (Object)handler);
            this.methods.append(method);
        }

        public void saved(FileHandler handler) {
            super.saved(handler);
            this.methodCalled(handler, "saved");
        }

        public void saving(FileHandler handler) {
            super.saving(handler);
            this.methodCalled(handler, "saving");
        }
    }

    private static class FileBasedInputStreamSupportTestImpl
    extends FileBasedTestImpl
    implements InputStreamSupport {
        private FileBasedInputStreamSupportTestImpl() {
        }

        public void read(InputStream in) throws ConfigurationException, IOException {
            int c;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((c = in.read()) != -1) {
                bos.write(c);
            }
            this.setContent("InputStream = " + bos.toString());
        }
    }
}

