/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.configuration2.tree.NodeUpdateData;
import org.apache.commons.configuration2.tree.QueryResult;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestNodeUpdateData {
    private static QueryResult<Object> result(Object value) {
        return QueryResult.createNodeResult((Object)value);
    }

    @Test
    public void testGetChangedValuesModify() {
        HashMap<QueryResult<Object>, Integer> map = new HashMap<QueryResult<Object>, Integer>();
        map.put(TestNodeUpdateData.result("n1"), 42);
        NodeUpdateData data = new NodeUpdateData(map, null, null, null);
        Map changedValues = data.getChangedValues();
        QueryResult<Object> result = TestNodeUpdateData.result("n2");
        Assertions.assertThrows(UnsupportedOperationException.class, () -> changedValues.put(result, 43));
    }

    @Test
    public void testGetNewValuesModify() {
        LinkedList<Integer> col = new LinkedList<Integer>();
        col.add(42);
        NodeUpdateData data = new NodeUpdateData(null, col, null, null);
        Collection newValues = data.getNewValues();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> newValues.add(43));
    }

    @Test
    public void testGetRemovedNodesModify() {
        LinkedList<QueryResult<Object>> col = new LinkedList<QueryResult<Object>>();
        col.add(TestNodeUpdateData.result("n1"));
        NodeUpdateData data = new NodeUpdateData(null, null, col, null);
        Collection removedNodes = data.getRemovedNodes();
        QueryResult<Object> result = TestNodeUpdateData.result("newNode");
        Assertions.assertThrows(UnsupportedOperationException.class, () -> removedNodes.add(result));
    }

    @Test
    public void testInitChangedValuesDefensiveCopy() {
        HashMap<QueryResult<Object>, String> map = new HashMap<QueryResult<Object>, String>();
        map.put(TestNodeUpdateData.result("test"), "value");
        NodeUpdateData data = new NodeUpdateData(map, null, null, null);
        map.put(TestNodeUpdateData.result("anotherTest"), "anotherValue");
        Map changedValues = data.getChangedValues();
        Assertions.assertEquals(Collections.singletonMap(TestNodeUpdateData.result("test"), "value"), (Object)changedValues);
    }

    @Test
    public void testInitNewValuesDefensiveCopy() {
        LinkedList<Object> col = new LinkedList<Object>();
        col.add(42);
        NodeUpdateData data = new NodeUpdateData(null, col, null, null);
        col.add("anotherValue");
        Collection newValues = data.getNewValues();
        Assertions.assertEquals((int)1, (int)newValues.size());
        Assertions.assertEquals((Object)42, newValues.iterator().next());
    }

    @Test
    public void testInitNoData() {
        NodeUpdateData data = new NodeUpdateData(null, null, null, null);
        Assertions.assertTrue((boolean)data.getChangedValues().isEmpty());
        Assertions.assertTrue((boolean)data.getNewValues().isEmpty());
        Assertions.assertTrue((boolean)data.getRemovedNodes().isEmpty());
    }

    @Test
    public void testInitRemovedNodesDefensiveCopy() {
        LinkedList<QueryResult<Object>> col = new LinkedList<QueryResult<Object>>();
        col.add(TestNodeUpdateData.result("n1"));
        NodeUpdateData data = new NodeUpdateData(null, null, col, null);
        col.add(TestNodeUpdateData.result("n2"));
        Collection removedNodes = data.getRemovedNodes();
        Assertions.assertEquals((int)1, (int)removedNodes.size());
        Assertions.assertEquals(TestNodeUpdateData.result("n1"), removedNodes.iterator().next());
    }
}

