/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.numbers.core.DD;

final class ExtendedPrecision {
    static final DD SQRT2PI = DD.ofSum((double)2.5066282746310007, (double)-1.8328579980459167E-16);
    private static final double BIG = 3.273390607896142E150;
    private static final double SMALL = 3.054936363499605E-151;
    private static final double SCALE_UP = 4.149515568880993E180;
    private static final double SCALE_DOWN = 2.409919865102884E-181;
    private static final int EXP_M_HALF_XX_MIN_VALUE = 2;
    private static final int EXP_M_HALF_XX_MAX_VALUE = 1491;

    private ExtendedPrecision() {
    }

    static double xsqrt2pi(double x) {
        if (x > 3.273390607896142E150) {
            if (x == Double.POSITIVE_INFINITY) {
                return Double.POSITIVE_INFINITY;
            }
            return ExtendedPrecision.computeXsqrt2pi(x * 2.409919865102884E-181) * 4.149515568880993E180;
        }
        if (x < 3.054936363499605E-151) {
            return ExtendedPrecision.computeXsqrt2pi(x * 4.149515568880993E180) * 2.409919865102884E-181;
        }
        return ExtendedPrecision.computeXsqrt2pi(x);
    }

    private static double computeXsqrt2pi(double a) {
        return SQRT2PI.multiply(a).hi();
    }

    static double sqrt2xx(double x) {
        if (x > 3.273390607896142E150) {
            if (x == Double.POSITIVE_INFINITY) {
                return Double.POSITIVE_INFINITY;
            }
            return ExtendedPrecision.computeSqrt2aa(x * 2.409919865102884E-181) * 4.149515568880993E180;
        }
        if (x < 3.054936363499605E-151) {
            return ExtendedPrecision.computeSqrt2aa(x * 4.149515568880993E180) * 2.409919865102884E-181;
        }
        return ExtendedPrecision.computeSqrt2aa(x);
    }

    private static double computeSqrt2aa(double a) {
        return DD.ofProduct((double)(2.0 * a), (double)a).sqrt().hi();
    }

    static double expmhxx(double x) {
        double z = x * x;
        if (z <= 2.0) {
            return Math.exp(-0.5 * z);
        }
        if (z >= 1491.0) {
            return 0.0;
        }
        DD x2 = DD.ofSquare((double)x);
        return ExtendedPrecision.expxx(-0.5 * x2.hi(), -0.5 * x2.lo());
    }

    private static double expxx(double a, double b) {
        double ea = Math.exp(a);
        return ea * b + ea;
    }
}

