/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.logging;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import org.apache.activemq.artemis.jdbc.store.logging.LoggingUtil;
import org.slf4j.Logger;

public class LoggingResultSet
implements ResultSet {
    private final ResultSet resultSet;
    private final String resultSetID;
    private final Logger logger;

    public LoggingResultSet(ResultSet resultSet, Logger logger) {
        this.resultSet = resultSet;
        this.logger = logger;
        this.resultSetID = LoggingUtil.getID(resultSet);
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public String getResultSetID() {
        return this.resultSetID;
    }

    @Override
    public boolean next() throws SQLException {
        boolean b = this.resultSet.next();
        this.logger.trace("{}.next() = {}", (Object)this.resultSetID, (Object)b);
        return b;
    }

    @Override
    public void close() throws SQLException {
        this.logger.trace("{}.close()", (Object)this.resultSetID);
        this.resultSet.close();
    }

    @Override
    public boolean wasNull() throws SQLException {
        boolean b = this.resultSet.wasNull();
        this.logger.trace("{}.wasNull() = {}", (Object)this.resultSetID, (Object)b);
        return b;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        String x = this.resultSet.getString(columnIndex);
        this.logger.trace("{}.getString({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        boolean x = this.resultSet.getBoolean(columnIndex);
        this.logger.trace("{}.getBoolean({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        byte x = this.resultSet.getByte(columnIndex);
        this.logger.trace("{}.getByte({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        short x = this.resultSet.getShort(columnIndex);
        this.logger.trace("{}.getShort({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        int x = this.resultSet.getInt(columnIndex);
        this.logger.trace("{}.getInt({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        long x = this.resultSet.getLong(columnIndex);
        this.logger.trace("{}.getLong({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        float x = this.resultSet.getFloat(columnIndex);
        this.logger.trace("{}.getFloat({}) = {}", new Object[]{this.resultSetID, columnIndex, Float.valueOf(x)});
        return x;
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        double x = this.resultSet.getDouble(columnIndex);
        this.logger.trace("{}.getDouble({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal x = this.resultSet.getBigDecimal(columnIndex);
        this.logger.trace("{}.getBigDecimal({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        byte[] x = this.resultSet.getBytes(columnIndex);
        this.logger.trace("{}.getBytes({}) = {}", new Object[]{this.resultSetID, columnIndex, Arrays.toString(x)});
        return x;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        Date x = this.resultSet.getDate(columnIndex);
        this.logger.trace("{}.getDate({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Time x = this.resultSet.getTime(columnIndex);
        this.logger.trace("{}.getTime({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Timestamp x = this.resultSet.getTimestamp(columnIndex);
        this.logger.trace("{}.getTimestamp({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        InputStream x = this.resultSet.getAsciiStream(columnIndex);
        this.logger.trace("{}.getAsciiStream({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        InputStream x = this.resultSet.getUnicodeStream(columnIndex);
        this.logger.trace("{}.getUnicodeStream({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        InputStream x = this.resultSet.getBinaryStream(columnIndex);
        this.logger.trace("{}.getBinaryStream({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        String x = this.resultSet.getString(columnLabel);
        this.logger.trace("{}.getString({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        boolean x = this.resultSet.getBoolean(columnLabel);
        this.logger.trace("{}.getBoolean({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        byte x = this.resultSet.getByte(columnLabel);
        this.logger.trace("{}.getByte({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        short x = this.resultSet.getShort(columnLabel);
        this.logger.trace("{}.getShort({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        int x = this.resultSet.getInt(columnLabel);
        this.logger.trace("{}.getInt({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        long x = this.resultSet.getLong(columnLabel);
        this.logger.trace("{}.getLong({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        float x = this.resultSet.getFloat(columnLabel);
        this.logger.trace("{}.getFloat({}) = {}", new Object[]{this.resultSetID, columnLabel, Float.valueOf(x)});
        return x;
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        double x = this.resultSet.getDouble(columnLabel);
        this.logger.trace("{}.getDouble({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        BigDecimal x = this.resultSet.getBigDecimal(columnLabel);
        this.logger.trace("{}.getBigDecimal({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        byte[] x = this.resultSet.getBytes(columnLabel);
        this.logger.trace("{}.getBytes({}) = {}", new Object[]{this.resultSetID, columnLabel, Arrays.toString(x)});
        return x;
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        Date x = this.resultSet.getDate(columnLabel);
        this.logger.trace("{}.getDate({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        Time x = this.resultSet.getTime(columnLabel);
        this.logger.trace("{}.getTime({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        Timestamp x = this.resultSet.getTimestamp(columnLabel);
        this.logger.trace("{}.getTimestamp({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        InputStream x = this.resultSet.getAsciiStream(columnLabel);
        this.logger.trace("{}.getAsciiStream({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        InputStream x = this.resultSet.getUnicodeStream(columnLabel);
        this.logger.trace("{}.getUnicodeStream({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        InputStream x = this.resultSet.getBinaryStream(columnLabel);
        this.logger.trace("{}.getBinaryStream({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        SQLWarning x = this.resultSet.getWarnings();
        this.logger.trace("{}.getWarnings) = {}", (Object)this.resultSetID, (Object)x);
        return x;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.logger.trace("{}.clearWarnings()", (Object)this.resultSetID);
        this.resultSet.clearWarnings();
    }

    @Override
    public String getCursorName() throws SQLException {
        String x = this.resultSet.getCursorName();
        this.logger.trace("{}.getCursorName() = {}", (Object)this.resultSetID, (Object)x);
        return x;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSetMetaData x = this.resultSet.getMetaData();
        this.logger.trace("{}.getMetaData() = {}", (Object)this.resultSetID, (Object)x);
        return x;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        String x = this.resultSet.getString(columnIndex);
        this.logger.trace("{}.getString({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        Object x = this.resultSet.getObject(columnLabel);
        this.logger.trace("{}.getObject({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        int x = this.resultSet.findColumn(columnLabel);
        this.logger.trace("{}.findColumn({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        Reader x = this.resultSet.getCharacterStream(columnIndex);
        this.logger.trace("{}.getCharacterStream({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        Reader x = this.resultSet.getCharacterStream(columnLabel);
        this.logger.trace("{}.getCharacterStream({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        BigDecimal x = this.resultSet.getBigDecimal(columnIndex);
        this.logger.trace("{}.getBigDecimal({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        BigDecimal x = this.resultSet.getBigDecimal(columnLabel);
        this.logger.trace("{}.getBigDecimal({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        boolean x = this.resultSet.isBeforeFirst();
        this.logger.trace("{}.isBeforeFirst() = {}", (Object)this.resultSetID, (Object)x);
        return x;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        boolean x = this.resultSet.isAfterLast();
        this.logger.trace("{}.isAfterLast() = {}", (Object)this.resultSetID, (Object)x);
        return x;
    }

    @Override
    public boolean isFirst() throws SQLException {
        boolean x = this.resultSet.isFirst();
        this.logger.trace("{}.isFirst() = {}", (Object)this.resultSetID, (Object)x);
        return x;
    }

    @Override
    public boolean isLast() throws SQLException {
        boolean x = this.resultSet.isLast();
        this.logger.trace("{}.isLast() = {}", (Object)this.resultSetID, (Object)x);
        return x;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.logger.trace("{}.beforeFirst()", (Object)this.resultSetID);
        this.resultSet.beforeFirst();
    }

    @Override
    public void afterLast() throws SQLException {
        this.logger.trace("{}.afterLast()", (Object)this.resultSetID);
        this.resultSet.afterLast();
    }

    @Override
    public boolean first() throws SQLException {
        boolean x = this.resultSet.first();
        this.logger.trace("{}.first() = {}", (Object)this.resultSetID, (Object)x);
        return x;
    }

    @Override
    public boolean last() throws SQLException {
        boolean x = this.resultSet.last();
        this.logger.trace("{}.last() = {}", (Object)this.resultSetID, (Object)x);
        return x;
    }

    @Override
    public int getRow() throws SQLException {
        int x = this.resultSet.getRow();
        this.logger.trace("{}.getRow() = {}", (Object)this.resultSetID, (Object)x);
        return x;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        boolean x = this.resultSet.absolute(row);
        this.logger.trace("{}.absolute({}) = {}", new Object[]{this.resultSetID, row, x});
        return x;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        boolean x = this.resultSet.relative(rows);
        this.logger.trace("{}.relative({}) = {}", new Object[]{this.resultSetID, rows, x});
        return x;
    }

    @Override
    public boolean previous() throws SQLException {
        boolean x = this.resultSet.previous();
        this.logger.trace("{}.previous() = {}", (Object)this.resultSetID, (Object)x);
        return x;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.logger.trace("{}.setFetchDirection({})", (Object)this.resultSetID, (Object)direction);
        this.resultSet.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        int x = this.resultSet.getFetchDirection();
        this.logger.trace("{}.getFetchDirection() = {}", (Object)this.resultSetID, (Object)x);
        return x;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.logger.trace("{}.setFetchSize({})", (Object)this.resultSetID, (Object)rows);
        this.resultSet.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        int x = this.resultSet.getFetchSize();
        this.logger.trace("{}.getFetchSize() = {}", (Object)this.resultSetID, (Object)x);
        return x;
    }

    @Override
    public int getType() throws SQLException {
        int x = this.resultSet.getType();
        this.logger.trace("{}.getType() = {}", (Object)this.resultSetID, (Object)x);
        return x;
    }

    @Override
    public int getConcurrency() throws SQLException {
        int x = this.resultSet.getConcurrency();
        this.logger.trace("{}.getConcurrency() = {}", (Object)this.resultSetID, (Object)x);
        return x;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        boolean x = this.resultSet.rowUpdated();
        this.logger.trace("{}.rowUpdated() = {}", (Object)this.resultSetID, (Object)x);
        return x;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        boolean x = this.resultSet.rowInserted();
        this.logger.trace("{}.rowInserted() = {}", (Object)this.resultSetID, (Object)x);
        return x;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        boolean x = this.resultSet.rowDeleted();
        this.logger.trace("{}.rowDeleted() = {}", (Object)this.resultSetID, (Object)x);
        return x;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.logger.trace("{}.updateNull({})", (Object)this.resultSetID, (Object)columnIndex);
        this.resultSet.updateNull(columnIndex);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.logger.trace("{}.updateBoolean({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateBoolean(columnIndex, x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.logger.trace("{}.updateByte({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateByte(columnIndex, x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.logger.trace("{}.updateShort({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateShort(columnIndex, x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.logger.trace("{}.updateInt({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateInt(columnIndex, x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.logger.trace("{}.updateLong({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateLong(columnIndex, x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.logger.trace("{}.updateFloat({}, {})", new Object[]{this.resultSetID, columnIndex, Float.valueOf(x)});
        this.resultSet.updateFloat(columnIndex, x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.logger.trace("{}.updateDouble({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateDouble(columnIndex, x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.logger.trace("{}.updateBigDecimal({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateBigDecimal(columnIndex, x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.logger.trace("{}.updateString({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateString(columnIndex, x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.logger.trace("{}.updateBytes({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateBytes(columnIndex, x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.logger.trace("{}.updateDate({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateDate(columnIndex, x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.logger.trace("{}.updateTime({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateTime(columnIndex, x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.logger.trace("{}.updateTimestamp({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateTimestamp(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.logger.trace("{}.updateAsciiStream({}, {}, {})", new Object[]{this.resultSetID, columnIndex, x, length});
        this.resultSet.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.logger.trace("{}.updateBinaryStream({}, {}, {})", new Object[]{this.resultSetID, columnIndex, x, length});
        this.resultSet.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.logger.trace("{}.updateCharacterStream({}, {}, {})", new Object[]{this.resultSetID, columnIndex, x, length});
        this.resultSet.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.logger.trace("{}.updateObject({}, {}, {})", new Object[]{this.resultSetID, columnIndex, x, scaleOrLength});
        this.resultSet.updateObject(columnIndex, x, scaleOrLength);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.logger.trace("{}.updateObject({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateObject(columnIndex, x);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.logger.trace("{}.updateNull({})", (Object)this.resultSetID, (Object)columnLabel);
        this.resultSet.updateNull(columnLabel);
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.logger.trace("{}.updateBoolean({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateBoolean(columnLabel, x);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.logger.trace("{}.updateByte({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateByte(columnLabel, x);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.logger.trace("{}.updateShort({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateShort(columnLabel, x);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.logger.trace("{}.updateInt({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateInt(columnLabel, x);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.logger.trace("{}.updateLong({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateLong(columnLabel, x);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.logger.trace("{}.updateFloat({}, {})", new Object[]{this.resultSetID, columnLabel, Float.valueOf(x)});
        this.resultSet.updateFloat(columnLabel, x);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.logger.trace("{}.updateDouble({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateDouble(columnLabel, x);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.logger.trace("{}.updateBigDecimal({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateBigDecimal(columnLabel, x);
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.logger.trace("{}.updateString({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateString(columnLabel, x);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.logger.trace("{}.updateBytes({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateBytes(columnLabel, x);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.logger.trace("{}.updateDate({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateDate(columnLabel, x);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.logger.trace("{}.updateTime({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateTime(columnLabel, x);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.logger.trace("{}.updateTimestamp({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateTimestamp(columnLabel, x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.logger.trace("{}.updateAsciiStream({}, {}, {})", new Object[]{this.resultSetID, columnLabel, x, length});
        this.resultSet.updateAsciiStream(columnLabel, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.logger.trace("{}.updateBinaryStream({}, {}, {})", new Object[]{this.resultSetID, columnLabel, x, length});
        this.resultSet.updateBinaryStream(columnLabel, x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, int length) throws SQLException {
        this.logger.trace("{}.updateCharacterStream({}, {}, {})", new Object[]{this.resultSetID, columnLabel, x, length});
        this.resultSet.updateCharacterStream(columnLabel, x, length);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.logger.trace("{}.updateObject({}, {}, {})", new Object[]{this.resultSetID, columnLabel, x, scaleOrLength});
        this.resultSet.updateObject(columnLabel, x, scaleOrLength);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.logger.trace("{}.updateObject({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateObject(columnLabel, x);
    }

    @Override
    public void insertRow() throws SQLException {
        this.logger.trace("{}.insertRow()", (Object)this.resultSetID);
        this.resultSet.insertRow();
    }

    @Override
    public void updateRow() throws SQLException {
        this.logger.trace("{}.updateRow()", (Object)this.resultSetID);
        this.resultSet.updateRow();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.logger.trace("{}.deleteRow()", (Object)this.resultSetID);
        this.resultSet.deleteRow();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.logger.trace("{}.refreshRow()", (Object)this.resultSetID);
        this.resultSet.refreshRow();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.logger.trace("{}.cancelRowUpdates()", (Object)this.resultSetID);
        this.resultSet.cancelRowUpdates();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.logger.trace("{}.moveToInsertRow()", (Object)this.resultSetID);
        this.resultSet.moveToInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.logger.trace("{}.moveToCurrentRow()", (Object)this.resultSetID);
        this.resultSet.moveToCurrentRow();
    }

    @Override
    public Statement getStatement() throws SQLException {
        Statement x = this.resultSet.getStatement();
        this.logger.trace("{}.getStatement() = {}", (Object)this.resultSetID, (Object)x);
        return x;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        Object x = this.resultSet.getObject(columnIndex, map);
        this.logger.trace("{}.getObject({}, {}) = {}", new Object[]{this.resultSetID, columnIndex, map, x});
        return x;
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        Ref x = this.resultSet.getRef(columnIndex);
        this.logger.trace("{}.getRef({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        Blob x = this.resultSet.getBlob(columnIndex);
        this.logger.trace("{}.getBlob({}) = {} (length: {})", new Object[]{this.resultSetID, columnIndex, x, x == null ? null : Long.valueOf(x.length())});
        return x;
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        Clob x = this.resultSet.getClob(columnIndex);
        this.logger.trace("{}.getClob({}) = {} (length: {})", new Object[]{this.resultSetID, columnIndex, x, x == null ? null : Long.valueOf(x.length())});
        return x;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        Array x = this.resultSet.getArray(columnIndex);
        this.logger.trace("{}.getArray({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        Object x = this.resultSet.getObject(columnLabel, map);
        this.logger.trace("{}.getObject({}, {}) = {}", new Object[]{this.resultSetID, columnLabel, map, x});
        return x;
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        Ref x = this.resultSet.getRef(columnLabel);
        this.logger.trace("{}.getRef({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        Blob x = this.resultSet.getBlob(columnLabel);
        this.logger.trace("{}.getBlob({}) = {} (length: {})", new Object[]{this.resultSetID, columnLabel, x, x == null ? null : Long.valueOf(x.length())});
        return x;
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        Clob x = this.resultSet.getClob(columnLabel);
        this.logger.trace("{}.getClob({}) = {} (length: {})", new Object[]{this.resultSetID, columnLabel, x, x == null ? null : Long.valueOf(x.length())});
        return x;
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        Array x = this.resultSet.getArray(columnLabel);
        this.logger.trace("{}.getArray({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public Date getDate(int columnLabel, Calendar cal) throws SQLException {
        Date x = this.resultSet.getDate(columnLabel, cal);
        this.logger.trace("{}.getDate({}) = {}", new Object[]{this.resultSetID, columnLabel, cal, x});
        return x;
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        Date x = this.resultSet.getDate(columnLabel, cal);
        this.logger.trace("{}.getDate({}) = {}", new Object[]{this.resultSetID, columnLabel, cal, x});
        return x;
    }

    @Override
    public Time getTime(int columnLabel, Calendar cal) throws SQLException {
        Time x = this.resultSet.getTime(columnLabel, cal);
        this.logger.trace("{}.getTime({}) = {}", new Object[]{this.resultSetID, columnLabel, cal, x});
        return x;
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        Time x = this.resultSet.getTime(columnLabel, cal);
        this.logger.trace("{}.getTime({}) = {}", new Object[]{this.resultSetID, columnLabel, cal, x});
        return x;
    }

    @Override
    public Timestamp getTimestamp(int columnLabel, Calendar cal) throws SQLException {
        Timestamp x = this.resultSet.getTimestamp(columnLabel, cal);
        this.logger.trace("{}.getTimestamp({}) = {}", new Object[]{this.resultSetID, columnLabel, cal, x});
        return x;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        Timestamp x = this.resultSet.getTimestamp(columnLabel, cal);
        this.logger.trace("{}.getTimestamp({}) = {}", new Object[]{this.resultSetID, columnLabel, cal, x});
        return x;
    }

    @Override
    public URL getURL(int columnLabel) throws SQLException {
        URL x = this.resultSet.getURL(columnLabel);
        this.logger.trace("{}.getURL({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        URL x = this.resultSet.getURL(columnLabel);
        this.logger.trace("{}.getURL({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.logger.trace("{}.updateRef({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateRef(columnIndex, x);
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.logger.trace("{}.updateRef({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateRef(columnLabel, x);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.logger.trace("{}.updateBlob({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateBlob(columnIndex, x);
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.logger.trace("{}.updateBlob({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateBlob(columnLabel, x);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.logger.trace("{}.updateClob({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateClob(columnIndex, x);
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.logger.trace("{}.updateClob({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateClob(columnLabel, x);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.logger.trace("{}.updateArray({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateArray(columnIndex, x);
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this.logger.trace("{}.updateArray({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateArray(columnLabel, x);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        RowId x = this.resultSet.getRowId(columnIndex);
        this.logger.trace("{}.getRowId({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        RowId x = this.resultSet.getRowId(columnLabel);
        this.logger.trace("{}.getRowId({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.logger.trace("{}.updateRowId({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateRowId(columnIndex, x);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.logger.trace("{}.updateRowId({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateRowId(columnLabel, x);
    }

    @Override
    public int getHoldability() throws SQLException {
        int x = this.resultSet.getHoldability();
        this.logger.trace("{}.getHoldability() = {}", (Object)this.resultSetID, (Object)x);
        return x;
    }

    @Override
    public boolean isClosed() throws SQLException {
        boolean x = this.resultSet.isClosed();
        this.logger.trace("{}.isClosed() = {}", (Object)this.resultSetID, (Object)x);
        return x;
    }

    @Override
    public void updateNString(int columnIndex, String x) throws SQLException {
        this.logger.trace("{}.updateNString({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateNString(columnIndex, x);
    }

    @Override
    public void updateNString(String columnLabel, String x) throws SQLException {
        this.logger.trace("{}.updateNString({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateNString(columnLabel, x);
    }

    @Override
    public void updateNClob(int columnIndex, NClob x) throws SQLException {
        this.logger.trace("{}.updateNClob({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateNClob(columnIndex, x);
    }

    @Override
    public void updateNClob(String columnLabel, NClob x) throws SQLException {
        this.logger.trace("{}.updateNClob({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateNClob(columnLabel, x);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        NClob x = this.resultSet.getNClob(columnIndex);
        this.logger.trace("{}.getNClob({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        NClob x = this.resultSet.getNClob(columnLabel);
        this.logger.trace("{}.getNClob({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        SQLXML x = this.resultSet.getSQLXML(columnIndex);
        this.logger.trace("{}.getSQLXML({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        SQLXML x = this.resultSet.getSQLXML(columnLabel);
        this.logger.trace("{}.getSQLXML({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML x) throws SQLException {
        this.logger.trace("{}.updateSQLXML({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateSQLXML(columnIndex, x);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML x) throws SQLException {
        this.logger.trace("{}.updateSQLXML({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateSQLXML(columnLabel, x);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        String x = this.resultSet.getNString(columnIndex);
        this.logger.trace("{}.getNString({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        String x = this.resultSet.getNString(columnLabel);
        this.logger.trace("{}.getNString({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        Reader x = this.resultSet.getNCharacterStream(columnIndex);
        this.logger.trace("{}.getNCharacterStream({}) = {}", new Object[]{this.resultSetID, columnIndex, x});
        return x;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        Reader x = this.resultSet.getNCharacterStream(columnLabel);
        this.logger.trace("{}.getNCharacterStream({}) = {}", new Object[]{this.resultSetID, columnLabel, x});
        return x;
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.logger.trace("{}.updateNCharacterStream({}, {}, {})", new Object[]{this.resultSetID, columnIndex, x, length});
        this.resultSet.updateNCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.logger.trace("{}.updateNCharacterStream({}, {}, {})", new Object[]{this.resultSetID, columnLabel, reader, length});
        this.resultSet.updateNCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.logger.trace("{}.updateAsciiStream({}, {}, {})", new Object[]{this.resultSetID, columnIndex, x, length});
        this.resultSet.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.logger.trace("{}.updateBinaryStream({}, {}, {})", new Object[]{this.resultSetID, columnIndex, x, length});
        this.resultSet.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.logger.trace("{}.updateCharacterStream({}, {}, {})", new Object[]{this.resultSetID, columnIndex, x, length});
        this.resultSet.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.logger.trace("{}.updateAsciiStream({}, {}, {})", new Object[]{this.resultSetID, columnLabel, x, length});
        this.resultSet.updateAsciiStream(columnLabel, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.logger.trace("{}.updateBinaryStream({}, {}, {})", new Object[]{this.resultSetID, columnLabel, x, length});
        this.resultSet.updateBinaryStream(columnLabel, x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.logger.trace("{}.updateCharacterStream({}, {}, {})", new Object[]{this.resultSetID, columnLabel, reader, length});
        this.resultSet.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.logger.trace("{}.updateBlob({}, {}, {})", new Object[]{this.resultSetID, columnIndex, inputStream, length});
        this.resultSet.updateBlob(columnIndex, inputStream, length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.logger.trace("{}.updateBlob({}, {}, {})", new Object[]{this.resultSetID, columnLabel, inputStream, length});
        this.resultSet.updateBlob(columnLabel, inputStream, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.logger.trace("{}.updateClob({}, {}, {})", new Object[]{this.resultSetID, columnIndex, reader, length});
        this.resultSet.updateClob(columnIndex, reader, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.logger.trace("{}.updateClob({}, {}, {})", new Object[]{this.resultSetID, columnLabel, reader, length});
        this.resultSet.updateClob(columnLabel, reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.logger.trace("{}.updateNClob({}, {}, {})", new Object[]{this.resultSetID, columnIndex, reader, length});
        this.resultSet.updateNClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.logger.trace("{}.updateNClob({}, {}, {})", new Object[]{this.resultSetID, columnLabel, reader, length});
        this.resultSet.updateNClob(columnLabel, reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.logger.trace("{}.updateNCharacterStream({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateNCharacterStream(columnIndex, x);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.logger.trace("{}.updateNCharacterStream({}, {})", new Object[]{this.resultSetID, columnLabel, reader});
        this.resultSet.updateNCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.logger.trace("{}.updateAsciiStream({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateAsciiStream(columnIndex, x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.logger.trace("{}.updateBinaryStream({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateBinaryStream(columnIndex, x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.logger.trace("{}.updateCharacterStream({}, {})", new Object[]{this.resultSetID, columnIndex, x});
        this.resultSet.updateCharacterStream(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.logger.trace("{}.updateAsciiStream({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateAsciiStream(columnLabel, x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.logger.trace("{}.updateBinaryStream({}, {})", new Object[]{this.resultSetID, columnLabel, x});
        this.resultSet.updateBinaryStream(columnLabel, x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.logger.trace("{}.updateCharacterStream({}, {})", new Object[]{this.resultSetID, columnLabel, reader});
        this.resultSet.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.logger.trace("{}.updateBlob({}, {})", new Object[]{this.resultSetID, columnIndex, inputStream});
        this.resultSet.updateBlob(columnIndex, inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.logger.trace("{}.updateBlob({}, {})", new Object[]{this.resultSetID, columnLabel, inputStream});
        this.resultSet.updateBlob(columnLabel, inputStream);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.logger.trace("{}.updateClob({}, {})", new Object[]{this.resultSetID, columnIndex, reader});
        this.resultSet.updateClob(columnIndex, reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.logger.trace("{}.updateClob({}, {})", new Object[]{this.resultSetID, columnLabel, reader});
        this.resultSet.updateClob(columnLabel, reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.logger.trace("{}.updateNClob({}, {})", new Object[]{this.resultSetID, columnIndex, reader});
        this.resultSet.updateNClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.logger.trace("{}.updateNClob({}, {})", new Object[]{this.resultSetID, columnLabel, reader});
        this.resultSet.updateNClob(columnLabel, reader);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        T x = this.resultSet.getObject(columnIndex, type);
        this.logger.trace("{}.getObject({}, {}) = {}", new Object[]{this.resultSetID, columnIndex, type, x});
        return x;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        T x = this.resultSet.getObject(columnLabel, type);
        this.logger.trace("{}.getObject({}, {}) = {}", new Object[]{this.resultSetID, columnLabel, type, x});
        return x;
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.logger.trace("{}.updateObject({}, {}, {}, {})", new Object[]{this.resultSetID, columnIndex, x, targetSqlType, scaleOrLength});
        this.resultSet.updateObject(columnIndex, x, targetSqlType);
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.logger.trace("{}.updateObject({}, {}, {}, {})", new Object[]{this.resultSetID, columnLabel, x, targetSqlType, scaleOrLength});
        this.resultSet.updateObject(columnLabel, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.logger.trace("{}.updateObject({}, {}, {})", new Object[]{this.resultSetID, columnIndex, x, targetSqlType});
        this.resultSet.updateObject(columnIndex, x, targetSqlType);
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        this.logger.trace("{}.updateObject({}, {}, {})", new Object[]{this.resultSetID, columnLabel, x, targetSqlType});
        this.resultSet.updateObject(columnLabel, x, targetSqlType);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        T x = this.resultSet.unwrap(iface);
        this.logger.trace("{}.unwrap({}) = {}", new Object[]{this.resultSetID, iface, x});
        return x;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        boolean x = this.resultSet.isWrapperFor(iface);
        this.logger.trace("{}.isWrapperFor({}) = {}", new Object[]{this.resultSetID, iface, x});
        return x;
    }
}

