/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.ha;

import java.util.Map;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreBackupPolicy;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.PrimaryActivation;
import org.apache.activemq.artemis.core.server.impl.SharedStorePrimaryActivation;

public class SharedStorePrimaryPolicy
implements HAPolicy<PrimaryActivation> {
    private boolean failoverOnServerShutdown = ActiveMQDefaultConfiguration.isDefaultFailoverOnServerShutdown();
    private boolean waitForActivation = ActiveMQDefaultConfiguration.isDefaultWaitForActivation();
    private SharedStoreBackupPolicy sharedStoreBackupPolicy;

    public SharedStorePrimaryPolicy() {
    }

    public SharedStorePrimaryPolicy(boolean failoverOnServerShutdown, boolean waitForActivation) {
        this.failoverOnServerShutdown = failoverOnServerShutdown;
        this.waitForActivation = waitForActivation;
    }

    @Deprecated
    public long getFailbackDelay() {
        return -1L;
    }

    @Deprecated
    public void setFailbackDelay(long failbackDelay) {
    }

    public boolean isFailoverOnServerShutdown() {
        return this.failoverOnServerShutdown;
    }

    public void setFailoverOnServerShutdown(boolean failoverOnServerShutdown) {
        this.failoverOnServerShutdown = failoverOnServerShutdown;
    }

    @Override
    public boolean isWaitForActivation() {
        return this.waitForActivation;
    }

    public void setWaitForActivation(boolean waitForActivation) {
        this.waitForActivation = waitForActivation;
    }

    public SharedStoreBackupPolicy getSharedStoreBackupPolicy() {
        return this.sharedStoreBackupPolicy;
    }

    public void setSharedStoreBackupPolicy(SharedStoreBackupPolicy sharedStoreBackupPolicy) {
        this.sharedStoreBackupPolicy = sharedStoreBackupPolicy;
    }

    @Override
    public boolean isSharedStore() {
        return true;
    }

    @Override
    public boolean isBackup() {
        return false;
    }

    @Override
    public boolean canScaleDown() {
        return false;
    }

    @Override
    public PrimaryActivation createActivation(ActiveMQServerImpl server, boolean wasPrimary, Map<String, Object> activationParams, IOCriticalErrorListener ioCriticalErrorListener) {
        return new SharedStorePrimaryActivation(server, this, ioCriticalErrorListener);
    }

    @Override
    public String getBackupGroupName() {
        return null;
    }

    @Override
    public String getScaleDownGroupName() {
        return null;
    }

    @Override
    public String getScaleDownClustername() {
        return null;
    }
}

