/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionBinder;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;

public class ImportedFunctionLibrary
implements FunctionLibrary,
XQueryFunctionBinder {
    private transient QueryModule importingModule;
    private final XQueryFunctionLibrary baseLibrary;
    private final HashSet<NamespaceUri> namespaces = new HashSet(5);

    public ImportedFunctionLibrary(QueryModule importingModule, XQueryFunctionLibrary baseLibrary) {
        this.importingModule = importingModule;
        this.baseLibrary = baseLibrary;
    }

    public void addImportedNamespace(NamespaceUri namespace) {
        this.namespaces.add(namespace);
    }

    @Override
    public Expression bind(SymbolicName.F symbolicName, Expression[] staticArgs, Map<StructuredQName, Integer> keywords, StaticContext env, List<String> reasons) throws XPathException {
        StructuredQName functionName = symbolicName.getComponentName();
        NamespaceUri uri = functionName.getNamespaceUri();
        RetainedStaticContext rsc = new RetainedStaticContext(env);
        for (Expression arg : staticArgs) {
            if (arg.getLocalRetainedStaticContext() != null) continue;
            arg.setRetainedStaticContext(rsc);
        }
        if (this.namespaces.contains(uri)) {
            return this.baseLibrary.bind(symbolicName, staticArgs, keywords, env, reasons);
        }
        return null;
    }

    @Override
    public XQueryFunction getDeclaration(StructuredQName functionName, int staticArgs) {
        NamespaceUri uri = functionName.getNamespaceUri();
        if (this.namespaces.contains(uri)) {
            return this.baseLibrary.getDeclaration(functionName, staticArgs);
        }
        return null;
    }

    @Override
    public boolean bindUnboundFunctionCall(UserFunctionCall call, List<String> reasons) {
        return this.baseLibrary.bindUnboundFunctionCall(call, reasons);
    }

    @Override
    public FunctionLibrary copy() {
        ImportedFunctionLibrary lib = new ImportedFunctionLibrary(this.importingModule, this.baseLibrary);
        for (NamespaceUri ns : this.namespaces) {
            lib.addImportedNamespace(ns);
        }
        return lib;
    }

    public void setImportingModule(QueryModule importingModule) {
        this.importingModule = importingModule;
    }

    @Override
    public FunctionItem getFunctionItem(SymbolicName.F functionName, StaticContext staticContext) throws XPathException {
        if (this.namespaces.contains(functionName.getComponentName().getNamespaceUri())) {
            return this.baseLibrary.getFunctionItem(functionName, staticContext);
        }
        return null;
    }

    @Override
    public boolean isAvailable(SymbolicName.F functionName, int languageLevel) {
        return this.namespaces.contains(functionName.getComponentName().getNamespaceUri()) && this.baseLibrary.isAvailable(functionName, languageLevel);
    }
}

