/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.LongBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import org.apache.daffodil.api.Diagnostic;
import org.apache.daffodil.api.InputSourceDataInputStream;
import org.apache.daffodil.api.debugger.Debugger;
import org.apache.daffodil.api.infoset.InfosetOutputter;
import org.apache.daffodil.api.layers.exceptions.LayerFatalException;
import org.apache.daffodil.api.metadata.MetadataHandler;
import org.apache.daffodil.api.validation.Validator;
import org.apache.daffodil.api.validation.ValidatorInitializationException;
import org.apache.daffodil.api.validation.Validators;
import org.apache.daffodil.io.BitOrderChangeException;
import org.apache.daffodil.io.FileIOException;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.exceptions.UnsuppressableException;
import org.apache.daffodil.lib.externalvars.Binding;
import org.apache.daffodil.lib.iapi.DaffodilTunables;
import org.apache.daffodil.lib.iapi.WithDiagnostics;
import org.apache.daffodil.lib.oolag.ErrorAlreadyHandled;
import org.apache.daffodil.lib.util.Maybe;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.Maybe$One$;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.lib.util.ThreadSafePool;
import org.apache.daffodil.runtime1.dsom.SchemaDefinitionError;
import org.apache.daffodil.runtime1.dsom.SchemaDefinitionErrorFromWarning;
import org.apache.daffodil.runtime1.dsom.TunableLimitExceededError;
import org.apache.daffodil.runtime1.events.MultipleEventHandler;
import org.apache.daffodil.runtime1.externalvars.ExternalVariablesLoader$;
import org.apache.daffodil.runtime1.iapi.DFDL;
import org.apache.daffodil.runtime1.infoset.InfosetAccessor;
import org.apache.daffodil.runtime1.infoset.InfosetException;
import org.apache.daffodil.runtime1.infoset.InfosetInputter;
import org.apache.daffodil.runtime1.infoset.TeeInfosetOutputter;
import org.apache.daffodil.runtime1.infoset.XMLTextInfosetOutputter;
import org.apache.daffodil.runtime1.infoset.XMLTextInfosetOutputter$;
import org.apache.daffodil.runtime1.processors.DaffodilParseXMLReader;
import org.apache.daffodil.runtime1.processors.DaffodilUnparseContentHandlerImpl;
import org.apache.daffodil.runtime1.processors.DataProcessor$;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.MetadataWalker;
import org.apache.daffodil.runtime1.processors.ParseResult;
import org.apache.daffodil.runtime1.processors.ProcessingError;
import org.apache.daffodil.runtime1.processors.ProcessorResult;
import org.apache.daffodil.runtime1.processors.SchemaSetRuntimeData;
import org.apache.daffodil.runtime1.processors.Success$;
import org.apache.daffodil.runtime1.processors.TermRuntimeData;
import org.apache.daffodil.runtime1.processors.UnparseResult;
import org.apache.daffodil.runtime1.processors.VariableMap;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.PState$;
import org.apache.daffodil.runtime1.processors.parsers.ParseError;
import org.apache.daffodil.runtime1.processors.parsers.Parser;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import org.apache.daffodil.runtime1.processors.unparsers.UState$;
import org.apache.daffodil.runtime1.processors.unparsers.UnparseError;
import org.apache.daffodil.runtime1.processors.unparsers.UnparseError$;
import org.apache.daffodil.runtime1.processors.unparsers.Unparser;
import org.apache.daffodil.validation.DaffodilValidator$;
import org.apache.daffodil.validation.NoValidator$;
import org.xml.sax.SAXException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.xml.parsing.FatalError;

public class DataProcessor
implements org.apache.daffodil.api.DataProcessor,
WithDiagnostics,
DFDL.DataProcessor,
MultipleEventHandler {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DataProcessor.class.getDeclaredField("regexMatchStatePool$lzy1"));
    private transient Seq handlers_;
    private final SchemaSetRuntimeData ssrd;
    private final DaffodilTunables tunables;
    private final VariableMap variableMap;
    private final Validator validator;
    private final boolean areDebugging;
    private final Option optDebugger;
    private final Seq diagnostics;
    private volatile transient Object regexMatchStatePool$lzy1;

    public static Validator $lessinit$greater$default$4() {
        return DataProcessor$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean $lessinit$greater$default$5() {
        return DataProcessor$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<Debugger> $lessinit$greater$default$6() {
        return DataProcessor$.MODULE$.$lessinit$greater$default$6();
    }

    public static Seq<Diagnostic> $lessinit$greater$default$7() {
        return DataProcessor$.MODULE$.$lessinit$greater$default$7();
    }

    public DataProcessor(SchemaSetRuntimeData ssrd, DaffodilTunables tunables, VariableMap variableMap, Validator validator, boolean areDebugging, Option<Debugger> optDebugger, Seq<Diagnostic> diagnostics) {
        this.ssrd = ssrd;
        this.tunables = tunables;
        this.variableMap = variableMap;
        this.validator = validator;
        this.areDebugging = areDebugging;
        this.optDebugger = optDebugger;
        this.diagnostics = diagnostics;
        MultipleEventHandler.$init$(this);
    }

    public final Seq handlers_() {
        return this.handlers_;
    }

    public final void handlers__$eq(Seq x$1) {
        this.handlers_ = x$1;
    }

    public SchemaSetRuntimeData ssrd() {
        return this.ssrd;
    }

    @Override
    public DaffodilTunables tunables() {
        return this.tunables;
    }

    @Override
    public VariableMap variableMap() {
        return this.variableMap;
    }

    public Validator validator() {
        return this.validator;
    }

    public boolean areDebugging() {
        return this.areDebugging;
    }

    public Option<Debugger> optDebugger() {
        return this.optDebugger;
    }

    public Seq<Diagnostic> diagnostics() {
        return this.diagnostics;
    }

    public DataProcessor copy(SchemaSetRuntimeData ssrd, DaffodilTunables tunables, VariableMap variableMap, Validator validator, boolean areDebugging, Option<Debugger> optDebugger, Seq<Diagnostic> diagnostics) {
        return new DataProcessor(ssrd, tunables, variableMap, validator, areDebugging, optDebugger, diagnostics);
    }

    public SchemaSetRuntimeData copy$default$1() {
        return this.ssrd();
    }

    public DaffodilTunables copy$default$2() {
        return this.tunables();
    }

    public VariableMap copy$default$3() {
        return this.variableMap().copy();
    }

    public Validator copy$default$4() {
        return this.validator();
    }

    public boolean copy$default$5() {
        return this.areDebugging();
    }

    public Option<Debugger> copy$default$6() {
        return this.optDebugger();
    }

    public Seq<Diagnostic> copy$default$7() {
        return this.diagnostics();
    }

    public ThreadSafePool<Tuple2<CharBuffer, LongBuffer>> regexMatchStatePool() {
        Object object = this.regexMatchStatePool$lzy1;
        if (object instanceof ThreadSafePool) {
            return (ThreadSafePool)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ThreadSafePool)this.regexMatchStatePool$lzyINIT1();
    }

    private Object regexMatchStatePool$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.regexMatchStatePool$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ThreadSafePool<Tuple2<CharBuffer, LongBuffer>> threadSafePool = null;
                    try {
                        threadSafePool = new ThreadSafePool<Tuple2<CharBuffer, LongBuffer>>(this){
                            private final /* synthetic */ DataProcessor $outer;
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }

                            public Tuple2 allocate() {
                                CharBuffer cb = CharBuffer.allocate(this.$outer.tunables().maximumRegexMatchLengthInCharacters());
                                LongBuffer lb = LongBuffer.allocate(this.$outer.tunables().maximumRegexMatchLengthInCharacters());
                                return Tuple2$.MODULE$.apply((Object)cb, (Object)lb);
                            }
                        };
                        object2 = threadSafePool == null ? LazyVals.NullValue$.MODULE$ : threadSafePool;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.regexMatchStatePool$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return threadSafePool;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public DataProcessor clone() {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    @Override
    public org.apache.daffodil.api.DataProcessor withValidation(String kind, URL config) {
        Properties properties = new Properties();
        if (config != null) {
            String configPath = config.getPath();
            if (configPath.endsWith(".conf") || configPath.endsWith(".properties")) {
                try {
                    properties.load(config.openStream());
                }
                catch (Exception e) {
                    throw new ValidatorInitializationException(e.getMessage());
                }
            } else {
                properties.setProperty(kind, config.toString());
            }
        }
        Validator v = Validators.get(kind).make(properties);
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), v, this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public Debugger debugger() {
        if (!this.areDebugging()) {
            throw Assert$.MODULE$.abort("Invariant broken: DataProcessor.this.areDebugging");
        }
        return (Debugger)this.optDebugger().get();
    }

    @Override
    public DataProcessor withDebugger(Debugger dbg) {
        None$ optDbg = dbg == null ? None$.MODULE$ : Some$.MODULE$.apply((Object)dbg);
        DaffodilTunables newTunables = optDbg.isDefined() ? this.tunables().withTunable("allowExternalPathExpressions", "true") : this.tunables();
        boolean bl = optDbg.isDefined();
        SchemaSetRuntimeData schemaSetRuntimeData = this.copy$default$1();
        VariableMap variableMap = this.copy$default$3();
        Validator validator = this.copy$default$4();
        Seq<Diagnostic> seq = this.copy$default$7();
        return this.copy(schemaSetRuntimeData, newTunables, variableMap, validator, bl, (Option<Debugger>)optDbg, seq);
    }

    @Override
    public DataProcessor withExternalVariables(Map<String, String> extVars) {
        Queue<Binding> bindings = ExternalVariablesLoader$.MODULE$.mapToBindings(extVars);
        VariableMap newVariableMap = ExternalVariablesLoader$.MODULE$.loadVariables((Seq<Binding>)bindings, this.ssrd(), this.variableMap().copy());
        return this.copy(this.copy$default$1(), this.copy$default$2(), newVariableMap, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    @Override
    public DataProcessor withExternalVariables(File extVars) {
        Queue<Binding> bindings = ExternalVariablesLoader$.MODULE$.fileToBindings(extVars);
        VariableMap newVariableMap = ExternalVariablesLoader$.MODULE$.loadVariables((Seq<Binding>)bindings, this.ssrd(), this.variableMap().copy());
        return this.copy(this.copy$default$1(), this.copy$default$2(), newVariableMap, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    @Override
    public DataProcessor withExternalVariables(Seq<Binding> bindings) {
        VariableMap newVariableMap = ExternalVariablesLoader$.MODULE$.loadVariables(bindings, this.ssrd(), this.variableMap().copy());
        return this.copy(this.copy$default$1(), this.copy$default$2(), newVariableMap, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public List<Diagnostic> getDiagnostics() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.diagnostics()).asJava();
    }

    @Override
    public org.apache.daffodil.api.DaffodilParseXMLReader newXMLReaderInstance() {
        DaffodilParseXMLReader xrdr = new DaffodilParseXMLReader(this);
        return xrdr;
    }

    @Override
    public DFDL.DaffodilUnparseContentHandler newContentHandlerInstance(WritableByteChannel output) {
        return new DaffodilUnparseContentHandlerImpl(this, output);
    }

    @Override
    public void save(WritableByteChannel output) {
        OutputStream os = Channels.newOutputStream(output);
        String headerString = "DAFFODIL " + Misc$.MODULE$.getDaffodilVersion() + "\u0000";
        os.write(headerString.getBytes(StandardCharsets.UTF_8));
        ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(os));
        VariableMap variableMap = this.ssrd().originalVariables();
        NoValidator$ noValidator$ = NoValidator$.MODULE$;
        Seq seq = (Seq)package$.MODULE$.Seq().empty();
        None$ none$ = None$.MODULE$;
        SchemaSetRuntimeData schemaSetRuntimeData = this.copy$default$1();
        DaffodilTunables daffodilTunables = this.copy$default$2();
        DataProcessor dpToSave = this.copy(schemaSetRuntimeData, daffodilTunables, variableMap, noValidator$, false, (Option<Debugger>)none$, (Seq<Diagnostic>)seq);
        try {
            oos.writeObject(dpToSave);
        }
        catch (IOException e) {
            Some<Throwable> some = Misc$.MODULE$.getSomeCause(e);
            if (some == null) {
                throw new MatchError(some);
            }
            Throwable cause = (Throwable)some.value();
            Throwable cause2 = cause;
            throw cause2;
        }
        oos.close();
    }

    @Override
    public void walkMetadata(MetadataHandler handler) {
        MetadataWalker walker = new MetadataWalker(this);
        walker.walk(handler);
    }

    public DFDL.ParseResult parse(org.apache.daffodil.io.InputSourceDataInputStream input, InfosetOutputter output) {
        ParseResult parseResult;
        InfosetOutputter infosetOutputter;
        Tuple2 tuple2;
        this.checkNotError();
        Validator validator = this.validator();
        if (DaffodilValidator$.MODULE$.equals(validator) || NoValidator$.MODULE$.equals(validator)) {
            v0 = Tuple2$.MODULE$.apply((Object)output, new Maybe(Maybe$.MODULE$.Nope()));
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            XMLTextInfosetOutputter xmlOutputter = new XMLTextInfosetOutputter(bos, false, XMLTextInfosetOutputter$.MODULE$.$lessinit$greater$default$3(), XMLTextInfosetOutputter$.MODULE$.$lessinit$greater$default$4());
            TeeInfosetOutputter teeOutputter = new TeeInfosetOutputter((Seq<InfosetOutputter>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InfosetOutputter[]{output, xmlOutputter}));
            teeOutputter.setBlobAttributes(output.getBlobDirectory(), output.getBlobPrefix(), output.getBlobSuffix());
            v0 = tuple2 = Tuple2$.MODULE$.apply((Object)teeOutputter, new Maybe(Maybe$One$.MODULE$.apply(bos)));
        }
        if (tuple2 == null || (infosetOutputter = (InfosetOutputter)tuple2._1()) == null) {
            throw new MatchError((Object)tuple2);
        }
        InfosetOutputter outputter = infosetOutputter;
        Object maybeValidationBytes = tuple2._2() == null ? null : ((Maybe)tuple2._2()).v();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)outputter, new Maybe(maybeValidationBytes));
        InfosetOutputter outputter2 = (InfosetOutputter)tuple22._1();
        Object maybeValidationBytes2 = tuple22._2() == null ? null : ((Maybe)tuple22._2()).v();
        ElementRuntimeData rootERD = this.ssrd().elementRuntimeData();
        PState state = PState$.MODULE$.createInitialPState(rootERD, input, outputter2, (DFDL.DataProcessor)this, this.areDebugging());
        if (this.areDebugging()) {
            if (!this.optDebugger().isDefined()) {
                throw Assert$.MODULE$.abort("Invariant broken: DataProcessor.this.optDebugger.isDefined");
            }
            this.addEventHandler(this.debugger());
            state.notifyDebugging(true);
        }
        Object object = state.dataProc();
        ((DataProcessor)Maybe$.MODULE$.get$extension(object)).init(state, this.ssrd().parser());
        this.doParse(this.ssrd().parser(), state);
        ProcessorResult processorResult = state.processorStatus();
        Success$ success$ = Success$.MODULE$;
        if (!(processorResult != null ? !processorResult.equals(success$) : success$ != null)) {
            Maybe$.MODULE$.toOption$extension(maybeValidationBytes2).foreach((Function1)(JProcedure1 & Serializable)bytes -> {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes.toByteArray());
                this.validator().validateXML(bis, state);
            });
            output.setBlobPaths(CollectionConverters$.MODULE$.SeqHasAsJava(state.blobPaths()).asJava());
            parseResult = new ParseResult(state);
        } else {
            state.blobPaths().foreach((Function1)(JProcedure1 & Serializable)path -> Files.delete(path));
            output.setBlobPaths(new LinkedList<Path>());
            parseResult = new ParseResult(state);
        }
        ParseResult pr = parseResult;
        PState s = state;
        Object dp = s.dataProc();
        Parser ssrdParser = this.ssrd().parser();
        if (Maybe$.MODULE$.isDefined$extension(dp)) {
            ((DataProcessor)Maybe$.MODULE$.value$extension(dp)).fini(ssrdParser);
        }
        return pr;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doParse(Parser p, PState state) {
        block16: {
            optThrown = Maybe$.MODULE$.toMaybe(None$.MODULE$);
            try {
                if (!state.dataInputStreamIsValid()) {
                    throw Assert$.MODULE$.usageError2("Attempted to use an invalid input source. This can happen due to our position in the input source not being properly reset after failed parse could not backtrack to its original position", "state.dataInputStreamIsValid");
                }
                ** GOTO lbl-1000
            }
            catch (Throwable e) {
                optThrown = Maybe$.MODULE$.toMaybe(Some$.MODULE$.apply((Object)e));
                throw e;
                catch (Throwable var6_6) {
                    try {
                        state.verifyFinalState(optThrown);
                        throw var6_6;
                    }
                    catch (ParseError pe) {
                        throw Assert$.MODULE$.invariantFailed("ParseError caught. ParseErrors should be returned as failed status, not thrown. Fix please.");
                    }
                    catch (ProcessingError procErr) {
                        x = procErr;
                        state.setFailed(x.toParseError());
                        return;
                    }
                    catch (SchemaDefinitionError sde) {
                        state.dataInputStream().inputSource().setInvalid();
                        state.setFailed(sde);
                        return;
                    }
                    catch (SchemaDefinitionErrorFromWarning sdefw) {
                        state.dataInputStream().inputSource().setInvalid();
                        state.setFailed(sdefw);
                        return;
                    }
                    catch (ErrorAlreadyHandled e) {
                        state.setFailed(e.th());
                        return;
                    }
                    catch (TunableLimitExceededError e) {
                        state.setFailed(e);
                        return;
                    }
                    catch (UnsuppressableException us) {
                        throw us;
                    }
                    catch (LayerFatalException lre) {
                        throw lre;
                    }
                    catch (Throwable x) {
                        sw = new StringWriter();
                        pw = new PrintWriter(sw);
                        x.printStackTrace(pw);
                        throw Assert$.MODULE$.invariantFailed("Runtime.scala - Leaked exception: " + x + "\n" + sw.toString());
                    }
                }
lbl-1000:
                // 1 sources

                {
                    state.initializeVariables();
                    this.startElement(state, p);
                    p.parse1(state);
                    this.endElement(state, p);
                    state.setMaybeProcessor(Maybe$.MODULE$.apply(p));
                    v0 = state.processorStatus();
                    var4_4 = Success$.MODULE$;
                    if (v0 != null ? v0.equals(var4_4) == false : var4_4 != null) break block16;
                    state.walker().walk(true);
                    if (state.walker().isFinished()) break block16;
                    throw Assert$.MODULE$.abort("Invariant broken: state.walker.isFinished");
                }
            }
        }
        state.verifyFinalState(optThrown);
    }

    @Override
    public UnparseResult unparse(org.apache.daffodil.api.infoset.InfosetInputter actualInputter, WritableByteChannel output) {
        this.checkNotError();
        OutputStream outStream = Channels.newOutputStream(output);
        return this.unparse(actualInputter, outStream);
    }

    /*
     * Unable to fully structure code
     */
    public UnparseResult unparse(org.apache.daffodil.api.infoset.InfosetInputter actualInputter, OutputStream outStream) {
        block16: {
            inputter = new InfosetInputter(actualInputter);
            inputter.initialize(this.ssrd().elementRuntimeData(), this.tunables());
            unparserState = UState$.MODULE$.createInitialUState(outStream, this, inputter, this.areDebugging());
            if (!this.areDebugging()) ** GOTO lbl13
            if (this.optDebugger().isDefined()) break block16;
            throw Assert$.MODULE$.abort("Invariant broken: DataProcessor.this.optDebugger.isDefined");
        }
        try {
            try {
                this.addEventHandler(this.debugger());
                unparserState.notifyDebugging(true);
lbl13:
                // 2 sources

                var6_5 = unparserState.dataProc();
                ((DataProcessor)Maybe$.MODULE$.get$extension(var6_5)).init(unparserState, this.ssrd().unparser());
                unparserState.getDataOutputStream().setPriorBitOrder(this.ssrd().elementRuntimeData().defaultBitOrder());
                this.doUnparse(unparserState);
                unparserState.evalSuspensions(true);
                v0 = unparserState.unparseResult();
            }
            catch (UnparseError ue) {
                unparserState.addUnparseError(ue);
                v0 = unparserState.unparseResult();
            }
            catch (ProcessingError procErr) {
                x = procErr;
                unparserState.setFailed(x.toUnparseError());
                v0 = unparserState.unparseResult();
            }
            catch (SchemaDefinitionError sde) {
                unparserState.setFailed(sde);
                v0 = unparserState.unparseResult();
            }
            catch (SchemaDefinitionErrorFromWarning sdefw) {
                unparserState.setFailed(sdefw);
                v0 = unparserState.unparseResult();
            }
            catch (ErrorAlreadyHandled e) {
                unparserState.setFailed(e.th());
                v0 = unparserState.unparseResult();
            }
            catch (TunableLimitExceededError e) {
                unparserState.setFailed(e);
                v0 = unparserState.unparseResult();
            }
            catch (SAXException se) {
                unparserState.setFailed(new UnparseError(Maybe$.MODULE$.toMaybe(None$.MODULE$), Maybe$.MODULE$.toMaybe(None$.MODULE$), se));
                v0 = unparserState.unparseResult();
            }
            catch (FatalError e) {
                unparserState.setFailed(new UnparseError(Maybe$.MODULE$.toMaybe(None$.MODULE$), Maybe$.MODULE$.toMaybe(None$.MODULE$), e));
                v0 = unparserState.unparseResult();
            }
            catch (Throwable var16_15) {
                var17_16 = var16_15;
                if (var17_16 instanceof InfosetException) {
                    ie = (Throwable)((InfosetException)var17_16);
                    unparserState.setFailed(new UnparseError(Maybe$.MODULE$.toMaybe(None$.MODULE$), Maybe$.MODULE$.toMaybe(None$.MODULE$), ie));
                    v0 = unparserState.unparseResult();
                }
                if (var17_16 != null) {
                    th = var17_16;
                    throw th;
                }
                throw var16_15;
            }
        }
        catch (Throwable var20_19) {
            throw var20_19;
        }
        finally {
            unparserState.getDataOutputStream().cleanUp();
        }
        res = v0;
        return res;
    }

    private void doUnparse(UState state) {
        Unparser rootUnparser = this.ssrd().unparser();
        Object mtrd = state.maybeTopTRD();
        if (!Maybe$.MODULE$.isDefined$extension(mtrd) || (TermRuntimeData)Maybe$.MODULE$.get$extension(mtrd) != rootUnparser.context()) {
            throw Assert$.MODULE$.abort("Invariant broken: {\n  val mtrd: org.apache.daffodil.lib.util.Maybe[org.apache.daffodil.runtime1.processors.TermRuntimeData] = state.maybeTopTRD()\n  mtrd.isDefined.&&(mtrd.get.eq(rootUnparser.context))\n}");
        }
        state.initializeVariables();
        rootUnparser.unparse1(state, rootUnparser.unparse1$default$2());
        state.popTRD((TermRuntimeData)rootUnparser.context());
        state.setProcessor(rootUnparser);
        if (state.arrayIterationIndexStack().length() != 1) {
            throw Assert$.MODULE$.abort("Invariant broken: state.arrayIterationIndexStack.length.==(1)");
        }
        if (state.occursIndexStack().length() != 1) {
            throw Assert$.MODULE$.abort("Invariant broken: state.occursIndexStack.length.==(1)");
        }
        if (state.groupIndexStack().length() != 1) {
            throw Assert$.MODULE$.abort("Invariant broken: state.groupIndexStack.length.==(1)");
        }
        if (state.childIndexStack().length() != 1) {
            throw Assert$.MODULE$.abort("Invariant broken: state.childIndexStack.length.==(1)");
        }
        Object object = state.currentInfosetNodeMaybe();
        if (!Maybe$.MODULE$.isEmpty$extension(object)) {
            throw Assert$.MODULE$.abort("Invariant broken: state.currentInfosetNodeMaybe.isEmpty");
        }
        if (!state.escapeSchemeEVCache().isEmpty()) {
            throw Assert$.MODULE$.abort("Invariant broken: state.escapeSchemeEVCache.isEmpty");
        }
        Object object2 = state.maybeTopTRD();
        if (!Maybe$.MODULE$.isEmpty$extension(object2)) {
            throw Assert$.MODULE$.abort("Invariant broken: state.maybeTopTRD().isEmpty");
        }
        if (state.withinHiddenNest()) {
            throw Assert$.MODULE$.abort("Invariant broken: state.withinHiddenNest.unary_!");
        }
        if (state.getDataOutputStream().isFinished()) {
            throw Assert$.MODULE$.abort("Invariant broken: state.getDataOutputStream.isFinished.unary_!");
        }
        try {
            state.getDataOutputStream().setFinished(state);
        }
        catch (BitOrderChangeException boc) {
            throw state.SDE(boc);
        }
        catch (FileIOException fio) {
            throw state.SDE(fio);
        }
        Object ev = state.advanceMaybe();
        if (Maybe$.MODULE$.isDefined$extension(ev)) {
            throw UnparseError$.MODULE$.apply(Maybe$.MODULE$.Nope(), Maybe$One$.MODULE$.apply(state.currentLocation()), "Expected no remaining events, but received %s.", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{(InfosetAccessor)Maybe$.MODULE$.get$extension(ev)}));
        }
    }

    @Override
    public DFDL.ParseResult parse(InputSourceDataInputStream input, InfosetOutputter output) {
        return this.parse((org.apache.daffodil.io.InputSourceDataInputStream)input, output);
    }
}

