/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.largedata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;

public class Derby6317Test
extends BaseJDBCTestCase {
    static final int DATABASE_SCALE = 1000000;
    static final int TABLE_ONE_ROW_COUNT = 1000000;
    static final int TABLE_THREE_ROW_COUNT = 8000000;
    static final int SELECT_ROWS_COUNT = 8000000;
    final String testSelect = "SELECT * FROM Table1 T1,Table2 t0 WHERE t1.ID = t0.Table1_ID and t0.Table3_ID = ";

    public Derby6317Test(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("Derby6317Test");
        suite.addTest(Derby6317Test.baseSuite("Derby6317Test:embedded"));
        return suite;
    }

    private void confirmIndexScanUsage(Statement stmt, int some_constant) throws SQLException {
        RuntimeStatisticsParser rtsp = SQLUtilities.getRuntimeStatisticsParser(stmt);
        boolean constraintUsed = rtsp.usedConstraintForIndexScan("TABLE1");
        if (!constraintUsed) {
            Derby6317Test.assertTrue((String)("Should have done index scan but did table scan on TABLE1 for t0.Table3_ID = " + some_constant), (boolean)constraintUsed);
        }
        if (!(constraintUsed = rtsp.usedConstraintForIndexScan("TABLE2"))) {
            Derby6317Test.assertTrue((String)("Should have done index scan but did table scan on TABLE2 for t0.Table3_ID = " + some_constant), (boolean)constraintUsed);
        }
    }

    public void testDERBY_6317_value1() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        stmt.execute("SELECT * FROM Table1 T1,Table2 t0 WHERE t1.ID = t0.Table1_ID and t0.Table3_ID = 5189284");
        this.confirmIndexScanUsage(stmt, 5189284);
    }

    public void testDERBY_6317_value2() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        stmt.execute("SELECT * FROM Table1 T1,Table2 t0 WHERE t1.ID = t0.Table1_ID and t0.Table3_ID = 6035610");
        this.confirmIndexScanUsage(stmt, 6035610);
    }

    public void testDERBY_6317_value3() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        stmt.execute("SELECT * FROM Table1 T1,Table2 t0 WHERE t1.ID = t0.Table1_ID and t0.Table3_ID = 6031628");
        this.confirmIndexScanUsage(stmt, 6031628);
    }

    public void testDERBY_6317_value4() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        stmt.execute("SELECT * FROM Table1 T1,Table2 t0 WHERE t1.ID = t0.Table1_ID and t0.Table3_ID = 5189285");
        this.confirmIndexScanUsage(stmt, 5189285);
    }

    public void testDERBY_6317_value6() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        stmt.execute("SELECT * FROM Table1 T1,Table2 t0 WHERE t1.ID = t0.Table1_ID and t0.Table3_ID = 6035609");
        this.confirmIndexScanUsage(stmt, 6035609);
    }

    public void testDERBY_6317_value5() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        stmt.execute("SELECT * FROM Table1 T1,Table2 t0 WHERE t1.ID = t0.Table1_ID and t0.Table3_ID = 1");
        this.confirmIndexScanUsage(stmt, 1);
    }

    public void dontrun_testDERBY_6317() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        for (int i = 0; i < 8000000; ++i) {
            stmt.execute("SELECT * FROM Table1 T1,Table2 t0 WHERE t1.ID = t0.Table1_ID and t0.Table3_ID = " + i);
            this.confirmIndexScanUsage(stmt, i);
        }
    }

    protected static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        suite.addTestSuite(Derby6317Test.class);
        return new CleanDatabaseTestSetup((Test)suite){

            @Override
            protected void decorateSQL(Statement stmt) throws SQLException {
                int i;
                Connection conn = stmt.getConnection();
                stmt.executeUpdate("CREATE TABLE Table1 (ID int PRIMARY KEY NOT NULL)");
                stmt.executeUpdate("CREATE TABLE Table2 (Table1_ID int NOT NULL,Table3_ID int NOT NULL,CONSTRAINT TABLE2_PK PRIMARY KEY (Table1_ID,Table3_ID))");
                stmt.executeUpdate("CREATE TABLE Table3 (ID int PRIMARY KEY NOT NULL)");
                stmt.executeUpdate("ALTER TABLE table2 ADD CONSTRAINT TABLE2_FK_1 FOREIGN KEY (Table1_ID) REFERENCES TABLE1(ID)");
                stmt.executeUpdate("ALTER TABLE table2 ADD CONSTRAINT TABLE2_FK_2 FOREIGN KEY (Table3_ID) REFERENCES TABLE3(ID)");
                conn.setAutoCommit(false);
                PreparedStatement insertPS = this.getConnection().prepareStatement("INSERT INTO table1 VALUES (?)");
                for (int i2 = 0; i2 < 1000000; ++i2) {
                    insertPS.setInt(1, i2);
                    insertPS.execute();
                    if (i2 % 10000 != 0) continue;
                    conn.commit();
                }
                conn.commit();
                int count = 8000000;
                insertPS = conn.prepareStatement("INSERT INTO table3 VALUES (?)");
                for (i = 0; i < count; ++i) {
                    insertPS.setInt(1, i);
                    insertPS.execute();
                    if (i % 10000 != 0) continue;
                    conn.commit();
                }
                conn.commit();
                insertPS = conn.prepareStatement("INSERT INTO table2 VALUES (?,?)");
                int j = 0;
                for (i = 0; i < 1000000; ++i) {
                    insertPS.setInt(1, i);
                    int k = 0;
                    while (k < 8) {
                        insertPS.setInt(2, j);
                        insertPS.execute();
                        ++k;
                        ++j;
                    }
                    if (i % 10000 != 0) continue;
                    conn.commit();
                }
                conn.commit();
            }
        };
    }
}

