/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.WindowFunctionNode;
import org.apache.derby.shared.common.error.StandardException;

class ReplaceWindowFuncCallsWithCRVisitor
implements Visitor {
    private ResultColumnList rcl;
    private Class<?> skipOverClass;
    private int tableNumber;

    ReplaceWindowFuncCallsWithCRVisitor(ResultColumnList rcl, int tableNumber, Class<?> skipOverClass) {
        this.rcl = rcl;
        this.tableNumber = tableNumber;
        this.skipOverClass = skipOverClass;
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        if (node instanceof WindowFunctionNode) {
            node = ((WindowFunctionNode)node).replaceCallsWithColumnReferences(this.rcl, this.tableNumber);
        }
        return node;
    }

    @Override
    public boolean skipChildren(Visitable node) {
        return this.skipOverClass == null ? false : this.skipOverClass.isInstance(node);
    }

    @Override
    public boolean visitChildrenFirst(Visitable node) {
        return false;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }
}

