/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.GenericAggregateResultSet;
import org.apache.derby.impl.sql.execute.GenericAggregator;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class ScalarAggregateResultSet
extends GenericAggregateResultSet
implements CursorResultSet {
    public int rowsInput;
    public boolean singleInputRow;
    protected boolean isInSortedOrder;
    protected ExecIndexRow sourceExecIndexRow;
    private boolean nextSatisfied;
    protected int countOfRows;

    ScalarAggregateResultSet(NoPutResultSet s, boolean isInSortedOrder, int aggregateItem, Activation a, int ra, int resultSetNumber, boolean singleInputRow, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(s, aggregateItem, a, ra, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.isInSortedOrder = isInSortedOrder;
        SanityManager.ASSERT(this.source != null, "SARS(), source expected to be non-null");
        this.singleInputRow = singleInputRow;
        SanityManager.DEBUG("AggregateTrace", "execution time: " + String.valueOf(a.getPreparedStatement().getSavedObject(aggregateItem)));
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(this.source != null, "SARS.openCore(), source expected to be non-null");
        SanityManager.ASSERT(!this.isOpen, "ScalarAggregateResultSet already open");
        this.sourceExecIndexRow = (ExecIndexRow)this.getRowTemplate().getClone();
        this.source.openCore();
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        if (this.nextSatisfied) {
            this.clearCurrentRow();
            return null;
        }
        ExecIndexRow execIndexRow = null;
        ExecIndexRow aggResult = null;
        boolean minAgg = this.singleInputRow && this.aggregates[0].getAggregatorInfo().aggregateName.equals("MIN");
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            while ((execIndexRow = this.getRowFromResultSet(false)) != null) {
                if (aggResult == null) {
                    aggResult = this.singleInputRow && minAgg ? execIndexRow : (ExecIndexRow)execIndexRow.getClone();
                    this.initializeScalarAggregation(aggResult);
                } else {
                    this.accumulateScalarAggregation(execIndexRow, aggResult, false);
                }
                if (!this.singleInputRow || !minAgg && aggResult.getColumn(this.aggregates[0].aggregatorColumnId).isNull()) continue;
            }
            if (this.countOfRows == 0) {
                aggResult = this.finishAggregation(aggResult);
                this.setCurrentRow(aggResult);
                ++this.countOfRows;
            }
        }
        this.nextSatisfied = true;
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return aggResult;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.countOfRows = 0;
            this.sourceExecIndexRow = null;
            this.source.close();
            super.close();
        } else {
            SanityManager.DEBUG("CloseRepeatInfo", "Close of SortResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
        this.nextSatisfied = false;
        this.isOpen = false;
    }

    @Override
    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime - this.originalSource.getTimeSpent(1);
        }
        return totTime;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        return null;
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        SanityManager.ASSERT(this.isOpen, "SortResultSet expected to be open");
        return this.currentRow;
    }

    public ExecIndexRow getRowFromResultSet(boolean doClone) throws StandardException {
        ExecIndexRow inputRow = null;
        ExecRow sourceRow = this.source.getNextRowCore();
        if (sourceRow != null) {
            ++this.rowsInput;
            this.sourceExecIndexRow.execRowToExecIndexRow(doClone ? sourceRow.getClone() : sourceRow);
            inputRow = this.sourceExecIndexRow;
        }
        return inputRow;
    }

    @Override
    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(this.isOpen, "NormalizeResultSet already open");
        this.source.reopenCore();
        ++this.numOpens;
        this.countOfRows = 0;
        this.nextSatisfied = false;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    protected void accumulateScalarAggregation(ExecRow inputRow, ExecRow accumulateRow, boolean hasDistinctAggregates) throws StandardException {
        int size = this.aggregates.length;
        SanityManager.ASSERT(inputRow != null && accumulateRow != null, "Null row passed to accumulateScalarAggregation");
        for (int i = 0; i < size; ++i) {
            GenericAggregator currAggregate = this.aggregates[i];
            if (hasDistinctAggregates && !currAggregate.getAggregatorInfo().isDistinct()) {
                currAggregate.merge(inputRow, accumulateRow);
                continue;
            }
            currAggregate.accumulate(inputRow, accumulateRow);
        }
    }

    private void initializeScalarAggregation(ExecRow row) throws StandardException {
        int size = this.aggregates.length;
        SanityManager.ASSERT(row != null, "Null row passed to initializeScalarAggregation");
        for (int i = 0; i < size; ++i) {
            GenericAggregator currAggregate = this.aggregates[i];
            currAggregate.initialize(row);
            currAggregate.accumulate(row, row);
        }
    }
}

