/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derby.iapi.jdbc.InternalDriver;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RollBackWrappingWhenFailOnImportTest
extends BaseJDBCTestCase {
    private String nonexistentFileName = "test/test.dat";

    public RollBackWrappingWhenFailOnImportTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("RollBackWrappingWhenFailOnImportTest");
        if (!JDBC.vmSupportsJDBC3()) {
            return suite;
        }
        CleanDatabaseTestSetup test = new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(RollBackWrappingWhenFailOnImportTest.class));
        suite.addTest((Test)test);
        return suite;
    }

    protected void setUp() throws Exception {
        this.openDefaultConnection();
        MockInternalDriver dvr = new MockInternalDriver(this);
        dvr.boot(false, null);
        SupportFilesSetup.deleteFile(this.nonexistentFileName);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.getTestConfiguration().shutdownEngine();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tearDown();
    }

    public void testRollBackWhenFailOnImportTable() throws SQLException {
        String callSentence = "call SYSCS_UTIL.SYSCS_IMPORT_TABLE (null, 'IMP_EMP', '" + this.nonexistentFileName + "test/test.dat' , null, null, null, 0) ";
        this.realTestRollBackWhenImportOnNonexistentFile(callSentence);
    }

    public void testRollBackWhenFailOnImportTableLobsFromEXTFile() throws SQLException {
        String callSentence = "call SYSCS_UTIL.SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE(null, 'IET1' , '" + this.nonexistentFileName + "', null, null, null, 0)";
        this.realTestRollBackWhenImportOnNonexistentFile(callSentence);
    }

    public void testRollBackWhenFailOnImportData() throws SQLException {
        String callSentence = "call SYSCS_UTIL.SYSCS_IMPORT_DATA(null, 'IMP_EMP', null, null, '" + this.nonexistentFileName + "', null, null, null, 1) ";
        this.realTestRollBackWhenImportOnNonexistentFile(callSentence);
    }

    public void testRollBackWhenFailOnImportDataLobsFromExtFile() throws SQLException {
        String callSentence = "call SYSCS_UTIL.SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE(null, 'IET1', null, null, '" + this.nonexistentFileName + "', null, null, null, 1)";
        this.realTestRollBackWhenImportOnNonexistentFile(callSentence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realTestRollBackWhenImportOnNonexistentFile(String importSentence) throws SQLException {
        try (CallableStatement cSt = this.prepareCall(importSentence);){
            cSt.executeUpdate();
            RollBackWrappingWhenFailOnImportTest.fail((String)"a SQLException should be thrown as we import data from a nonexistent file");
        }
    }

    class MockInternalDriver
    extends InternalDriver {
        MockInternalDriver(RollBackWrappingWhenFailOnImportTest this$0) {
        }

        public Connection connect(String url, Properties info, int loginTimeout) {
            Connection conn = null;
            try {
                conn = super.connect(url, info, loginTimeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new MockConnectionFailWhenRollBack(this, conn);
        }

        public class MockConnectionFailWhenRollBack
        extends EmbedConnection {
            public MockConnectionFailWhenRollBack(MockInternalDriver this$1, Connection connection) {
                super((EmbedConnection)connection);
            }

            public void rollback() throws SQLException {
                throw new SQLException("error in roll back", "XJ058");
            }
        }
    }
}

