/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DboPowersTest
extends BaseJDBCTestCase {
    private final int _authLevel;
    private final String _dbo;
    private final String _dboPassword;
    private static final int NOAUTHENTICATION = 0;
    private static final int AUTHENTICATION = 1;
    private static final int SQLAUTHORIZATION = 2;
    private static final String[] secLevelNames = new String[]{"noAuthentication", "authentication", "authentication + sqlAuthorization"};
    private static final boolean ENCRYPT = true;
    private static final boolean DECRYPT = false;
    static final String[][] users = new String[][]{{"APP", "U1"}, {"TEST_DBO", "U1"}};
    static final String pwSuffix = "pwSuffix";
    static final String[] cryptoTests = new String[]{"testEncrypt", "testReEncrypt", "testDecrypt"};

    public DboPowersTest(String string, int n) {
        super(string);
        this._authLevel = n;
        this._dbo = null;
        this._dboPassword = null;
    }

    public DboPowersTest(String string, int n, String string2, String string3) {
        super(string);
        this._authLevel = n;
        this._dbo = string2;
        this._dboPassword = string3;
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("DboPowersTest");
        baseTestSuite.addTest(DboPowersTest.dboShutdownSuite("suite: shutdown powers, embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(DboPowersTest.dboShutdownSuite("suite: shutdown powers, client")));
        if (!JDBC.vmSupportsJSR169()) {
            baseTestSuite.addTest(DboPowersTest.dboCryptoSuite("suite: cryptographic powers, embedded"));
            baseTestSuite.addTest(TestConfiguration.clientServerDecorator(DboPowersTest.dboCryptoSuite("suite: cryptographic powers, client")));
        }
        baseTestSuite.addTest(DboPowersTest.dboHardUpgradeSuite("suite: hard upgrade powers, embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(DboPowersTest.dboHardUpgradeSuite("suite: hard upgrade powers, client")));
        return baseTestSuite;
    }

    private static Test dboShutdownSuite(String string) {
        Test[] testArray = new Test[3];
        BaseTestSuite baseTestSuite = new BaseTestSuite("suite: security level=" + secLevelNames[0]);
        baseTestSuite.addTest((Test)new DboPowersTest("testShutDown", 0));
        testArray[0] = baseTestSuite;
        for (int i = 1; i <= 2; ++i) {
            testArray[i] = DboPowersTest.wrapShutdownUserTests(i);
        }
        BaseTestSuite baseTestSuite2 = new BaseTestSuite("dboPowers:" + string);
        baseTestSuite2.addTest(testArray[0]);
        baseTestSuite2.addTest(testArray[1]);
        baseTestSuite2.addTest(TestConfiguration.sqlAuthorizationDecorator(testArray[2]));
        return baseTestSuite2;
    }

    private static Test wrapShutdownUserTests(int n) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("usersSuite: security level=" + secLevelNames[n]);
        for (int i = 0; i < users.length; ++i) {
            baseTestSuite.addTest(TestConfiguration.changeUserDecorator((Test)new DboPowersTest("testShutDown", n), users[n - 1][i], users[n - 1][i].concat(pwSuffix)));
        }
        return DatabasePropertyTestSetup.builtinAuthentication((Test)baseTestSuite, users[n - 1], pwSuffix);
    }

    public void testShutDown() throws SQLException {
        DboPowersTest.println("testShutDown: auth=" + this._authLevel + " user=" + this.getTestConfiguration().getUserName());
        this.getConnection().close();
        String string = this.getTestConfiguration().getUserName();
        String string2 = this.getTestConfiguration().getUserPassword();
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "shutdown=true");
        JDBCDataSource.setBeanProperty(dataSource, "user", string);
        JDBCDataSource.setBeanProperty(dataSource, "password", string2);
        try {
            dataSource.getConnection();
            DboPowersTest.fail((String)"shutdown failed: no exception");
        }
        catch (SQLException sQLException) {
            if ("08006".equals(sQLException.getSQLState())) {
                JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "");
                dataSource.getConnection().close();
            }
            this.vetShutdownException(string, sQLException);
        }
    }

    private void vetShutdownException(String string, SQLException sQLException) {
        switch (this._authLevel) {
            case 0: {
                DboPowersTest.assertSQLState("database shutdown, no authentication", "08006", sQLException);
                break;
            }
            case 1: {
                DboPowersTest.assertSQLState("database shutdown, authentication", "08006", sQLException);
                break;
            }
            case 2: {
                if ("TEST_DBO".equals(string)) {
                    DboPowersTest.assertSQLState("database shutdown, SQL authorization, db owner", "08006", sQLException);
                    break;
                }
                DboPowersTest.assertSQLState("database shutdown restriction, SQL authorization, not db owner", "08004", sQLException);
                break;
            }
            default: {
                DboPowersTest.fail((String)("test error: invalid authLevel: " + this._authLevel));
            }
        }
    }

    private static Test dboCryptoSuite(String string) {
        int n;
        Test[] testArray = new Test[3];
        BaseTestSuite baseTestSuite = new BaseTestSuite("suite: security level=" + secLevelNames[0]);
        for (n = 0; n < cryptoTests.length; ++n) {
            baseTestSuite.addTest((Test)TestConfiguration.singleUseDatabaseDecoratorNoShutdown((Test)new DboPowersTest(cryptoTests[n], 0, "foo", "bar")));
        }
        testArray[0] = baseTestSuite;
        for (n = 1; n <= 2; ++n) {
            testArray[n] = DboPowersTest.wrapCryptoUserTests(n);
        }
        BaseTestSuite baseTestSuite2 = new BaseTestSuite("dboPowers:" + string);
        baseTestSuite2.addTest(testArray[0]);
        baseTestSuite2.addTest(testArray[1]);
        baseTestSuite2.addTest(testArray[2]);
        return baseTestSuite2;
    }

    private static Test wrapCryptoUserTests(int n) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("usersSuite: security level=" + secLevelNames[n]);
        for (int i = 0; i < users.length; ++i) {
            for (int j = 0; j < cryptoTests.length; ++j) {
                Object object = TestConfiguration.changeUserDecorator((Test)new DboPowersTest(cryptoTests[j], n, users[n - 1][0], users[n - 1][0].concat(pwSuffix)), users[n - 1][i], users[n - 1][i].concat(pwSuffix));
                object = DatabasePropertyTestSetup.builtinAuthenticationNoTeardown(object, users[n - 1], pwSuffix);
                object = n == 1 ? TestConfiguration.singleUseDatabaseDecoratorNoShutdown(object) : TestConfiguration.sqlAuthorizationDecoratorSingleUse(object);
                baseTestSuite.addTest((Test)object);
            }
        }
        return baseTestSuite;
    }

    public void testEncrypt() throws SQLException {
        Connection connection;
        DboPowersTest.println("testEncrypt: auth=" + this._authLevel + " user=" + this.getTestConfiguration().getUserName());
        this.getConnection().close();
        this.bringDbDown();
        String string = this.getTestConfiguration().getUserName();
        String string2 = this.getTestConfiguration().getUserPassword();
        String string3 = "12345678";
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "dataEncryption=true;bootPassword=" + string3);
        JDBCDataSource.setBeanProperty(dataSource, "user", string);
        JDBCDataSource.setBeanProperty(dataSource, "password", string2);
        try {
            connection = dataSource.getConnection();
            this.vetCryptoAttempt(true, string, null);
        }
        catch (SQLException sQLException) {
            this.vetCryptoAttempt(true, string, sQLException);
            this.bringDbDown();
            return;
        }
        try {
            this.derby3038(connection);
        }
        catch (SQLException sQLException) {
            DboPowersTest.fail((String)("derby3038 regression: " + String.valueOf(sQLException)));
        }
        this.bringDbDown();
        this.bringDbUp(string3);
        this.bringDbDown();
    }

    public void testReEncrypt() throws SQLException {
        DboPowersTest.println("testReEncrypt: auth=" + this._authLevel + " user=" + this.getTestConfiguration().getUserName());
        this.getConnection().close();
        this.bringDbDown();
        String string = "12345678";
        this.doEncrypt(string);
        this.bringDbDown();
        String string2 = this.getTestConfiguration().getUserName();
        String string3 = this.getTestConfiguration().getUserPassword();
        String string4 = "87654321";
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "bootPassword=" + string + ";newBootPassword=" + string4);
        JDBCDataSource.setBeanProperty(dataSource, "user", string2);
        JDBCDataSource.setBeanProperty(dataSource, "password", string3);
        try {
            dataSource.getConnection();
            this.vetCryptoAttempt(true, string2, null);
        }
        catch (SQLException sQLException) {
            this.vetCryptoAttempt(true, string2, sQLException);
            this.bringDbDown();
            return;
        }
        this.bringDbDown();
        this.bringDbUp(string4);
        this.bringDbDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDecrypt() throws SQLException {
        DboPowersTest.println("testDecrypt: auth=" + this._authLevel + " user=" + this.getTestConfiguration().getUserName());
        this.getConnection().close();
        this.bringDbDown();
        String string = "conHippo08";
        this.doEncrypt(string);
        this.bringDbDown();
        String string2 = this.getTestConfiguration().getUserName();
        String string3 = this.getTestConfiguration().getUserPassword();
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "bootPassword=" + string + ";decryptDatabase=true");
        JDBCDataSource.setBeanProperty(dataSource, "user", string2);
        JDBCDataSource.setBeanProperty(dataSource, "password", string3);
        try {
            dataSource.getConnection();
            this.vetCryptoAttempt(false, string2, null);
        }
        catch (SQLException sQLException) {
            this.vetCryptoAttempt(false, string2, sQLException);
            return;
        }
        finally {
            this.bringDbDown();
        }
        this.bringDbUp(null);
        this.bringDbDown();
    }

    private void doEncrypt(String string) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "dataEncryption=true;bootPassword=" + string);
        JDBCDataSource.setBeanProperty(dataSource, "user", this._dbo);
        JDBCDataSource.setBeanProperty(dataSource, "password", this._dboPassword);
        dataSource.getConnection();
    }

    private void bringDbDown() {
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "shutdown=true");
        JDBCDataSource.setBeanProperty(dataSource, "user", this._dbo);
        JDBCDataSource.setBeanProperty(dataSource, "password", this._dboPassword);
        try {
            dataSource.getConnection();
            DboPowersTest.fail((String)"shutdown failed: expected exception");
        }
        catch (SQLException sQLException) {
            DboPowersTest.assertSQLState("database shutdown", "08006", sQLException);
        }
    }

    private void bringDbUp(String string) throws SQLException {
        String string2 = this.getTestConfiguration().getUserName();
        String string3 = this.getTestConfiguration().getUserPassword();
        DataSource dataSource = JDBCDataSource.getDataSource();
        if (string != null) {
            JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "bootPassword=" + string);
        }
        JDBCDataSource.setBeanProperty(dataSource, "user", string2);
        JDBCDataSource.setBeanProperty(dataSource, "password", string3);
        dataSource.getConnection().close();
    }

    private void vetCryptoAttempt(boolean bl, String string, SQLException sQLException) {
        this.vetAttempt(string, sQLException, "08004", bl ? "(re)encryption" : "decrypt");
    }

    private static Test dboHardUpgradeSuite(String string) {
        Test[] testArray = new Test[3];
        BaseTestSuite baseTestSuite = new BaseTestSuite("suite: security level=" + secLevelNames[0]);
        baseTestSuite.addTest((Test)new DboPowersTest("testHardUpgrade", 0, "foo", "bar"));
        testArray[0] = baseTestSuite;
        for (int i = 1; i <= 2; ++i) {
            testArray[i] = DboPowersTest.wrapHardUpgradeUserTests(i);
        }
        BaseTestSuite baseTestSuite2 = new BaseTestSuite("dboPowers:" + string);
        baseTestSuite2.addTest((Test)TestConfiguration.singleUseDatabaseDecorator(testArray[0]));
        baseTestSuite2.addTest((Test)TestConfiguration.singleUseDatabaseDecorator(testArray[1]));
        baseTestSuite2.addTest(TestConfiguration.sqlAuthorizationDecorator(testArray[2]));
        return baseTestSuite2;
    }

    private static Test wrapHardUpgradeUserTests(int n) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("usersSuite: security level=" + secLevelNames[n]);
        for (int i = 0; i < users.length; ++i) {
            baseTestSuite.addTest(TestConfiguration.changeUserDecorator((Test)new DboPowersTest("testHardUpgrade", n, users[n - 1][0], users[n - 1][0].concat(pwSuffix)), users[n - 1][i], users[n - 1][i].concat(pwSuffix)));
        }
        return DatabasePropertyTestSetup.builtinAuthentication((Test)baseTestSuite, users[n - 1], pwSuffix);
    }

    public void testHardUpgrade() throws SQLException {
        DboPowersTest.println("testHardUpgrade: auth=" + this._authLevel + " user=" + this.getTestConfiguration().getUserName());
        this.getConnection().close();
        this.bringDbDown();
        String string = this.getTestConfiguration().getUserName();
        String string2 = this.getTestConfiguration().getUserPassword();
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "upgrade=true");
        JDBCDataSource.setBeanProperty(dataSource, "user", string);
        JDBCDataSource.setBeanProperty(dataSource, "password", string2);
        try {
            dataSource.getConnection();
            this.vetHardUpgradeAttempt(string, null);
        }
        catch (SQLException sQLException) {
            this.vetHardUpgradeAttempt(string, sQLException);
        }
        this.bringDbDown();
    }

    private void vetHardUpgradeAttempt(String string, SQLException sQLException) {
        this.vetAttempt(string, sQLException, "08004", "hard upgrade");
    }

    private void vetAttempt(String string, SQLException sQLException, String string2, String string3) {
        switch (this._authLevel) {
            case 0: {
                DboPowersTest.assertEquals((String)(string3 + ", no authentication"), null, (Object)sQLException);
                break;
            }
            case 1: {
                DboPowersTest.assertEquals((String)(string3 + ", authentication"), null, (Object)sQLException);
                break;
            }
            case 2: {
                if ("TEST_DBO".equals(string)) {
                    DboPowersTest.assertEquals((String)(string3 + ", SQL authorization, db owner"), null, (Object)sQLException);
                    break;
                }
                String string4 = string3 + ", SQL authorization, not db owner";
                DboPowersTest.assertNotNull((String)(string4 + ": succeeded unexpectedly without exeption"), (Object)sQLException);
                DboPowersTest.assertSQLState(string4, string2, sQLException);
                break;
            }
            default: {
                DboPowersTest.fail((String)("test error: invalid authLevel: " + this._authLevel));
            }
        }
    }

    private void derby3038(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE PROCEDURE DERBY3038PROC () LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + DboPowersTest.class.getName() + ".derby3038Proc' READS SQL DATA");
            statement.executeUpdate("CALL DERBY3038PROC()");
        }
    }

    public static void derby3038Proc() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        connection.close();
    }
}

